/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webplugin.service.workflow.util;

import com.bokesoft.erp.webplugin.service.start.DBMetaBPMLoader;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.schemamgr.SchemaProProcess;
import com.bokesoft.yes.mid.schemamgr.SchemaProcess;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.bpm.total.ProcessMapType;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumnCollection;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.Item;
import java.util.HashSet;

public class DBWorkflowUtil {
    private static HashSet<String> buildedRightsTableSet = new HashSet();

    public static void hotDeploy(Long workflowBindOID, DefaultContext context) throws Throwable {
        if (workflowBindOID <= 0L) {
            return;
        }
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        IDictCacheProxy dictCache = context.getDictCache();
        Item bindItem = dictCache.getItem("BPMN_WorkflowBind", workflowBindOID.longValue());
        String workflowKey = TypeConvertor.toString((Object)bindItem.getValue("WorkflowKey"));
        long workflowID = DBWorkflowUtil.getDeployedWorkflowOID(workflowKey, context);
        Item workflowItem = dictCache.getItem("BPMN_WorkflowConfig", workflowID);
        int version = TypeConvertor.toInteger((Object)workflowItem.getValue("Version"));
        String name = TypeConvertor.toString((Object)workflowItem.getValue("Name"));
        DBMetaBPMLoader loader = new DBMetaBPMLoader();
        loader.loadDeployInfo(workflowKey, version, metaFactory);
        String sType = TypeConvertor.toString((Object)bindItem.getValue("BindType"));
        int type = ProcessMapType.parse((String)sType);
        boolean bDynamicBinding = TypeConvertor.toBoolean((Object)bindItem.getValue("IsDynamic"));
        loader.loadWorkflowBind(type, TypeConvertor.toString((Object)bindItem.getValue("FormKey")), workflowKey, TypeConvertor.toString((Object)bindItem.getValue("WorkflowKeyFormula")), bDynamicBinding, TypeConvertor.toString((Object)bindItem.getValue("StartAction")), TypeConvertor.toString((Object)bindItem.getValue("StartCaption")), TypeConvertor.toString((Object)bindItem.getValue("Perm")), metaFactory);
        String xml = DBWorkflowUtil.queryWorkflowXml(workflowID, context);
        loader.loadDBProfile(workflowKey, name, version, xml, metaFactory);
    }

    public static String queryWorkflowXml(Long workflowID, DefaultContext context) throws Throwable {
        String sql = "select content from EBPMN_WorkflowConfig where oid=?";
        DataTable table = context.getDBManager().execPrepareQuery(sql, new Object[]{workflowID});
        if (table.size() > 0) {
            table.first();
            return table.getString(0);
        }
        return "";
    }

    public static long getDeployedWorkflowOID(String workflowKey, DefaultContext context) throws Throwable {
        String sql = "select oid from EBPMN_WorkflowConfig where workflowkey=? and enable=?";
        DataTable table = context.getDBManager().execPrepareQuery(sql, new Object[]{workflowKey, 1});
        if (table.size() == 0) {
            return 0L;
        }
        if (table.size() == 1) {
            table.first();
            return table.getLong(0);
        }
        throw new Throwable("Workflow has deployed more then one:\u3010" + workflowKey + "\u3011");
    }

    public static boolean checkDBWorkflowExist(DefaultContext context) {
        try {
            return context.getDBManager().checkTableExist("EBPMN_WorkflowConfig") && context.getDBManager().checkTableExist("EBPMN_WorkflowBind");
        }
        catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
            return false;
        }
    }

    public static void buildBPMRelationTable(String objKey, DefaultContext context) throws Throwable {
        DBWorkflowUtil.buildBPMRelationTable(objKey, context, false);
    }

    public static void buildBPMRelationTable(String objKey, DefaultContext context, boolean isDesigner) throws Throwable {
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        MetaDataObject metaDataObject = null;
        if (metaFactory.hasMetaForm(objKey)) {
            MetaForm metaForm = metaFactory.getMetaForm(objKey);
            if (metaForm.getDataSource() != null) {
                metaDataObject = metaForm.getDataSource().getDataObject();
            }
        } else {
            metaDataObject = metaFactory.getDataObject(objKey);
        }
        if (metaDataObject != null) {
            IDBManager dbManager = context.getDBManager();
            SchemaProcess schemaProcess = null;
            if (dbManager != null) {
                MetaSchemaTable metaRightsTable;
                if (!metaDataObject.getMainTable().containsKey("InstanceID")) {
                    schemaProcess = new SchemaProcess();
                    MetaSchemaTable metaSchemaTable = new MetaSchemaTable();
                    metaSchemaTable.setKey(metaDataObject.getMainTableKey());
                    MetaSchemaColumnCollection columnCollection = new MetaSchemaColumnCollection();
                    metaSchemaTable.setColumnCollection(columnCollection);
                    MetaSchemaColumn column = new MetaSchemaColumn();
                    column.setKey("InstanceID");
                    column.setDataType(1010);
                    columnCollection.add((KeyPairMetaObject)column);
                    column.setAutoGen(metaDataObject.isAutoGen());
                    schemaProcess.tableRebuild(dbManager, metaSchemaTable);
                    schemaProcess.tableRepartition(dbManager, metaSchemaTable);
                }
                if ((metaRightsTable = metaDataObject.getFormRightsTable()) != null && !buildedRightsTableSet.contains(metaRightsTable.getKey()) || isDesigner) {
                    if (schemaProcess == null) {
                        schemaProcess = new SchemaProcess();
                    }
                    SchemaProProcess.dataObjectProProcess((IDBManager)context.getDBManager(), (MetaSchemaTable)metaRightsTable);
                    schemaProcess.tableRebuild(dbManager, metaRightsTable);
                    schemaProcess.tableRepartition(dbManager, metaRightsTable);
                    buildedRightsTableSet.add(metaRightsTable.getKey());
                }
                if (schemaProcess != null) {
                    dbManager.commit();
                }
            }
        }
    }

    public static void buildAutoOperation(String objKey, DefaultContext context) throws Throwable {
        MetaOperation metaOperation;
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        if (!metaFactory.hasMetaForm(objKey)) {
            return;
        }
        MetaForm metaForm = metaFactory.getMetaForm(objKey);
        MetaOperationCollection operationCollection = metaForm.getOperationCollection();
        if (operationCollection == null) {
            return;
        }
        MetaOperationCollection newMetaOperationCollection = new MetaOperationCollection();
        if (!operationCollection.contains("WFLog") && !operationCollection.contains("ShowWFLog")) {
            metaOperation = new MetaOperation();
            metaOperation.setKey("WFLog");
            metaOperation.setRefKey("ShowWFLog");
            metaOperation.setCaption("\u5ba1\u6279\u8bb0\u5f55");
            metaOperation.setActivity("Y16");
            operationCollection.add((KeyPairCompositeObject)metaOperation);
        }
        if (!operationCollection.contains("BPM")) {
            metaOperation = new MetaOperation();
            metaOperation.setCaption("BPM");
            metaOperation.setKey("BPM");
            metaOperation.setTag("BPM");
            metaOperation.setActivity("Y16");
            newMetaOperationCollection.add((KeyPairCompositeObject)metaOperation);
        }
        if (!operationCollection.contains("WORKITEM")) {
            metaOperation = new MetaOperation();
            metaOperation.setCaption("WORKITEM");
            metaOperation.setKey("WORKITEM");
            metaOperation.setTag("WORKITEM");
            metaOperation.setActivity("Y16");
            newMetaOperationCollection.add((KeyPairCompositeObject)metaOperation);
        }
        if (!operationCollection.contains("BPM") || !operationCollection.contains("WORKITEM")) {
            for (KeyPairCompositeObject object : operationCollection) {
                newMetaOperationCollection.add(object);
            }
            metaForm.setOperationCollection(newMetaOperationCollection);
        }
    }

    public static void removeAutoOperation(String objKey, DefaultContext context) throws Throwable {
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        if (!metaFactory.hasMetaForm(objKey)) {
            return;
        }
        MetaForm metaForm = metaFactory.getMetaForm(objKey);
        MetaOperationCollection operationCollection = metaForm.getOperationCollection();
        operationCollection.remove("BPM");
        operationCollection.remove("WORKITEM");
        operationCollection.remove("WFLog");
    }
}

