/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webplugin.service.workflow.sync;

import com.bokesoft.erp.webplugin.service.cache.IVersionCacheChangeListener;
import com.bokesoft.erp.webplugin.service.start.DBMetaBPMLoader;
import com.bokesoft.erp.webplugin.service.workflow.util.DBWorkflowUtil;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMapCollection;
import com.bokesoft.yigo.meta.bpm.total.ProcessMapType;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.dict.Item;

public class DBWorkflowBindChangeListener
implements IVersionCacheChangeListener {
    @Override
    public void fireAdd(String soid, DefaultContext context) {
        this.fireUpdate(soid, context);
    }

    @Override
    public void fireDelete(String soid, DefaultContext context) {
    }

    @Override
    public void fireUpdate(String soid, DefaultContext context) {
        long oid = TypeConvertor.toLong((Object)soid);
        if (oid <= 0L) {
            return;
        }
        IMetaFactory metaFactory = context.getVE().getMetaFactory();
        IDictCacheProxy dictCache = context.getDictCache();
        try {
            DBMetaBPMLoader loader = new DBMetaBPMLoader();
            Item bindItem = dictCache.getItem("BPMN_WorkflowBind", oid);
            if (bindItem == null) {
                return;
            }
            String billKey = TypeConvertor.toString((Object)bindItem.getValue("FormKey"));
            int enable = TypeConvertor.toInteger((Object)bindItem.getValue("Enable"));
            if (enable == 1) {
                String workflowKey = TypeConvertor.toString((Object)bindItem.getValue("WorkflowKey"));
                String sType = TypeConvertor.toString((Object)bindItem.getValue("BindType"));
                int type = ProcessMapType.parse((String)sType);
                boolean bDynamicBinding = TypeConvertor.toBoolean((Object)bindItem.getValue("IsDynamic"));
                loader.loadWorkflowBind(type, billKey, workflowKey, TypeConvertor.toString((Object)bindItem.getValue("WorkflowKeyFormula")), bDynamicBinding, TypeConvertor.toString((Object)bindItem.getValue("StartAction")), TypeConvertor.toString((Object)bindItem.getValue("StartCaption")), TypeConvertor.toString((Object)bindItem.getValue("Perm")), metaFactory);
            } else {
                loader.removeLoadWorkflowBind(billKey, metaFactory);
                DBWorkflowUtil.removeAutoOperation(billKey, context);
            }
            MetaProcessMapCollection metaProcessMapCollection = metaFactory.getMetaBPM().getMetaProcessMapCollection();
            for (MetaProcessMap metaProcessMap : metaProcessMapCollection) {
                DBWorkflowUtil.buildBPMRelationTable(metaProcessMap.getKey(), context);
                DBWorkflowUtil.buildAutoOperation(metaProcessMap.getKey(), context);
            }
        }
        catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
        }
    }
}

