/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webplugin.service.dictformula;

import com.bokesoft.erp.webplugin.service.dictformula.DictFormula;
import com.bokesoft.erp.webplugin.service.dictformula.EDictFormulaType;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FormulaDefine {
    private static final FormulaDefine instance = new FormulaDefine();
    private static final String ATTRIBUTE_Code = "Code";
    private static final String ATTRIBUTE_Name = "Name";
    private static final String ATTRIBUTE_Define = "Define";
    private static final String ATTRIBUTE_FormulaType = "FormulaType";
    private static final String ATTRIBUTE_FormulaSourceType = "SourceType";
    private static final String ATTRIBUTE_Group = "Group";
    private static final String ATTRIBUTE_Type = "Type";
    ArrayList<DictFormula> dictFormulas = new ArrayList();

    private FormulaDefine() {
        this.load();
    }

    public static FormulaDefine getInstance() {
        return instance;
    }

    public ArrayList<DictFormula> getDictFormulas() {
        return this.dictFormulas;
    }

    private void load() {
        InputStream in = null;
        try {
            try {
                in = FormulaDefine.class.getResourceAsStream("FormulaDefine.xml");
                Document document = null;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.parse(in);
                Element rootElement = document.getDocumentElement();
                this.trans(rootElement, "");
            }
            catch (Exception e) {
                LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e2) {
                    LogSvr.getInstance().error(e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void trans(Element elem, String code) {
        NodeList formulaItemCollection = elem.getElementsByTagName("FormulaItem");
        int len = formulaItemCollection.getLength();
        int i = 0;
        while (i < len) {
            Element formulaItemElem = (Element)formulaItemCollection.item(i);
            NodeList paras = formulaItemElem.getElementsByTagName("Para");
            HashMap<String, Object> allAttrs = this.getAllAttrs(formulaItemElem, paras);
            DictFormula dictFormula = this.createDictFormula(formulaItemElem, allAttrs, code);
            this.dictFormulas.add(dictFormula);
            ++i;
        }
    }

    private HashMap<String, Object> getAllAttrs(Element formulaItemElem, NodeList paras) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        String name = formulaItemElem.getAttribute(ATTRIBUTE_Name);
        String formulaType = formulaItemElem.getAttribute(ATTRIBUTE_FormulaType);
        String formulaSourceType = formulaItemElem.getAttribute(ATTRIBUTE_FormulaSourceType);
        String group = formulaItemElem.getAttribute(ATTRIBUTE_Group);
        String define = formulaItemElem.getAttribute(ATTRIBUTE_Define);
        attrs.put("name", name);
        attrs.put("define", define);
        attrs.put("formulaType", formulaType);
        attrs.put("formulaSourceType", formulaSourceType);
        attrs.put("group", group);
        if (paras.getLength() != 0) {
            ArrayList paraCollectionList = new ArrayList();
            int i = 0;
            while (i < paras.getLength()) {
                Element paraElem = (Element)paras.item(i);
                String type = paraElem.getAttribute(ATTRIBUTE_Type);
                String parasDefine = paraElem.getAttribute(ATTRIBUTE_Define);
                HashMap<String, String> paraMap = new HashMap<String, String>();
                paraMap.put(ATTRIBUTE_Type, type);
                paraMap.put("ParasDefine", parasDefine);
                paraCollectionList.add(paraMap);
                ++i;
            }
            attrs.put("paras", paraCollectionList);
        }
        return attrs;
    }

    private DictFormula createDictFormula(Element elem, HashMap<String, Object> allAttrs, String code) {
        code = StringUtil.isEmptyStr((String)elem.getAttribute(ATTRIBUTE_Code)) ? code : elem.getAttribute(ATTRIBUTE_Code);
        DictFormula dictFormula = new DictFormula(code);
        dictFormula.setName((String)allAttrs.get("name"));
        dictFormula.setDefine((String)allAttrs.get("define"));
        if (allAttrs.get("formulaType").equals(EDictFormulaType.VALUE.toString())) {
            dictFormula.setFormulaType(EDictFormulaType.VALUE);
        } else if (allAttrs.get("formulaType").equals(EDictFormulaType.VALUE_CONDITION.toString())) {
            dictFormula.setFormulaType(EDictFormulaType.VALUE_CONDITION);
        } else if (allAttrs.get("formulaType").equals(EDictFormulaType.ACTION.toString())) {
            dictFormula.setFormulaType(EDictFormulaType.ACTION);
        } else if (allAttrs.get("formulaType").equals(EDictFormulaType.PARTICIPATOR.toString())) {
            dictFormula.setFormulaType(EDictFormulaType.PARTICIPATOR);
        }
        String formulaSourceType = allAttrs.get("formulaSourceType").toString();
        if (formulaSourceType.compareToIgnoreCase("Formula") == 0) {
            dictFormula.setFormulaSourceType(1);
        } else if (formulaSourceType.compareToIgnoreCase("SQL") == 0) {
            dictFormula.setFormulaSourceType(2);
        } else if (formulaSourceType.compareToIgnoreCase("CONST") == 0) {
            dictFormula.setFormulaSourceType(3);
        } else if (formulaSourceType.compareToIgnoreCase("Grid") == 0) {
            dictFormula.setFormulaSourceType(4);
        }
        dictFormula.setGroup((String)allAttrs.get("group"));
        ArrayList paraList = (ArrayList)allAttrs.get("paras");
        if (paraList != null) {
            int i = 0;
            while (i < paraList.size()) {
                HashMap paras = (HashMap)paraList.get(i);
                dictFormula.addPara(paras);
                ++i;
            }
        }
        return dictFormula;
    }
}

