/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webplugin.service.common;

import com.bokesoft.erp.entity.util.EntityDesigerContextAction;
import com.bokesoft.erp.webplugin.service.dictformula.DictFormula;
import com.bokesoft.erp.webplugin.service.dictformula.DictFormulaManager;
import com.bokesoft.erp.webplugin.service.dictformula.EDictFormulaType;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.erp.annotation.FunctionRunOnlyInServer;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocument;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.OIDAllocator;
import com.bokesoft.yigo.struct.datatable.DataTable;

public class DesignShortNameFunction
extends EntityDesigerContextAction {
    public DesignShortNameFunction(RichDocumentContext _context) {
        super(_context);
    }

    @FunctionRunOnlyInServer
    public Object GetMainTableName(String formKey) throws Throwable {
        MetaForm metaForm = this._context.getMetaFactory().getMetaForm(formKey);
        MetaTable metaTable = metaForm.getDataSource().getDataObject().getMainTable();
        String mainTableName = StringUtil.isBlankOrNull((String)metaTable.getDBTableName()) ? metaTable.getKey() : metaTable.getDBTableName();
        return mainTableName;
    }

    @FunctionRunOnlyInServer
    public String GenNewNo(String dataObjectKey, String prefix) throws Throwable {
        return this.GenNewNo(dataObjectKey, prefix, "0000000000");
    }

    @FunctionRunOnlyInServer
    public String GenNewNo(String dataObjectKey, String prefix, String format) throws Throwable {
        OIDAllocator allocator = new OIDAllocator((DefaultContext)this.getMidContext());
        RichDocument document = (RichDocument)this.getMidContext().getDocument();
        String querySql = "select WorkflowKey from EBPMN_WorkflowConfig where ParentID = (select oid from EBPMN_WorkflowConfig where Code =? )";
        DataTable table = this.getMidContext().getDBManager().execPrepareQuery(querySql, new Object[]{"000"});
        return this.getNewWorkFlowKey(allocator, document, table, dataObjectKey, prefix, format);
    }

    public String getNewWorkFlowKey(OIDAllocator allocator, RichDocument document, DataTable table, String dataObjectKey, String prefix, String format) throws Throwable {
        if (document.isNew()) {
            int seq = allocator.applyNewSequenceID(dataObjectKey, prefix);
            String newWorkFlowKey = String.format(String.valueOf(prefix) + "%0" + format.length() + "d", seq);
            boolean flag = false;
            int i = 0;
            while (i < table.size()) {
                String workFlowKey = table.getString(i, "WorkFlowKey");
                if (newWorkFlowKey.equals(workFlowKey)) {
                    flag = true;
                    break;
                }
                ++i;
            }
            if (flag) {
                return this.getNewWorkFlowKey(allocator, document, table, dataObjectKey, prefix, format);
            }
            return newWorkFlowKey;
        }
        return "";
    }

    @FunctionRunOnlyInServer
    public Object RunDictFormula(String code) throws Throwable {
        DictFormula dictFormula = DictFormulaManager.getDictFormula(code, this._context);
        EDictFormulaType formulaType = dictFormula.getFormulaType();
        if (formulaType == EDictFormulaType.PARTICIPATOR && dictFormula.getFormulaSourceType() == 4) {
            return dictFormula.getOperators();
        }
        String define = dictFormula.getDefine();
        if (StringUtil.isBlankOrNull((String)define)) {
            return "";
        }
        if (dictFormula.getFormulaSourceType() == 3) {
            if ("true".equalsIgnoreCase(define.trim())) {
                return true;
            }
            if ("false".equalsIgnoreCase(define.trim())) {
                return false;
            }
            return define;
        }
        if (dictFormula.getFormulaSourceType() == 2) {
            SqlString sql = SqlString.format((Object)define, (Object[])new Object[]{dictFormula.getParas()});
            if (dictFormula.getFormulaType() == EDictFormulaType.ACTION) {
                this._context.executeUpdate(sql);
                return "";
            }
            return this._context.getResultSet(sql);
        }
        String formula = SimpleStringFormat.format((String)define, (Object[])new Object[]{dictFormula.getParas()});
        return this._context.evalFormula(formula, "");
    }
}

