/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webplugin.service.cache;

import com.bokesoft.erp.webplugin.service.cache.IVersionCacheChangeListener;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class AsyncVesionCache {
    private static final HashMap<String, AsyncVesionCache> mapCaches = new HashMap();
    private String BASE = "__BASE__";
    private static final Long VER_NEW = -1L;
    private HashMap<String, Long> localCache = new HashMap();
    private ICache<Long> onlineCache = null;
    private IVersionCacheChangeListener listener = null;
    private boolean isSyncing = false;

    private AsyncVesionCache(String modulekey) {
        this.onlineCache = CacheFactory.getInstance().createCache("ERP_" + modulekey);
        this.BASE = String.valueOf(this.BASE) + modulekey;
        this.initItem(this.BASE);
    }

    public void setVersionChangeListener(IVersionCacheChangeListener listener) {
        this.listener = listener;
    }

    public void initItem(String key) {
        this.localCache.put(key, 0L);
        this.onlineCache.put(key, (Object)0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(String key) {
        this.incOnlineBaseVer();
        ICache<Long> iCache = this.onlineCache;
        synchronized (iCache) {
            if (this.onlineCache.contains(key)) {
                long onlineVer = (Long)this.onlineCache.get(key);
                this.onlineCache.put(key, (Object)(onlineVer + 1L));
            } else {
                this.onlineCache.put(key, (Object)VER_NEW);
            }
        }
    }

    public void add(String key) {
        this.incOnlineBaseVer();
        this.onlineCache.put(key, (Object)VER_NEW);
    }

    public void delete(String key) {
        this.incOnlineBaseVer();
        this.onlineCache.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incOnlineBaseVer() {
        ICache<Long> iCache = this.onlineCache;
        synchronized (iCache) {
            long onlinBaseVer = (Long)this.onlineCache.get(this.BASE);
            this.onlineCache.put(this.BASE, (Object)(onlinBaseVer + 1L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(DefaultContext context) {
        try {
            Long localBaseVersion = this.localCache.get(this.BASE);
            Long onlineBaseVersion = (Long)this.onlineCache.get(this.BASE);
            if (localBaseVersion.equals(onlineBaseVersion) || this.isSyncing) {
                return;
            }
            this.isSyncing = true;
            HashSet<String> newKeys = new HashSet<String>();
            ICache<Long> iCache = this.onlineCache;
            synchronized (iCache) {
                long version = 0L;
                for (String key : this.onlineCache.getKeys()) {
                    version = (Long)this.onlineCache.get(key);
                    if (version != VER_NEW && this.localCache.containsKey(key)) continue;
                    newKeys.add(key);
                }
            }
            HashSet<String> removeKeys = new HashSet<String>();
            for (Map.Entry<String, Long> entry : this.localCache.entrySet()) {
                String itemKey = entry.getKey();
                if (this.BASE.equalsIgnoreCase(itemKey)) continue;
                if (this.listener != null && !this.onlineCache.contains(itemKey)) {
                    removeKeys.add(itemKey);
                    continue;
                }
                Long onlineVersion = (Long)this.onlineCache.get(itemKey);
                if (this.listener == null || entry.getValue().equals(onlineVersion)) continue;
                this.listener.fireUpdate(itemKey, context);
                entry.setValue(onlineVersion);
            }
            for (String itemKey : removeKeys) {
                this.listener.fireDelete(itemKey, context);
                this.localCache.remove(itemKey);
            }
            for (String itemKey : newKeys) {
                if (this.listener != null) {
                    this.listener.fireAdd(itemKey, context);
                }
                this.initItem(itemKey);
            }
            this.localCache.put(this.BASE, onlineBaseVersion);
        }
        finally {
            this.isSyncing = false;
        }
    }

    public static synchronized AsyncVesionCache getInstance(String cacheKey) {
        AsyncVesionCache cache = mapCaches.get(cacheKey);
        if (cache == null) {
            cache = new AsyncVesionCache(cacheKey);
            mapCaches.put(cacheKey, cache);
        }
        return cache;
    }
}

