/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.webdesigner.language.infrastructure.index;

import com.bokesoft.erp.webdesigner.language.common.Constants;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndex;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndexBuilder;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndexLoader;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.KeyIndexWriter;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.dataelement.DataElementIndexBuilder;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.dataelement.DataElementIndexLoader;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.dataelement.DataElementIndexWriter;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.dataobject.DataObjectIndexBuilder;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.dataobject.DataObjectIndexLoader;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.dataobject.DataObjectIndexWriter;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.dict.DictIndexBuilder;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.dict.DictIndexLoader;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.dict.DictIndexWriter;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.domain.DomainIndexBuilder;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.domain.DomainIndexLoader;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.domain.DomainIndexWriter;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.macro.MacroIndexBuilder;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.macro.MacroIndexLoader;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.macro.MacroIndexWriter;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.table.TableIndexBuilder;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.table.TableIndexLoader;
import com.bokesoft.erp.webdesigner.language.infrastructure.index.table.TableIndexWriter;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public enum KeyIndexEnum {
    DICT("Dict", "\u5b57\u5178", new DictIndexLoader(), new DictIndexBuilder(), new DictIndexWriter()),
    TABLE("Table", "\u6570\u636e\u8868", new TableIndexLoader(), new TableIndexBuilder(), new TableIndexWriter()),
    MACRO("Macro", "\u5b8f\u516c\u5f0f", new MacroIndexLoader(), new MacroIndexBuilder(), new MacroIndexWriter()),
    DOMAIN("Domain", "\u57df", new DomainIndexLoader(), new DomainIndexBuilder(), new DomainIndexWriter()),
    DATA_ELEMENT("DataElement", "\u6570\u636e\u5143\u7d20", new DataElementIndexLoader(), new DataElementIndexBuilder(), new DataElementIndexWriter()),
    DATA_OBJECT("DataObject", "\u6570\u636e\u5bf9\u8c61", new DataObjectIndexLoader(), new DataObjectIndexBuilder(), new DataObjectIndexWriter());

    private final String code;
    private final String name;
    private final KeyIndexLoader<? extends KeyIndex> loader;
    private final KeyIndexBuilder<? extends KeyIndex> builder;
    private final KeyIndexWriter<? extends KeyIndex> writer;

    private KeyIndexEnum(String string2, String string3, KeyIndexLoader<? extends KeyIndex> keyIndexLoader, KeyIndexBuilder<? extends KeyIndex> keyIndexBuilder, KeyIndexWriter<? extends KeyIndex> keyIndexWriter) {
        this.code = string2;
        this.name = string3;
        this.loader = keyIndexLoader;
        this.builder = keyIndexBuilder;
        this.writer = keyIndexWriter;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public KeyIndexLoader<? extends KeyIndex> getLoader() {
        return this.loader;
    }

    public KeyIndexBuilder<? extends KeyIndex> getBuilder() {
        return this.builder;
    }

    public KeyIndexWriter<? extends KeyIndex> getWriter() {
        return this.writer;
    }

    public File getDefineFile() {
        return FileUtils.getFile((File)Constants.INDEX_BASE_DIR, (String[])new String[]{String.valueOf(this.getCode()) + "Define.xml"});
    }

    public File getReferFile() {
        return FileUtils.getFile((File)Constants.INDEX_BASE_DIR, (String[])new String[]{String.valueOf(this.getCode()) + "Refer.xml"});
    }

    public static KeyIndexEnum getEnum(String string) {
        KeyIndexEnum[] keyIndexEnumArray;
        KeyIndexEnum[] keyIndexEnumArray2 = keyIndexEnumArray = KeyIndexEnum.values();
        int n = keyIndexEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyIndexEnum keyIndexEnum = keyIndexEnumArray2[n2];
            if (StringUtils.equals((CharSequence)keyIndexEnum.getCode(), (CharSequence)string)) {
                return keyIndexEnum;
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }
}

