package com.bokesoft.yes.design.xml.dom;

import java.awt.Image;
import java.io.File;

public interface IMetaResourceResolver extends IFileResolver {
	public static final int BILL_CONFIG = 0;
	public static final int ALL_MENU_DEF = 1;
	public static final int SUB_SYSTEM_DEF = 2;
	public static final int SCM_CONFIG = 3;
	public static final int ITEM_CONFIG = 4;
	public static final int DS_CONFIG = 5;
	public static final int MAP_CONFIG = 6;
	public static final int BPM_CONFIG = 7;
	public static final String Module = "Module";

	public static String BILL_PATH_POSTFIX = Module + File.separator + "SCM" + File.separator + "Bill" + File.separator;
	public static String ALLMENU_PATH_POSTFIX = "System" + File.separator + "flash" + File.separator;
	public static String SUBSYSTEM_PATH_POSTFIX = "SubSystem" + File.separator;
	public static String SCM_PATH_POSTFIX = Module + File.separator + "SCM" + File.separator;
	/** 配置对象缓冲(BillMetaCache)路径 */
	public static String BMC_PATH_POSTFIX = SCM_PATH_POSTFIX + "bmc" + File.separator;
	public static String ITEM_PATH_POSTFIX = Module + File.separator + "Item" + File.separator;
	public static String DS_PATH_POSTFIX = Module + File.separator + "SCM" + File.separator + "Bill" + File.separator + "DataSource"
			+ File.separator;
	public static String MAP_PATH_POSTFIX = Module + File.separator + "SCM" + File.separator + "Map" + File.separator;
	public static String BPM_PATH_POSTFIX = Module + File.separator + "SCM" + File.separator + "BPM" + File.separator;

	// 扩充服务
	public boolean createNewConfig(String path);

	public boolean createNewFile(String path, int type);

	public String getConfigURL();

	public Image loadImage(String path);

	public boolean saveImage(String path, byte[] data);

	public boolean isLocalDesign();
}
