package com.bokesoft.yes.design.utils;

import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DocumentRecordDirty;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class publicMethodUtil {
	// 当前表单是MetaForm还是MetaDataObject
	public static TwoTuple<MetaForm, MetaDataObject> MetaFormOrMetaDataObject(String formKey) throws Throwable {
		MetaForm metaForm = null;
		MetaDataObject metaDataObject = null;
		String pathByDataObject = LoadFileTree.getPathByDataObject(formKey);
		String pathByFormKey = LoadFileTree.getPathByFormKey(formKey);
		if (StringUtils.isNotEmpty(pathByFormKey)) {//是表单
				metaForm = MetaFactory.getGlobalInstance().getMetaForm(formKey);
		} else if (StringUtils.isNotEmpty(pathByDataObject)) {//数据对象
			metaDataObject = MetaFactory.getGlobalInstance().getDataObject(formKey);
		}
		TwoTuple<MetaForm, MetaDataObject> two = new TwoTuple<MetaForm, MetaDataObject>(metaForm, metaDataObject);
		return two;
	}

	/**
	 * @param sourceFieldKey
	 * @param isExist
	 * @param key
	 * @param targetKey
	 * @return 类型不同 返回 true 类型相同返回 false
	 * @throws Throwable
	 */
	public static boolean isExist(String sourceFieldKey,
								  boolean isExist,
								  String key,
								  String targetKey,
								  String targetFieldKey, ResponseResult result) throws Throwable {
		// 源
		TwoTuple<MetaForm, MetaDataObject> source = publicMethodUtil.MetaFormOrMetaDataObject(key);
		MetaForm sourceMetaForm = null;
		MetaDataObject sourceMetaDataObject = null;
		sourceMetaForm = source.metaForm;
		sourceMetaDataObject = source.metaDataObject;
		MetaDataObject sourceDataObject = Objects.isNull(sourceMetaDataObject) ? sourceMetaForm.getDataSource().getDataObject() : sourceMetaDataObject;
		//目
		TwoTuple<MetaForm, MetaDataObject> target = publicMethodUtil.MetaFormOrMetaDataObject(targetKey);
		MetaForm targetMetaForm = null;
		MetaDataObject targetMetaDataObject = null;
		targetMetaForm = target.metaForm;
		targetMetaDataObject = target.metaDataObject;
		MetaDataObject targetDataObject;
		if (sourceMetaForm !=null){
			 targetDataObject = Objects.isNull(targetMetaDataObject) ? sourceMetaForm.getDataSource().getDataObject() : targetMetaDataObject;
		}else {
			 targetDataObject = Objects.isNull(targetMetaDataObject) ? null : targetMetaDataObject;
		}
		if (sourceMetaForm != null && targetMetaForm != null) {//适用于数据映射
			MetaColumn sourceColumn = IDLookup.reloadIDLookup(sourceMetaForm).getMetaColumnByFieldKey(sourceFieldKey);
			MetaColumn targetColumn = IDLookup.reloadIDLookup(targetMetaForm).getMetaColumnByFieldKey(targetFieldKey);
			if (sourceColumn != null && targetColumn != null) {
				isExist = sourceColumn.getDataType() != targetColumn.getDataType();
			}else {
				return false;
			}
			if (isExist) {
				result.setMsg("源字段和目标字段数据数据类型不匹配,无法创建连接");
			}
		} else {//适用于数据迁移
			for (MetaTable table : Objects.requireNonNull(sourceDataObject != null ? sourceDataObject.getTableCollection() : null)) {
				MetaColumn sourceColumn = sourceDataObject.findColumn(table.getKey(), sourceFieldKey);
				if (sourceColumn != null) {
					for (MetaTable metaTable : Objects.requireNonNull(targetDataObject != null ? targetDataObject.getTableCollection() : null)) {
						MetaColumn targetColumn = targetDataObject.findColumn(metaTable.getKey(), targetFieldKey);
						if (targetColumn != null) {
							isExist = sourceColumn.getDataType() != targetColumn.getDataType();
							if (isExist) {
								result.setMsg("源字段和目标字段数据数据类型不匹配,无法创建连接");
							}
							break;
						} else {
							isExist = false;
						}
					}
				}
			}
		}

		return isExist;
	}

	/**
	 * @param table
	 * @param nodeName
	 * @param formKey
	 * @param root
	 * @return 返回当前xml中已经存在的字段
	 */
	public static Set<String> getNodes(MetaTable table,
									   String nodeName,
									   String formKey,
									   TagNode root) {
		boolean isMap = ConstantUtil.MAP.equals(root.getTagName());
		List<TagNode> nodes;
		Set<String> set = new HashSet<String>();
		if (ConstantUtil.SOURCE_TABLE_COLLECTION.equals(nodeName)) {
			for (TagNode tagNode : root.findNodesByTagName(ConstantUtil.SOURCE_TABLE)) {
				if (tagNode.getAttributes().get(isMap ? ConstantUtil.KEY : ConstantUtil.TABLE_KEY).equals(table.getKey())) {
					nodes = tagNode.findNodesByTagName(ConstantUtil.SOURCE_FIELD);
					assert nodes != null : "nodes is null";
					for (TagNode node : nodes) {
						set.add(node.getAttributes().get(ConstantUtil.DEFINITION));
					}
				}
			}
		} else if (ConstantUtil.TARGET_TABLE_COLLECTION.equals(nodeName)) {
			for (TagNode tagNode : root.findNodesByTagName(ConstantUtil.TARGET_TABLE)) {
				if (table.getKey().equals(tagNode.getAttributes().get(isMap ? ConstantUtil.KEY : ConstantUtil.TABLE_KEY))) {
					nodes = tagNode.findNodesByTagName(ConstantUtil.TARGET_FIELD);
					assert nodes != null : "nodes is null";
					for (TagNode node : nodes) {
						set.add(node.getAttributes().get(isMap ? ConstantUtil.DEFINITION : ConstantUtil.FIELD_KEY));
					}
				}
			}
		} else if (ConstantUtil.FEEDBACK_COLLECTION.equals(nodeName) && isMap) {
			for (TagNode object : root.findNodesByTagName(ConstantUtil.FEEDBACK_OBJECT)) {
				if (object.getAttributes().get(ConstantUtil.FORM_KEY).equals(formKey)) {
					for (TagNode tagNode : object.findNodesByTagName(ConstantUtil.FEEDBACK_TABLE)) {
						if (tagNode.getAttributes().get(ConstantUtil.TABLE_KEY).equals(table.getKey())) {
							nodes = tagNode.findNodesByTagName(ConstantUtil.FEEDBACK_FIELD);
							assert nodes != null : "nodes is null";
							for (TagNode node : nodes) {
								set.add(node.getAttributes().get(ConstantUtil.FIELD_KEY));
							}
						}
					}
				}
			}
		}
		return set;
	}

	/**
	 * create time: 2020/11/23 14:28
	 * Affect :处理上下文，转换成需要的数据格式
	 *
	 * @return
	 * @Param: null
	 */
	public static RichDocumentContext processParentContext(DefaultContext context, DocumentRecordDirty formDocument) throws Throwable {
		context.setFormKey(formDocument.getMetaForm().getKey());
		context.setDocument(formDocument);
		RichDocumentContext parentContext = (RichDocumentContext) context.getParentContext();
		if (Objects.isNull(parentContext)) {
			parentContext = new RichDocumentContext(context);
			parentContext.setDocument(formDocument);
			context.setParentContext(parentContext);
		}
		return parentContext;
	}
}
