package com.bokesoft.yes.design.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;


/**
 * dataTable工具类
 */
public class WebDesignerDataTableUtil {
	public static void appendAll(DataTable src, DataTable tgt) {
		appendAll(src, tgt, null);
	}

	public static void appendAll(DataTable src, DataTable tgt, String ignoreColKeys) {
		ignoreColKeys = "," + ignoreColKeys + ",";
		DataTableMetaData srcMetaData = src.getMetaData();
		DataTableMetaData tgtMetaData = tgt.getMetaData();
		List<Integer> srcIndexArray = new ArrayList<>();
		List<Integer> tgtIndexArray = new ArrayList<>();
		int size = srcMetaData.getColumnCount();
		for (int i = 0; i < size; i++) {
			ColumnInfo colInfo = srcMetaData.getColumnInfo(i);
			int tgtIndex = tgtMetaData.findColumnIndexByKey(colInfo.getColumnKey());
			if (tgtIndex != -1) {
				srcIndexArray.add(i);
				tgtIndexArray.add(tgtIndex);
			}
		}

		size = srcIndexArray.size();
		int length = src.size();
		for (int index = 0; index < length; index++) {
			tgt.append();
			for (int i = 0; i < size; ++i) {
				if (!StringUtil.isBlankOrNull(ignoreColKeys)
						&& ignoreColKeys.contains("," + srcMetaData.getColumnInfo(i).getColumnKey() + ",")) {
					continue;
				}
				tgt.setObject(tgtIndexArray.get(i), src.getObject(index, srcIndexArray.get(i)));
			}
		}
	}
	public static void setSequence(DataTable dataTable) {
		int sequenceColumnIndex = dataTable.getMetaData().findColumnIndexByKey(SystemField.SEQUENCE_SYS_KEY);
		if (sequenceColumnIndex >= 0) {
			for (int i = 0; i < dataTable.size(); i++) {
				dataTable.setObject(i, SystemField.SEQUENCE_SYS_KEY, i+1);
			}
		}

	}

	public static DataTable generateDataTable(MetaTable metaTable) {
		DataTable table = new DataTable();
		table.setKey(metaTable.getKey());
		table.setCheckLength(metaTable.isPersist());
		Iterator<MetaColumn> it = metaTable.iterator();
		MetaColumn metaColumn;
		int index = 0;
		while (it.hasNext()) {
			metaColumn = it.next();
			if (!metaColumn.isHidden()) {
				String columnKey = metaColumn.getKey();
				ColumnInfo columnInfo = new ColumnInfo(columnKey, metaColumn.getDataType());
				columnInfo.setAccessControl(metaColumn.isAccessControl());
				columnInfo.setPrimary(metaColumn.getIsPrimary());
				columnInfo.setDefaultValue(metaColumn.getDefaultValue());
				columnInfo.setScale(metaColumn.getScale());
				columnInfo.setLength(metaColumn.getLength());
				table.addColumn(index, columnInfo);
				++index;
			}
		}
		return table;
	}

}