package com.bokesoft.yes.design.utils;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormActionMap;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;

import java.util.Objects;

public class MetaFormActionMapEx extends MetaActionMap {
	/** 表单事件映射的单体实例 */
	private static MetaFormActionMapEx instance = null;

	private final MetaFormActionMap formActionMap;

	private MetaFormActionMapEx() {
		formActionMap = MetaFormActionMap.getInstance();
	}

	/**
	 * 取得表单事件映射实例
	 * 
	 * @return 表单事件映射实例
	 */
	public static MetaFormActionMapEx getInstance() {
		if (Objects.isNull(instance)) {
			instance = new MetaFormActionMapEx();
		}
		return instance;
	}

	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] { { MetaColumn.TAG_NAME, new MetaColumnActionEx() } };
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}

	@Override
	public IMetaAction<AbstractMetaObject> getAction(String parentTag, String tag) {
		return super.getAction(parentTag, tag);
	}

	@Override
	public IMetaAction<AbstractMetaObject> getAction(String tag) {
		if (MetaColumn.TAG_NAME.equals(tag)) {
			return super.getAction(tag);
		}
		return formActionMap.getAction(tag);
	}

}
