package com.bokesoft.yes.design.setting.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.cmd.CheckXMLChanged;
import com.bokesoft.yes.design.cmd.XmlDiffProcessor;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.FilePathHelper;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SettingCommonUtils {
    public static List<Diff> getDiffsByJson(String jsonDiff) throws Throwable {
        JSONArray array = new JSONArray(jsonDiff);
        int len = array.length();
        List<Diff> diffs = new ArrayList<Diff>(len);
        for (int i = 0; i < len; i++) {
            Diff diff = Diff.fromJson(array.getJSONObject(i));
            diffs.add(diff);
        }
        return diffs;
    }

    public static String saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlDiffProcessor.genXmlDiff(xmlTree, rootNode, diff, true);
        // 修改Setting直接保存到xml文件中不再生成临时文件
        String oldXml = xmlTree.xmlTree.getOrgXml();
        String orgXml = oldXml;
        String path = diff.getFilePath();
        String orgXmlFragment = diff.getOrgXmlFragment();
        String newXmlFragment = diff.getNewXmlFragment();
        int startLine = diff.getStartLine();
        boolean insertIndent = diff.isPropertyDiff() && !diff.isGridColumnDrag();
        orgXml = CheckXMLChanged.mergeXML(orgXml, startLine, orgXmlFragment, newXmlFragment, null, insertIndent);
        if (diff.getNewXmlFragment() == null){
            FileUtils.writeStringToFile(new File(path), xmlTree.xmlTree.getOrgXml(), "UTF-8");
        }else {
            FileUtils.writeStringToFile(new File(path),orgXml, "UTF-8");
        }
        if (diff.getNewXmlFragment()!=null){
            jsonObject.put("newXml",  diff.getNewXmlFragment());
        }else {
            jsonObject.put("newXml", xmlTree.xmlTree.getOrgXml());
        }
        jsonObject.put("xmlPath", StringUtil.isBlankOrNull(path) ? path : FilePathHelper.toFrontFilePath(path));
        return oldXml;
    }
}
