package com.bokesoft.yes.design.setting.util;


import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.resolver.DesignSettingMetaResolver;
import com.bokesoft.yes.design.setting.impl.HandleSettingImpl;
import com.bokesoft.yes.design.xml.node.CDataNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.erp.config.ERPDataElementInit;
import com.bokesoft.yes.erp.config.ERPDomainInit;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDomainDefLoad;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDomainDefSave;
import com.bokesoft.yes.struct.abstractdatatable.RowState;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.domain.MetaDomainCollection;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.domain.MetaItemKeyCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.io.File;

public class DomainDefOperJsonUtil extends HandleSettingImpl {

    @Override
    public void saveXml(XmlTreeWithPath xmlTree, TagNode rootNode, Diff diff, JSONObject jsonObject) throws Throwable {
//        SettingCommonUtils.saveXml(diff.getXmlTree(), diff.getXmlTree().xmlTree.getRoot(), diff, jsonObject);
        String xml = genFinalXML(xmlTree, rootNode, diff, jsonObject);
        String filePath = diff.getFilePath();
        org.w3c.dom.Document document = DomHelper.createDocument(xml);
        MetaDomainDefLoad domainDefLoad = new MetaDomainDefLoad(AppRunType.Dev);
        domainDefLoad.load(document);
        MetaDomainDef domainDef = (MetaDomainDef) domainDefLoad.getRootMetaObject();
        dealMetaDomainDef(domainDef);
        DesignSettingMetaResolver designSettingMetaResolver = new DesignSettingMetaResolver();
        (new MetaDomainDefSave(domainDef)).save(designSettingMetaResolver, filePath);
    }

    private void dealMetaDomainDef(MetaDomainDef domainDef){
        for (MetaDomain metaDomain : domainDef.getDomainCollection()) {
            if (metaDomain.getGroupKey() == null){
                metaDomain.setGroupKey("");
            }
        }
    }


    @Override
    public void reload(String filePath) throws Throwable {
        String projectKey = LoadFileTree.getProjectKey(filePath);
        TreeNode treeNode = LoadFileTree.getTreeNode(filePath);
        if (StringUtils.isEmpty(projectKey)) {
            String solutionKey = treeNode.solutionKey;
            IMetaResolverFactory metaResolverFactoryBySolution = MetaFactory.getGlobalInstance().getMetaResolverFactoryBySolution(solutionKey);
            IMetaResolver iMetaResolver = metaResolverFactoryBySolution.newMetaResolver("");
            String solutionPath = LoadFileTree.getSolutionPath(solutionKey);
            String fileRelationPath = StringUtils.replace(filePath, solutionPath+ File.separator,"");
            MetaDomainDef metaDomainDef = MetaUtil.loadDomainDef(MetaFactory.getGlobalInstance(), iMetaResolver, solutionKey, null,fileRelationPath);
            roadDomain(solutionKey, metaDomainDef);
        }
    }

    private static void roadDomain(String solutionKey, MetaDomainDef metaDomainDef) throws Throwable {
        IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
        IMetaResolverFactory resolverFactory = globalInstance.getMetaResolverFactoryBySolution(solutionKey);
        IMetaResolver resolver = resolverFactory.newMetaResolver("");
        MetaDomainDef metaDomain = MetaUtil.loadDomainDef(resolver, solutionKey, null);
        // 存储dataElementDef
        globalInstance.getSolutionDomainDefMap().put(solutionKey, metaDomain);
        //这里更新主
        globalInstance.reloadDomainDef();
        MetaDomainDef domainDef = globalInstance.getDomainDef();
        ERPDomainInit.initSystemDomain(domainDef.getDomainCollection());
        globalInstance.getSolutionDomainDefMap().forEach((key,domain)->{
            domainDef.toMerge(domain);
        });
        MetaUtil.reloadMetaDomain(MetaFactory.getGlobalInstance(), metaDomainDef);
    }

    @Override
    public void dealData(Document document, Diff diff, JSONObject jsonObject) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        TagNode rootNode = xmlTree.xmlTree.getRoot();
        // 从当前表单的document中获取表格数据
        DataTable edDomainDef = document.get("ED_DomainDef");
        edDomainDef.setShowDeleted(true);

        DataTable eD_DefaultItem = document.get("ED_DefaultItem");
        TagNode childByTagName = rootNode.getOrCreateChildByTagName(MetaDomainCollection.TAG_NAME);
        childByTagName.deleteChildByTagName(MetaDomain.TAG_NAME);
        for (int i = 0; i < edDomainDef.size(); i++) {
            if(edDomainDef.getState(i) == RowState.DELETED || edDomainDef.getState(i) == RowState.MODIFIED ){
                TreeNode treeNode = LoadFileTree.getTreeNode(diff.filePath);
                String solutionKey = treeNode.solutionKey;
                MetaDomainCollection domainCollection = MetaFactory.getGlobalInstance().getDomainDef(solutionKey).getDomainCollection();
                String domainKey = edDomainDef.getString(i, ConstantUtil.KEY);
                if(domainCollection != null && domainCollection.containsKey(domainKey)){
                    domainCollection.remove(domainKey);
                }
                if(edDomainDef.getState(i) == RowState.DELETED) {
                    continue;
                }
            }
            String key = edDomainDef.getString(i, ConstantUtil.KEY);
            String oid = String.valueOf(edDomainDef.getLong(i, ConstantUtil.OID));
            String caption = edDomainDef.getString(i, "Caption");
            String controlType = edDomainDef.getString(i, "ControlType");
            String dataType = edDomainDef.getString(i, "DataType");
            Integer precision = edDomainDef.getInt(i, "Precision");
            Integer scale = edDomainDef.getInt(i, "Scale");
            Integer length = edDomainDef.getInt(i, "Length");
            String useGroupingSeparator = edDomainDef.getString(i, "UseGroupingSeparator");
            String Case = edDomainDef.getString(i, "Case");
            String sourceType = edDomainDef.getString(i, "SourceType");
            String groupKey = edDomainDef.getString(i, "GroupKey");
            String itemKey = edDomainDef.getString(i, "ItemKey");
            String allowMultiSelection = edDomainDef.getString(i, "AllowMultiSelection");
            TagNode domainNode = new TagNode(MetaDomain.TAG_NAME, null);
            domainNode.setAttribute("Key", key);
            domainNode.setAttribute("Caption", caption);
            domainNode.setAttribute("RefControlType", controlType);
            domainNode.setAttribute("DataType", dataType);
            domainNode.setAttribute("Precision", precision.toString(), "0");
            domainNode.setAttribute("Scale", scale.toString(), "0");
            domainNode.setAttribute("Length", length.toString(), "0");
            domainNode.setAttribute("UseGroupingSeparator", useGroupingSeparator);
            domainNode.setAttribute("Case", Case, "0");
            domainNode.setAttribute("SourceType", sourceType, "");
            domainNode.setAttribute("GroupKey", groupKey, "");
            domainNode.setAttribute("ItemKey", itemKey);
            domainNode.setAttribute("AllowMultiSelection", allowMultiSelection);
            String GetFormulaItemKeys = edDomainDef.getString(i, "GetFormulaItemKeys");
            if (controlType.equalsIgnoreCase("DynamicDict")){
                if (!GetFormulaItemKeys.isEmpty()){
                    TagNode formulaItems = new TagNode("FormulaItems", null);
                    formulaItems.addNode(new CDataNode(GetFormulaItemKeys,null));
                    domainNode.addNode(formulaItems);
                } else {
                    for (int j = 0; j < eD_DefaultItem.size(); j++) {
                        TagNode orCreateChildByTagName = domainNode.getOrCreateChildByTagName(MetaItemKeyCollection.TAG_NAME);
                        String subOid = String.valueOf(eD_DefaultItem.getLong(j, SystemField.POID_SYS_KEY));
                        if (!oid.equalsIgnoreCase(subOid)) {
                            continue;
                        }
                        String key1 = eD_DefaultItem.getString(j, "ItemKey_"+ConstantUtil.KEY);
                        String caption1 = eD_DefaultItem.getString(j, "ItemKey_"+ConstantUtil.CAPTION);
                        String value = eD_DefaultItem.getString(j, "ItemKey_"+ConstantUtil.VALUE);
                        TagNode fieldLabel = new TagNode(MetaDefaultItem.TAG_NAME, null);
                        orCreateChildByTagName.addNode(fieldLabel);
                        fieldLabel.setAttribute("Key", key1);
                        fieldLabel.setAttribute("Caption", caption1);
                        fieldLabel.setAttribute("Value", value);
                    }
                }
            }
            childByTagName.addNode(domainNode);
            if(String.valueOf(ComboBoxSourceType.ITEMS).equals(sourceType) || ComboBoxSourceType.STR_ITEMS.equals(sourceType)){
                for (int j = 0; j < eD_DefaultItem.size(); j++) {
                    String subOid = String.valueOf(eD_DefaultItem.getLong(j, SystemField.POID_SYS_KEY));
                    if (!oid.equalsIgnoreCase(subOid)) {
                        continue;
                    }
                    String key1 = eD_DefaultItem.getString(j, ConstantUtil.KEY);
                    String caption1 = eD_DefaultItem.getString(j, ConstantUtil.CAPTION);
                    String value = eD_DefaultItem.getString(j, ConstantUtil.VALUE);
                    String icon = eD_DefaultItem.getString(j, "Icon");
                    TagNode fieldLabel = new TagNode(MetaDefaultItem.TAG_NAME, null);
                    domainNode.addNode(fieldLabel);
                    fieldLabel.setAttribute("Key", key1);
                    fieldLabel.setAttribute("Caption", caption1);
                    fieldLabel.setAttribute("Value", value);
                    fieldLabel.setAttribute("Icon", icon);

                }
            }


        }
    }
}
