//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.bokesoft.yes.design.newproject;

import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.resolver.DesignProjectMetaResolver;
import com.bokesoft.yes.meta.persist.dom.bpm.MetaBPMSave;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefSave;
import com.bokesoft.yes.meta.persist.dom.entry.MetaEntrySave;
import com.bokesoft.yes.meta.persist.dom.mobiledef.MetaMobileDefSave;
import com.bokesoft.yes.meta.persist.dom.relation.path.check.MetaRelationCheckSave;
import com.bokesoft.yes.meta.persist.dom.solution.MetaProjectSave;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.entry.MetaEntry;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.path.check.MetaRelationCheck;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.solution.MetaProjectProfile;

import java.io.File;

public class CreateEmptyProjectAction {
    private String solutionPath = null;
    private String key = null;
    private String caption = null;

    public CreateEmptyProjectAction(String var1, String var2, String var3) {
        this.solutionPath = var1;
        this.key = var2;
        this.caption = var3;
    }

    public MetaProject doAction() throws Throwable {
        //ResMetaFactory var1;
        //MetaSolution var2 = (var1 = GlobalSetting.getMetaFactory()).getSolution(this.solutionPath);
        MetaProject metaProject;
        (metaProject = new MetaProject()).setKey(this.key);
        metaProject.setCaption(this.caption);
        String solutionpath = this.solutionPath + File.separatorChar + this.key;
        File file;
        if (!(file = new File(solutionpath)).exists()) {
            file.mkdir();
        }

        String path = solutionpath + File.separatorChar + "Form";
        if (!(file = new File(path)).exists()) {
            file.mkdir();
        }

        path = solutionpath + File.separatorChar + ConstantUtil.DATA_OBJECT;
        if (!(file = new File(path)).exists()) {
            file.mkdir();
        }

        path = solutionpath + File.separatorChar + "Custom";
        if (!(file = new File(path)).exists()) {
            file.mkdir();
        }
        path = solutionpath + File.separatorChar + "Custom" + File.separatorChar + "DataMap";
        if (!(file = new File(path)).exists()) {
            file.mkdir();
        }
        path = solutionpath + File.separatorChar + ConstantUtil.DATA_MIGRATION;
        if (!(file = new File(path)).exists()) {
            file.mkdir();
        }

        path = solutionpath + File.separatorChar + "Report";
        if (!(file = new File(path)).exists()) {
            file.mkdir();
        }
        path = solutionpath + File.separatorChar + "ExcelTemplate";
        if (!(file = new File(path)).exists()) {
            file.mkdir();
        }

        path = solutionpath + File.separatorChar + "RelationCheck";
        if (!(file = new File(path)).exists()) {
            file.mkdir();
        }

        path = solutionpath + File.separatorChar + "BPM";
        if (!(file = new File(path)).exists()) {
            file.mkdir();
        }
        DesignProjectMetaResolver designProjectMetaResolver = new DesignProjectMetaResolver(solutionpath);
        //var1.addProjectResolver(this.solutionPath, this.key, designProjectMetaResolver);
        (new MetaProjectSave(metaProject)).save(designProjectMetaResolver, solutionpath + File.separatorChar + "Project.xml");
        MetaEntry metaEntry;
        (metaEntry = new MetaEntry()).setKey("root");
        String caption = StringTable.getString("General", "Root");
        metaEntry.setCaption(caption);
        caption = solutionpath + File.separatorChar + "Entry.xml";
        DesignEntryMetaResolver designEntryMetaResolver = new DesignEntryMetaResolver();
        (new MetaEntrySave(metaEntry)).save(designEntryMetaResolver, caption);
        
        
        MetaCommonDef metaCommonDef = new MetaCommonDef();
        caption = solutionpath + File.separatorChar + "CommonDef.xml";
        DesignCommonDefMetaResolver designCommonDefMetaResolver = new DesignCommonDefMetaResolver();
        (new MetaCommonDefSave(metaCommonDef)).save(designCommonDefMetaResolver, caption);
        metaProject.setCommonDef(metaCommonDef);
        
        MetaMobileDef metaMobileDef = new MetaMobileDef();
        caption = solutionpath + File.separatorChar + "MobileDef.xml";
        DesignMobileDefMetaResolver designMobileDefMetaResolver = new DesignMobileDefMetaResolver();
        (new MetaMobileDefSave(metaMobileDef)).save(designMobileDefMetaResolver, caption);
        metaProject.setMobileDef(metaMobileDef);
        MetaBPM metaBPM = new MetaBPM();
        caption = solutionpath + File.separatorChar + "BPM.xml";
        DesignBPMMetaResolver designBPMMetaResolver = new DesignBPMMetaResolver();
        (new MetaBPMSave(metaBPM)).save(designBPMMetaResolver, caption);
        MetaRelationCheck metaRelationCheck = new MetaRelationCheck();
        caption = solutionpath + File.separatorChar + "SecurityFilter.xml";
        DesignRelationMetaResolver designRelationMetaResolver = new DesignRelationMetaResolver();
        (new MetaRelationCheckSave(metaRelationCheck)).save(designRelationMetaResolver, caption);
        MetaProjectProfile metaProjectProfile;
        (metaProjectProfile = new MetaProjectProfile()).setKey(this.key);
        metaProjectProfile.setCaption(this.caption);
        metaProjectProfile.setProject(metaProject);
        //var2.getProjectCollection().add(metaProjectProfile);
        //(new MetaSolutionSave(var2)).save(var1.getSolutionResolver(this.solutionPath),
        // this.solutionPath + File.separatorChar + "Solution.xml");
        //ResSolution var9;
        //(var9 = var1.getResSolution(this.solutionPath)).getAllProjects().put(this.key, this.caption);
        //var9.addProjectResolver(this.key, designProjectMetaResolver);
        //var1.loadNewProject(this.key, solutionpath, metaProjectProfile, var9);
        return metaProject;
    }
}
