package com.bokesoft.yes.design.metaobjecttype;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.Property;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.struct.document.Document;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * xml差异处理接口
 */
public interface MetaXMLDiffProcessing {

    /**
     * 处理xml差异
     * @param metaForm
     * @param diff
     * @param document
     */
    void mergeDiff(MetaForm metaForm, Diff diff, Document document) throws Throwable ;

//    void mergeDeleteDiff(MetaForm metaForm, Diff diff);

     /**
     * create time:
     * Affect :替换xml
     *
     * @return
     * @Param: null
     */
     default void genXmlDiff(XmlTreeWithPath xmlTree, TagNode node, Diff diff, boolean isFirst) {
         int bgIndex = node.getElement().getBgIndex();
         int startLine = xmlTree.xmlTree.getLineByIndex(bgIndex);
         String orgXmlFragment = xmlTree.xmlTree.getNodeString(startLine);
         String newXmlFragment = DesignIOMetaUtil.getXml(node);
         if (isFirst) {
             diff.setXmlDiff(xmlTree, startLine, orgXmlFragment, newXmlFragment);
         } else {
             diff.setXmlDiff2(xmlTree, startLine, orgXmlFragment, newXmlFragment);
         }
     }

    /**
     * 获取xml树的key
     * todo 这个方法将来可能也要重构到具体的配置对象中
     * @param diff
     * @param controlerType
     * @param primaryKey
     * @return
     * @throws Throwable
     */
    default String getXmlTreeKey(Diff diff, String controlerType, String primaryKey) throws Throwable {
        XmlTreeWithPath xmlTree = diff.getXmlTree();
        MetaObjectType metaObjectType = diff.getMetaObjectType();
        if (metaObjectType == MetaObjectType.field
                || metaObjectType == MetaObjectType.panel
                || metaObjectType == MetaObjectType.subDetail
                || metaObjectType == MetaObjectType.grid
                || metaObjectType == MetaObjectType.D_DictView
                || metaObjectType == MetaObjectType.listView) {// 面板字段
            String buddyKey = "";
            String name = diff.properties.get(0).property.name;
            String controlType = ControlType.toString(diff.getControlType());
            TagNode fieldNode = xmlTree.xmlTree.getTagNode(controlType + "@" + diff.getKey());
            if (fieldNode != null) {
                buddyKey = fieldNode.getAttributes().get(ConstantUtil.BUDDY_KEY);
            }
            if (ControlType.STR_LABEL.equals(controlType)) { // label
                if (Property.key.name.equalsIgnoreCase(name)) {
                    String orgVal = diff.properties.get(0).orgValue;
                    return new StringBuilder().append(controlType).append("@").append(orgVal).toString();
                } else {
                    String key = diff.getKey();
                    return new StringBuilder().append(controlType).append("@").append(key).toString();
                }
            } else {
                if (Property.key.name.equalsIgnoreCase(name)) {// key label的key也要改
                    String orgVal = diff.properties.get(0).orgValue;
                    StringBuilder fieldString = new StringBuilder().append(controlType).append("@").append(orgVal);
                    TagNode coluNode = xmlTree.xmlTree.getTagNode(fieldString.toString());
                    if (Objects.isNull(coluNode)) {
                        throw new Throwable("warning: 不能修改!");
                    }
                    String key = coluNode.getAttributes().get(ConstantUtil.BUDDY_KEY);
                    if (StringUtils.isBlank(key)) {
                        return fieldString.toString();
                    }
                    StringBuilder labString = new StringBuilder().append(ConstantUtil.LABEL).append("@").append(key);
                    return labString.append(",").append(fieldString).toString();
                } else if (Property.BuddyKey.name.equalsIgnoreCase(name)) {// key label的key也要改
                    StringBuilder fieldString = new StringBuilder().append(controlType).append("@").append(diff.getKey());
                    TagNode coluNode = xmlTree.xmlTree.getTagNode(fieldString.toString());
                    if (Objects.isNull(coluNode)) {
                        throw new Throwable("不能修改!");
                    }
                    StringBuilder labString = new StringBuilder().append(ConstantUtil.LABEL).append("@").append(buddyKey);
                    return labString.append(",").append(fieldString).toString();
                } else if (Property.buddyCaption.name.equalsIgnoreCase(name)
                        || Property.buddyX.name.equalsIgnoreCase(name) || Property.buddyY.name.equalsIgnoreCase(name)) {
                    return new StringBuilder().append(ConstantUtil.LABEL).append("@").append(buddyKey).toString();
                } else {
                    String key = diff.getKey();
                    return new StringBuilder().append(controlType).append("@").append(key).toString();
                }
            }

        } else if ((metaObjectType == MetaObjectType.gridField && diff.properties.size() > 0)
                || metaObjectType == MetaObjectType.GridCellType) {// 表格字段
            String name = diff.properties.get(0).property.name;
            if (Property.key.name.equalsIgnoreCase(name)) {
                String orgVal = diff.properties.get(0).orgValue;
                StringBuilder CellPrimary = new StringBuilder().append(ConstantUtil.GRID_CELL).append("@").append(orgVal);
                StringBuilder ColumnPrimary = new StringBuilder().append(ConstantUtil.GRID_COLUMN).append("@").append(orgVal);
                return CellPrimary.append(",").append(ColumnPrimary).toString();
            } else {
                String key = diff.getKey();
                if (Property.visible.name.equalsIgnoreCase(name)) {
                    return new StringBuilder().append(ConstantUtil.GRID_COLUMN).append("@").append(key).toString();
                } else if (Property.caption.name.equalsIgnoreCase(name)) {
                    StringBuilder CellPrimary = new StringBuilder().append(ConstantUtil.GRID_CELL).append("@").append(key);
                    StringBuilder ColumnPrimary = new StringBuilder().append(ConstantUtil.GRID_COLUMN).append("@").append(key);
                    return CellPrimary.append(",").append(ColumnPrimary).toString();
                } else { // 单元格属性 enable columnkey required defaultvalue defaultforval valchanged..
                    return new StringBuilder().append(ConstantUtil.GRID_CELL).append("@").append(key).toString();
                }
            }
        } else if (metaObjectType == MetaObjectType.listViewField) {// ListView字段
            String name = diff.properties.get(0).property.name;
            if (Property.key.name.equalsIgnoreCase(name)) {
                String orgVal = diff.properties.get(0).orgValue;
                return new StringBuilder().append(ConstantUtil.LIST_VIEW_COLUMN).append("@").append(orgVal).toString();
            } else {
                String key = diff.getKey();
                if (Property.visible.name.equalsIgnoreCase(name)) {
                    return new StringBuilder().append(ConstantUtil.LIST_VIEW_COLUMN).append("@").append(key).toString();
                } else if (Property.caption.name.equalsIgnoreCase(name)) {
                    return new StringBuilder().append(ConstantUtil.LIST_VIEW_COLUMN).append("@").append(key).toString();
                } else { // 单元格属性 enable columnkey required defaultvalue defaultforval valchanged..
                    return new StringBuilder().append(ConstantUtil.LIST_VIEW_COLUMN).append("@").append(key).toString();
                }
            }
        } else if (metaObjectType == MetaObjectType.operationCollection || metaObjectType == MetaObjectType.operation) {
            String key = !ConstantUtil.KEY.equals(diff.properties.get(0).property.name) ? diff.getKey() : primaryKey;
            StringBuilder optPrimary = new StringBuilder().append(MetaObjectType.operation.name).append("@")
                    .append(key);
            StringBuilder colPrimary = new StringBuilder().append(MetaObjectType.operationCollection.name).append("@")
                    .append(key);
            return optPrimary.append(",").append(colPrimary).toString();
        } else if (metaObjectType == MetaObjectType.toolbar) {//toolbar
            String orgVal = diff.properties.get(0).orgValue;
            if (ConstantUtil.CAPTION.equals(diff.properties.get(0).property.name)) {
                return new StringBuilder().append(ConstantUtil.TOOL_BAR).append("@").append(diff.getKey()).toString();
            } else {
                return new StringBuilder().append(ConstantUtil.TOOL_BAR).append("@").append(orgVal).toString();
            }

        } else if (metaObjectType == MetaObjectType.ToolBar) {//newToolbar
            return new StringBuilder().append(ConstantUtil.TOOL_BAR).append("@").toString();

        } else if (MetaObjectType.GridHeadColumn.equals(metaObjectType)) {
            if (diff.properties.get(0).property.name.equals(ConstantUtil.KEY)) {
                return "GridColumn@" + diff.properties.get(0).orgValue;
            }
            return "GridColumn@" + diff.getKey();
        } else {
            return new StringBuilder().append(controlerType).append("@").append(primaryKey).toString();
        }

    }
}
