package com.bokesoft.yes.design.dataMigration.util;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil;
import com.bokesoft.yes.design.utils.TwoTuple;
import com.bokesoft.yes.design.utils.publicMethodUtil;
import com.bokesoft.yes.design.vo.JsonDataMapVo;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.erp.config.MetaFormNODBProcess;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;

public class DataMigrationOperXmlUtil {
	private static final Logger logger = Logger.getLogger(DataMapOperXmlUtil.class.getName());

	/***
	 * 获取当前Form表单中的所有字段
	 * @return 结果对象
	 * @param jsonDataMapVo
	 */
	public ResponseResult<JSONArray> getMigrationField(JsonDataMapVo jsonDataMapVo, Element root) {
		boolean isIdentical = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY).equalsIgnoreCase(root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY));
		ResponseResult<JSONArray> result = new ResponseResult<>();
		try {
			String formKey = jsonDataMapVo.getFormKey();
			//如果源表单和目标表单相同的话就进行拆分拿到真正的formKey
			if (formKey != null) {
				formKey = formKey.split("__")[0];
			}

			//如果源单和目标表单相同就要进行区分，防止前端添加动态Id出现重复

			if ("source".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
				formKey = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
			} else {
				formKey = root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY);
			}
			MetaDataObject dataObject = MetaFactory.getGlobalInstance().getDataObject(formKey);
			MetaTableCollection tableCollection = dataObject.getTableCollection();
			JSONArray nodesJsonArray = new JSONArray();
			if (isIdentical && root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY).equalsIgnoreCase(formKey) && "source".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
				formKey = formKey + "__S";
			} else if (isIdentical && root.attributeValue(ConstantUtil.TGT_DATA_OBJECT_KEY).equalsIgnoreCase(formKey) && "target".equalsIgnoreCase(jsonDataMapVo.getOperationType())) {
				formKey = formKey + "__T";
			}
			for (int i = 0; i < tableCollection.size(); i++) {
				MetaTable metaColumns = tableCollection.get(i);
				if (!metaColumns.getKey().contains(MetaFormNODBProcess.STR_NODBTable_Profix)) {
					for (MetaColumn m : metaColumns) {
						JSONObject nodeJsonObj = new JSONObject();
						int groupType = m.getGroupType();
						//获取分组类型
						String fieldCaption = DataMigrationOperJsonUtil.getGroupType(groupType);
						nodeJsonObj.put("name", "(表" + (i + 1) + ")" + m.getKey() + "  " + m.getCaption() + "  " + fieldCaption);
						nodeJsonObj.put("value", (i + 1) + "_@_" + m.getKey() + "_@_" + m.getCaption() + fieldCaption + "_@_" + metaColumns.getKey() + "_@_" + formKey + "_@_" + "Migration");
						nodesJsonArray.add(nodeJsonObj);
					}
				}
			}
			result.setCode(0);
			result.setMsg("获取数据对象字段成功");
			result.setData(nodesJsonArray);
		} catch (Throwable e) {
			logger.warning("获取数据对象字段异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取数据对象字段失败，失败消息为:" + e.getMessage());
		}
		return result;
	}

	/**
	 * 根据tableKey获取数据映射中的源表单集合
	 *
	 * @param document
	 * @return
	 */
	public static Element getMapSourceTableCollectionNode(Document document) {
		String xpathExpression = "/DataMigration/SourceTableCollection";
		Element nodes = (Element) document.selectSingleNode(xpathExpression);
		return nodes;
	}
	/**
	 * 根据tableKey获取数据映射中的目标表单集合
	 *
	 * @param document
	 * @return
	 */
	public static Element getMapTargetTableCollectionNode(Document document) {
		String xpathExpression = "/DataMigration/TargetTableCollection";
		Element nodes = (Element) document.selectSingleNode(xpathExpression);
		return nodes;
	}

	/**
	 * 获取参照主表中的字段
	 *
	 * @param jsonDataMapVo
	 * @return
	 */
	public ResponseResult<JSONArray> getStatusFideldKey(JsonDataMapVo jsonDataMapVo) {
		ResponseResult<JSONArray> result = new ResponseResult<>();
		JSONArray array = null;
		try {
			array = new JSONArray();
			String filePaths = jsonDataMapVo.getFilePath();
			// 创建SAX读取器
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(new File(filePaths));
			// 获取根节点
			Element root = document.getRootElement();
			//获取源单的表单名
			String formKey = root.attributeValue(ConstantUtil.SRC_DATA_OBJECT_KEY);
			TwoTuple<MetaForm, MetaDataObject> metaFormOrMetaDataObject = publicMethodUtil.MetaFormOrMetaDataObject(formKey);
			MetaForm metaForm = metaFormOrMetaDataObject.metaForm;
			MetaDataObject metaDataObject = metaFormOrMetaDataObject.metaDataObject;
			String mainTableKey = Optional.ofNullable(metaForm).map(form -> form.getDataSource().getDataObject().getMainTableKey())
					.orElse(Optional.ofNullable(metaDataObject).map(MetaDataObject::getMainTableKey).orElse(null));
			MetaTable table = Optional.ofNullable(metaForm).map(form -> metaForm.getDataSource().getDataObject().getTable(mainTableKey))
					.orElse(Optional.ofNullable(metaDataObject).map(dataObject -> dataObject.getTable(mainTableKey)).orElse(null));
			JSONObject nodeJson;
			for (MetaColumn metaColumn : Objects.requireNonNull(table)) {
				if (metaColumn != null) {
					String key = metaColumn.getKey();
					if (!SystemField.isSystemField(key)) {
						String caption = metaColumn.getCaption();
						nodeJson = new JSONObject();
						nodeJson.put("name", key + "  " + caption);
						nodeJson.put("value", key);
						array.add(nodeJson);
					} else if (key.equalsIgnoreCase("Status")) {
						String caption = metaColumn.getCaption();
						nodeJson = new JSONObject();
						nodeJson.put("name", key + "  " + caption);
						nodeJson.put("value", key);
						array.add(nodeJson);
					}
				}
			}
			result.setCode(0);
			result.setMsg("获取状态字段标识成功");
			result.setData(array);
		} catch (Exception e) {
			logger.warning("获取状态字段标识异常，异常为:" + ExceptionUtils.getStackTrace(e));
			result.setCode(999);
			result.setMsg("获取状态字段标识失败，失败消息为:" + e.getMessage());
		} catch (Throwable throwable) {
			logger.warning(throwable.getMessage());
		}
		return result;
	}
}
