package com.bokesoft.yes.design.cmd;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.XmlTreeWithPath;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.helper.MetaObjectHelper;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaCommonDefSave;
import com.bokesoft.yes.meta.persist.dom.enhance.MetaEnhanceSave;
import com.bokesoft.yes.meta.persist.dom.iosetting.MetaIOSettingActionMap;
import com.bokesoft.yes.meta.persist.dom.paratable.MetaParaTableSave;
import com.bokesoft.yes.meta.persist.dom.rights.MetaRightsDefinitionSave;
import com.bokesoft.yes.meta.persist.dom.setting.MetaSettingSave;
import com.bokesoft.yes.meta.persist.dom.solution.MetaSolutionSave;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.factory.DefaultMetaFactory;
import com.bokesoft.yigo.meta.factory.DefaultMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.iosetting.MetaIOSetting;
import com.bokesoft.yigo.meta.paratable.MetaParaTable;
import com.bokesoft.yigo.meta.rights.MetaRightsDefinition;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;


/**
 *
 */
public class NewSolutionCmd extends DesignerServiceCmd {
    public static final String CMD = "NewSolution";

    private StringHashMap<Object> arguments;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.arguments = arguments;
    }

    /**
     * 新增表单文件
     */
    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        String key = TypeConvertor.toString(arguments.get("key"));
        String caption = TypeConvertor.toString(arguments.get("caption"));
        String folderName = TypeConvertor.toString(arguments.get("folderName"));

        String workspacePath = FilePathHelper.getWorkspacePath();
        String[] existSamePaths = FileUtils.getFile(workspacePath).list((dirFile, fileName) -> StringUtils.equals(fileName, folderName));
        if (ArrayUtils.isNotEmpty(existSamePaths)) {
            throw new RuntimeException("warning: 解决方案存放的文件夹与已有文件或文件夹名称重复！");
        }

        File currentSolutionFile = FileUtils.getFile(workspacePath, folderName);
        FileUtils.forceMkdir(currentSolutionFile);
        String solutionPath = currentSolutionFile.getCanonicalPath();

        // Solution.xml
        MetaSolution metaSolution = new MetaSolution();
        metaSolution.setKey(key);
        metaSolution.setCaption(caption);
        MetaObjectHelper.saveToXml(metaSolution, solutionPath, DomMetaConstants.SOLUTION_FILE, MetaSolutionSave.class);

        // setting.xml
        MetaSetting metaSetting = new MetaSetting();
        MetaObjectHelper.saveToXml(metaSetting, solutionPath, DomMetaConstants.SETTING_FILE, MetaSettingSave.class);

        // IOSetting.xml
        MetaIOSetting metaIOSetting = new MetaIOSetting();
        MetaObjectHelper.saveToXml(metaIOSetting, solutionPath, DomMetaConstants.IOSETTING_FILE, MetaIOSettingActionMap.getInsance());

        // Enhance.xml
        MetaEnhance metaEnhance = new MetaEnhance();
        MetaObjectHelper.saveToXml(metaEnhance, solutionPath, DomMetaConstants.ENHANCE_FILE, MetaEnhanceSave.class);

        // NoRights.xml
        MetaRightsDefinition metaRightsDefinition = new MetaRightsDefinition();
        MetaObjectHelper.saveToXml(metaRightsDefinition, solutionPath, DomMetaConstants.RIGHTS_FILE, MetaRightsDefinitionSave.class);

        // CommonDef.xml
        MetaCommonDef metaCommonDef = new MetaCommonDef();
        MetaObjectHelper.saveToXml(metaCommonDef, solutionPath, DomMetaConstants.COMMON_DEF_FILE, MetaCommonDefSave.class);
        // ParaTable.xml
        MetaParaTable metaParaTable = new MetaParaTable();
        MetaObjectHelper.saveToXml(metaParaTable, solutionPath, DomMetaConstants.PARATABLE_FILE, MetaParaTableSave.class);
        MetaParaTable metaParaTable_Vest = new MetaParaTable();
        // ParaTable_Vest.xml
        MetaObjectHelper.saveToXml(metaParaTable_Vest, solutionPath, DomMetaConstants.PARATABLE_FILE_VEST, MetaParaTableSave.class);

        File domainFoldFile = FileUtils.getFile(solutionPath, DomMetaConstants.DOMAIN_FOLD);
        FileUtils.forceMkdir(domainFoldFile);

        File dataElementFoldFile = FileUtils.getFile(solutionPath, DomMetaConstants.DATAELEMENT_FOLD);
        FileUtils.forceMkdir(dataElementFoldFile);

        boolean isWrite = writeImportSolution(key, caption, solutionPath);

        List<UICommand> result = new ArrayList<>();
        if (isWrite) {
            IMetaFactory globalInstance = MetaFactory.getGlobalInstance();
            IMetaResolverFactory metaResolverFactory = new DefaultMetaResolverFactory(solutionPath);
            DefaultMetaFactory factory = new DefaultMetaFactory(metaResolverFactory);
            LoadFileTree.loadImportSolution(globalInstance, workspacePath, solutionPath, metaResolverFactory, factory);
            result.add(UICommand.reloadFileTree(solutionPath));
            result.add(UICommand.showTip("解决方案创建成功"));
        } else {
            FileUtils.forceDelete(currentSolutionFile);
            result.add(UICommand.showError("操作失败：解决方案重复"));
        }
        return UICommand.toJson(result);
    }

    public static boolean writeImportSolution(String key, String caption, String solutionPath) throws Throwable {
        String designerImportSolutionsPath = WebDesignerConfiguration.getDesignerImportSolutionsPath();
        XmlTreeWithPath xmlTreeWithPath = XmlTreeWithPath.parseFilePath(designerImportSolutionsPath);
        XmlTree xmlTree = xmlTreeWithPath.xmlTree;
        boolean containKey = xmlTree.containKey("ImportSolution@" + key);
        if (!containKey) {
            TagNode tagNode = new TagNode("ImportSolution", null);
            tagNode.setAttribute("Key", key);
            tagNode.setAttribute("Caption", caption);
            tagNode.setAttribute("SolutionPath", solutionPath);
            xmlTree.getRoot().addNode(tagNode);
            String newXml = DesignIOMetaUtil.getXml(xmlTree.getRoot());
            File file = new File(designerImportSolutionsPath);
            FileUtils.writeStringToFile(file, newXml, "UTF-8");
        }
        return !containKey;
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new NewSolutionCmd();
    }

}
