package com.bokesoft.yes.design.cmd;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.helper.DataObjectHelper;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class NewDataObjectCmd extends DesignerServiceCmd {
    public static final String CMD = "NewDataObject";

    private StringHashMap<Object> arguments;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        this.arguments = new StringHashMap<>();
        this.arguments.putAll(arguments);
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) {
        try {
            String key = TypeConvertor.toString(arguments.get("key"));
            String projectKey = TypeConvertor.toString(arguments.get("projectKey"));
            String caption = TypeConvertor.toString(arguments.get("caption"));
            String extend = TypeConvertor.toString(arguments.get("extend"));

            IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
            MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
            if (dataObjectList.containsKey(key)) {
                throw new RuntimeException("新增数据对象失败!key存在");
            }

            MetaDataObjectProfile profile = DataObjectHelper.createOutsideProfile(key, caption, projectKey, extend);
            //创建一个新的路径
            String filePath = LoadFileTree.NewDataObjectFilePath(projectKey, key, caption);
            //创建一个初始的XMl Content
            String fileContent = DataObjectHelper.createXml(profile.getDataObject());
            //生成一个临时文件
            XmlFileProcessor.instance.saveTempFile(filePath, fileContent,projectKey);
            //创建的时候直接生成文件
            FileUtils.writeStringToFile(new File(filePath), fileContent, "UTF-8");

            dataObjectList.add(profile);

            // TODO jiangjr 全量重新加载会特别慢
            LoadFileTree.loadFileTree();

            //前端重新装载xml文件命令
            List<UICommand> uiCommands = new ArrayList<>();
            uiCommands.add(UICommand.reloadFileTree(filePath));
            uiCommands.add(UICommand.reloadMenuTree());

            // 成功
            JSONObject result = new JSONObject();
            result.put("code", 0);
            result.put("msg", "新增数据对象成功");
            result.put("uICommands", UICommand.toJson(uiCommands));
            return result;
        } catch (Throwable e) {
            LogSvr.getInstance().error("\n", e);
            JSONObject result = new JSONObject();
            result.put("code", 1);
            result.put("msg", "新增数据对象失败!key存在"); // TODO 为啥？
            return result;
        }
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new NewDataObjectCmd();
    }

}
