package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.json.JSONObject;

import java.util.Map;

public class LoadNodeAttrByPathCmd extends DesignerServiceCmd {

    public static final String CMD = "LoadNodeAttrByPath";

    private String path;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        path = FilePathHelper.toBackFilePath((String) arguments.get("path"));
    }

    @Override
    protected Object innerDoCmd(DefaultContext context) throws Throwable {
        Map<String, String> map = LoadFileTree.loadNodeAttrByPath(context, path);
        return new JSONObject(map);
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new LoadNodeAttrByPathCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }
}
