package com.bokesoft.yes.design.cmd;

import java.io.File;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.io.TreeNode;
import com.bokesoft.yes.design.search.FileSearchQuery;
import com.bokesoft.yes.design.search.FileSearchResult;
import com.bokesoft.yes.design.search.FileTextSearchScope;
import com.bokesoft.yes.design.search.text.FileMatch;
import com.bokesoft.yes.design.search.text.FileMatchResource;
import com.bokesoft.yes.design.search.text.LineElement;
import com.bokesoft.yes.design.search.text.Match;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.tools.document.DataTableUtil;

/**
 * 加载查询数据
 */
public class LoadFilesSearchDataCmd extends DesignerServiceCmd {

	public static final String CMD = "LoadFilesSearchData";

	public static final String SearchFormKey = "D_FileTree";

	public static final String SearchTable = "D_SearchResultTable";

	public static final String FileType = "FileType";

	public static final String FileLineType = "FileLineType";

	/** 输入的搜索文本 */
	private String searchText = "";

	/** 正则 */
	private boolean isRegEx = false;

	/** 区分大小写 */
	private boolean isCaseSensitive = false;

	/** 全词匹配 */
	private boolean isWholeWord = false;
	
	/** 类型 */
	private String fileTypes = "";

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		searchText = (String) arguments.get("searchText");
		isRegEx = TypeConvertor.toBoolean(arguments.get("isRegEx"));
		isCaseSensitive = TypeConvertor.toBoolean(arguments.get("isCaseSensitive"));
		isWholeWord = TypeConvertor.toBoolean(arguments.get("isWholeWord"));
		fileTypes = (String) arguments.get("fileTypes");
	}

	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {

		FileTextSearchScope scope = new FileTextSearchScope(new String[] { "*" });
		FileSearchQuery fQuery = new FileSearchQuery(searchText, isRegEx, isCaseSensitive, isWholeWord, fileTypes, scope);
		fQuery.run();

		FileSearchResult result = fQuery.getSearchResult();
		Object[] elements = result.getElements();

		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(SearchFormKey);
		MetaDataObject dataObject = metaForm.getDataSource().getDataObject();

		MetaTable metaTable = dataObject.getMetaTable(SearchTable);
		DataTable table = DataTableUtil.newEmptyDataTable(metaTable);

		long start = System.currentTimeMillis();

		// 遍历文件
		for (int i = 0; i < elements.length; i++) {
			FileMatchResource res = (FileMatchResource) elements[i];
			File file = res.getFile();
			Match[] matchs = result.getMatches(elements[i]);

			// 配置文件类型
			String fileType = res.getFileType();
			String name = file.getName();
			String fSolutionPath = res.getFileSolutionPath();

			table.append();
			table.setObject("Key", file.getAbsolutePath());
			table.setObject("ParentKey", null);
			table.setObject("Caption", name + " (" + fSolutionPath + ")");
			table.setObject("Type", FileType);
			table.setObject("Count", matchs.length);
			table.setObject("FileType", fileType);
			table.setObject("ParentPath", file.getParent());

			String key = name.substring(0, name.length() - ".xml".length());
			String focusRowChangedFormula = "showSource('" + file.getAbsolutePath() + "', '" + res.getFileSolutionPath()
					+ "', '" + TreeNode.actionFileReflection.getOrDefault(key, key) + "', '" + file.getParent() + "')";

			table.setObject("FocusRowChangedFormula", focusRowChangedFormula);

			for (int j = 0; j < matchs.length; j++) {

				FileMatch fileMatch = (FileMatch) matchs[j];
				LineElement lineElement = fileMatch.getLineElement();

				table.append();
				table.setObject("Key", "line" + j);
				table.setObject("ParentKey", file.getAbsolutePath());
				table.setObject("Caption", lineElement.getContents());
				table.setObject("Type", FileLineType);
				table.setObject("StartColumn", fileMatch.getOffset() - lineElement.getOffset());
				table.setObject("EndColumn", fileMatch.getOffset() + fileMatch.getLength() - lineElement.getOffset());
				table.setObject("FileType", fileType);
				table.setObject("ParentPath", file.getParent());
				table.setObject("FOffset", fileMatch.getOffset());
				table.setObject("FocusRowChangedFormula", focusRowChangedFormula);
			}
		}

		long end = System.currentTimeMillis();

//		System.out.println("-----拼接数据耗时--------" + (end - start));
//		System.out.print("count ======" + result.getMatchCount());
//		System.out.println("================离开全文搜索===================");
		return table;
	}

	@Override
	public String getCmd() {
		return "LoadFilesSearchData";
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new LoadFilesSearchDataCmd();
	}

}
