package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.design.utils.XMLWriter;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import static com.bokesoft.yes.design.datamap.util.DataMapOperXmlUtil.getOutputFormat;

/**
 *
 */
public class DeleteEntryCmd extends DesignerServiceCmd {
	public static final String CMD = "DeleteEntry";
	private String subKey;
	private String subType;
	private String parentKey;
	private String filePath;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		subKey = TypeConvertor.toString(arguments.get("subKey"));
		parentKey = TypeConvertor.toString(arguments.get("parentKey"));
		filePath = FilePathHelper.toBackFilePath(TypeConvertor.toString(arguments.get("filePath")));
		subType = TypeConvertor.toString(arguments.get("subType"));
	}

	/**
	 * 新增菜单组
	 */
	@Override
	public Object innerDoCmd(DefaultContext context) throws Throwable {
		FileOutputStream fileOutputStream = null;
		XMLWriter writer = null;
		//	EntryProcessor.instance.NewProject(ProjectKey, ProjectCaption,SolutionKey);
		// 创建SAX读取器
		try {
			SAXReader reader = new SAXReader();
			// 加载文档
			Document document = reader.read(filePath);
			LinkedHashMap<String, String> xmlTreeMapKeys = new LinkedHashMap();
			getChildElement(document.getRootElement(), xmlTreeMapKeys);
			String path = xmlTreeMapKeys.get("Entry" + "@" + (StringUtils.isNotBlank(parentKey) ? parentKey : "root"));
			Element node = (Element) document.selectSingleNode(path);
			List<Element> elements = node.elements();

			Element deleteNode = (Element) document.selectSingleNode(xmlTreeMapKeys.get(subType + "@" + subKey));
			elements.remove(deleteNode);
			OutputFormat format = getOutputFormat();
			fileOutputStream = new FileOutputStream(filePath);
			writer = new XMLWriter(fileOutputStream, format);
			writer.write(document);
			
			String[] paths = StringUtils.split(filePath, File.separator);
			final String projectKey = paths[paths.length - 2];
			
			EntryProcessor.instance.reloadEntry(projectKey);
			List<UICommand> result = new ArrayList<UICommand>();
			result.add(UICommand.reloadXmlSource(filePath));
			result.add(UICommand.reloadMenuTree());
			return UICommand.toJson(result);
		} catch (Exception e) {
			throw e;
		} finally {
			closeFileStream(fileOutputStream, writer);
		}
	}

	/***
	 * 关闭文件流
	 * @param fileOutputStream 文件输出流
	 * @param writer 写对象
	 */
	private void closeFileStream(FileOutputStream fileOutputStream, XMLWriter writer) {
		try {
			if (null != fileOutputStream) {
				fileOutputStream.close();
			}
			if (null != writer) {
				writer.close();
			}
		} catch (Exception e) {
			LogSvr.getInstance().error(e.getMessage(), e);
		}
	}

	/*
	 * 递归方法，获取所有节点
	 */
	public void getChildElement(Element element, LinkedHashMap<String, String> xmlTreeMapKeys) {
		String key = element.attributeValue("Key");
		xmlTreeMapKeys.put(element.getName() + "@" + key, element.getUniquePath());
		List<Element> elements = element.elements();
		if (element != null) {
			for (Element element2 : elements) {
				getChildElement(element2, xmlTreeMapKeys);
			}
		}
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new DeleteEntryCmd();
	}


	@Override
	public String getCmd() {
		return CMD;
	}
}
