package com.bokesoft.yes.design.bpm.po;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

import com.alibaba.fastjson.JSONObject;

/***
 * Fork节点
 * @date 2020-10-14
 * @author zhsy
 */
public class Fork extends Node {

	private static final Logger logger = Logger.getLogger(Fork.class.getName());

	/***
	 * 保存自己的属性到xml文件中
	 * @param operNodeJson 操作节点json
	 * @param node 当前节点
	 */
	@Override
	public void saveSelfAttributesToXml(JSONObject operNodeJson, Element node) throws Throwable {
		try {
			// 获取属性WorkitemRevoke和IsSync的值
			if (StringUtils.isNotEmpty(node.attributeValue("WorkitemRevoke"))) {
				this.setWorkitemRevoke(node.attributeValue("WorkitemRevoke"));
			} else {
				this.setWorkitemRevoke("true");
			}

			if (StringUtils.isNotEmpty(node.attributeValue("IsSync"))) {
				this.setIsSync(node.attributeValue("IsSync"));
			} else {
				this.setIsSync("false");
			}

			// 设置元素NodeAttachment
			if (null == node.element("NodeAttachment")) {
				node.addElement("NodeAttachment");
			}
		} catch (Exception e) {
			logger.warning("保存属性到xml文件异常，异常为:" + ExceptionUtils.getStackTrace(e));
			throw e;
		}
	}

	/***
	 * 获取前端默认值设置json
	 * @return 设置后的json
	 */
	@Override
	public JSONObject setFrontDefaultValues() {
		Map<String, String> otherAttributesMap = new HashMap<>(2);
		otherAttributesMap.put("WorkitemRevoke", this.getWorkitemRevoke());
		otherAttributesMap.put("IsSync", this.getIsSync());
		return super.getFrontDefaultValuesJson(otherAttributesMap);
	}
}
