package com.bokesoft.yes.design.bpm.po;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.yes.design.constant.ConstantUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/***
 * MultiUserTask节点
 * @date 2020-10-14
 * @author zhsy
 */
public class DataMap extends Node {

	private static final Logger logger = Logger.getLogger(DataMap.class.getName());
	/***TimerItemCollection属性*/
	private String TimerItemCollection;
	/***RevokeCondition属性*/
	private String RevokeCondition;
	/***CreateTrigger属性*/
	private String CreateTrigger;
	/***FinishTrigger属性*/
	private String FinishTrigger;
	/***SyncTriggerType属性*/
	private String SyncTriggerType;
	/***DataMapCondition属性*/
	private String DataMapCondition;
	/***AutoIgnoreNoParticipator属性*/
	private String AutoIgnoreNoParticipator;
	/***Perm属性*/
	private String Perm;
	/***OperationCollection属性*/
	private String OperationCollection;
	/***AssistanceCollection属性*/
	private String AssistanceCollection;
	/***ParticipatorCollection属性*/
	private String ParticipatorCollection;
	/***BillDataMapInfoCollection属性*/
	private String BillDataMapInfoCollection;
	/***MidDataMap属性*/
	private String MidDataMap;

	/***
	 * 保存自己的属性到xml文件中
	 * @param operNodeJson 操作节点json
	 * @param node 当前节点
	 */
	@Override
	public void saveSelfAttributesToXml(JSONObject operNodeJson, Element node) throws Throwable {
		try {
			// 设置属性
			JSONObject propsJsonObj = operNodeJson.getJSONObject("props");
			Set<String> keys = propsJsonObj.keySet();
			String v = "";
			for (String k : keys) {
				v = propsJsonObj.getJSONObject(k).getString("value");
				if ("null".equals(v)) {
					v = "";
				}
				switch (k) {
					case "TimerItemCollection":
						this.setTimerItemCollectionXmlValue(node, v, k);
						break;
					case "RevokeCondition":
					case "CreateTrigger":
					case "FinishTrigger":
					case "SyncTriggerType":
					case "DataMapCondition":
						this.saveAttributeToXml(node, propsJsonObj, k);
						break;
					case "AutoIgnoreNoParticipator":
					case "InOrder":
					case "MidDataMap":
						if ("true".equals(v)) {
							node.addAttribute(k, v);
						} else {
							super.deleteXmlElementAttribute(node, node.attribute(k));
						}
						break;
					case "Perm":
						this.savePermToXml(node, v, k);
						break;
					case ConstantUtil.OPERATION_COLLECTION:
						this.setOperationCollectionXmlValue(node, v, k);
						break;
					case "AssistanceCollection":
						this.setAssistanceCollectionFromFrontJson(node, v, k);
						break;
					case "ParticipatorCollection":
						this.saveParticipatorCollectionToXml(node, v, k);
						break;
					case "BillDataMapInfoCollection":
						this.setDataMapCollectionXmlValue(node, v, k);
						break;
					default:
						break;
				}
			}

			// 获取属性MidDataMap的值
			if (StringUtils.isNotEmpty(node.attributeValue("MidDataMap"))) {
				this.setMidDataMap(node.attributeValue("MidDataMap"));
			} else {
				this.setMidDataMap("false");
			}
			// 获取属性SyncTriggerType的值
			if (StringUtils.isNotEmpty(node.attributeValue("SyncTriggerType"))) {
				this.setSyncTriggerType(node.attributeValue("SyncTriggerType"));
			} else {
				this.setSyncTriggerType("");
			}

			// 设置元素NodeAttachment
			if (null == node.element("NodeAttachment")) {
				node.addElement("NodeAttachment");
			}
		} catch (Exception e) {
			logger.warning("保存属性到xml文件异常，异常为:" + ExceptionUtils.getStackTrace(e));
			throw e;
		}
	}

	/***
	 * 获取前端默认值设置json
	 * @return 设置后的json
	 */
	@Override
	public JSONObject setFrontDefaultValues() {
		Map<String, String> otherAttributesMap = new HashMap<>(2);
		otherAttributesMap.put("MidDataMap", this.getMidDataMap());
		otherAttributesMap.put("SyncTriggerType", this.getSyncTriggerType());
		return super.getFrontDefaultValuesJson(otherAttributesMap);
	}

	public DataMap() {
	}

	public String getTimerItemCollection() {
		return TimerItemCollection;
	}

	public void setTimerItemCollection(String timerItemCollection) {
		TimerItemCollection = timerItemCollection;
	}

	public String getRevokeCondition() {
		return RevokeCondition;
	}

	public void setRevokeCondition(String revokeCondition) {
		RevokeCondition = revokeCondition;
	}

	public String getCreateTrigger() {
		return CreateTrigger;
	}

	public void setCreateTrigger(String createTrigger) {
		CreateTrigger = createTrigger;
	}

	public String getFinishTrigger() {
		return FinishTrigger;
	}

	public void setFinishTrigger(String finishTrigger) {
		FinishTrigger = finishTrigger;
	}

	public String getSyncTriggerType() {
		return SyncTriggerType;
	}

	public void setSyncTriggerType(String syncTriggerType) {
		SyncTriggerType = syncTriggerType;
	}

	public String getDataMapCondition() {
		return DataMapCondition;
	}

	public void setDataMapCondition(String dataMapCondition) {
		DataMapCondition = dataMapCondition;
	}

	public String getAutoIgnoreNoParticipator() {
		return AutoIgnoreNoParticipator;
	}

	public void setAutoIgnoreNoParticipator(String autoIgnoreNoParticipator) {
		AutoIgnoreNoParticipator = autoIgnoreNoParticipator;
	}

	public String getPerm() {
		return Perm;
	}

	public void setPerm(String perm) {
		Perm = perm;
	}

	public String getOperationCollection() {
		return OperationCollection;
	}

	public void setOperationCollection(String operationCollection) {
		OperationCollection = operationCollection;
	}

	public String getAssistanceCollection() {
		return AssistanceCollection;
	}

	public void setAssistanceCollection(String assistanceCollection) {
		AssistanceCollection = assistanceCollection;
	}

	public String getParticipatorCollection() {
		return ParticipatorCollection;
	}

	public void setParticipatorCollection(String participatorCollection) {
		ParticipatorCollection = participatorCollection;
	}

	public String getBillDataMapInfoCollection() {
		return BillDataMapInfoCollection;
	}

	public void setBillDataMapInfoCollection(String billDataMapInfoCollection) {
		BillDataMapInfoCollection = billDataMapInfoCollection;
	}

	public String getMidDataMap() {
		return MidDataMap;
	}

	public void setMidDataMap(String midDataMap) {
		MidDataMap = midDataMap;
	}
}
