package com.bokesoft.yes.design;

import com.bokesoft.yes.design.cmd.XmlFileProcessor;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yigo.common.util.FileUtil;
import org.apache.commons.lang3.StringUtils;

public class XmlTreeWithPath {
    /**
     * 原文件路径
     */
    public final String orgFilePath;
    /**
     * 当前的临时文件，即最新的文件路径
     */
    public final String tmpFilePath;
    /**
     * Xml树结构
     */
    public final XmlTree xmlTree;

	public XmlTreeWithPath(String orgFilePath, String tmpFilePath, XmlTree xmlTree) {
		this.orgFilePath = FilePathHelper.toBackFilePath(orgFilePath);
		this.tmpFilePath = FilePathHelper.toBackFilePath(tmpFilePath);
		this.xmlTree = xmlTree;
	}

	/**
	 * 根据文件路径生成Xml结构树，优先取临时文件（即最新的文件），若文件不存在，返回空；若文件解析错误，直接报错
	 *
	 * @param filePath
	 * @return
	 * @throws Throwable
	 */
	public static XmlTreeWithPath parseFilePath(String filePath, boolean isCheck) throws Throwable {
		if (StringUtils.isBlank(filePath)) {
			return null;
		}
		filePath = FilePathHelper.toBackFilePath(filePath);
		String tmpFilePath = XmlFileProcessor.instance.getTmpFile(filePath);
		String tmp = StringUtils.isBlank(tmpFilePath) ? filePath : FilePathHelper.toBackFilePath(tmpFilePath);
		String xml = FileUtil.File2String(tmp);
		if (StringUtils.isBlank(xml)) {
			return null;
		}
		XmlTree xmlTree = null;
		try {
			xmlTree = XmlParser.parse(xml, false, isCheck);

		} catch (Exception e){
			throw new Throwable("路径："+filePath+"，文件解析错误：" + e.getMessage());

		}
		return new XmlTreeWithPath(filePath, tmpFilePath, xmlTree);
	}

	public static XmlTreeWithPath parseFilePath(String filePath) throws Throwable {
		filePath = FilePathHelper.toBackFilePath(filePath);
		return parseFilePath(filePath, true);
	}

	/**
	 * 根据文件路径生成Xml结构树，不取临时文件（即最新的文件），若文件不存在，返回空；若文件解析错误，直接报错
	 *
	 * @param filePath
	 * @return
	 * @throws Throwable
	 */
	public static XmlTreeWithPath parseFilePathNotLoadTmp(String filePath) throws Throwable {
		filePath = FilePathHelper.toBackFilePath(filePath);
		return parseFilePathNotLoadTmp(filePath, true);
	}

	public static XmlTreeWithPath parseFilePathNotLoadTmp(String filePath, boolean isCheck) throws Throwable {
		if (StringUtils.isBlank(filePath)) {
			return null;
		}
		String xml = FileUtil.File2String(filePath);
		if (StringUtils.isBlank(xml)) {
			return null;
		}
		XmlTree xmlTree = XmlParser.parse(xml, false, isCheck);
		return new XmlTreeWithPath(filePath, null, xmlTree);
	}
}
