package com.bokesoft.yes.design;

import org.json.JSONObject;

/**
 * 属性差异
 */
public class DiffProperty {
	public Property property;

	/**
	 * 原值，原值会影响相关处理，比如一个控件从一个Panel移到另一个Panel
	 */
	public String orgValue;
	/**
	 * 新值
	 */
	public String newValue;
	public Boolean propertyIsCData;//CData属性值类型;
	public String propertyValueByLocation;
	/**
	 * 当前属性的父级
	 */
	public String propertyParent;

	public DiffProperty(Property property) {
		this.property = property;
	}

	public DiffProperty(Property property, String orgValue, String newValue, Boolean propertyIsCData, String propertyValueByLocation, String propertyParent) {
		this.property = property;
		this.orgValue = orgValue;
		this.newValue = newValue;
		this.propertyIsCData = propertyIsCData;
		this.propertyValueByLocation = propertyValueByLocation;
		this.propertyParent = propertyParent;
	}

	public DiffProperty(Property property, String orgValue, String newValue) {
		this.property = property;
		this.orgValue = orgValue;
		this.newValue = newValue;
	}

	public JSONObject toJson() {
		JSONObject json = new JSONObject();
		json.put("property", property.name);
		json.put("orgValue", orgValue);
		json.put("newValue", newValue);
		return json;
	}

	public static DiffProperty fromJson(JSONObject json) {
		String propertyName = json.getString("property");
		DiffProperty result = new DiffProperty(Property.getProperty(propertyName));
		if (json.has("orgValue")) {
			result.orgValue = json.get("orgValue").toString();
		}
		result.newValue = json.get("newValue").toString();
		if (json.has("propertyIsCData")) {
			result.propertyIsCData = (Boolean) json.get("propertyIsCData");
		}
		if (json.has("propertyValueByLocation")) {
			result.propertyValueByLocation = json.get("propertyValueByLocation").toString();
		}
		if (json.has("propertyParent")) {
			result.propertyParent = json.get("propertyParent").toString();
		}

		return result;
	}

	public String getOrgValue() {
		return orgValue;
	}

	public void setOrgValue(String orgValue) {
		this.orgValue = orgValue;
	}

	public String getNewValue() {
		return newValue;
	}

	public void setNewValue(String newValue) {
		this.newValue = newValue;
	}

	@Override
	public String toString() {
		return new StringBuilder().append("property:").append(property).append(" orgValue:").append(orgValue).append(" newValue:").append(newValue).toString();
	}
}