package com.bokesoft.erp.entity.util;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class FileChooserExample {
    public static void main(String[] args) {
        // 创建一个新的JFrame实例
        JFrame frame = new JFrame("File Chooser Example");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(300, 200);

        // 创建一个按钮，点击时打开文件选择器
        JButton button = new JButton("选择文件");
        button.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                int returnValue = fileChooser.showOpenDialog(null);
                if (returnValue == JFileChooser.APPROVE_OPTION) {
                    File selectedFile = fileChooser.getSelectedFile();
                    System.out.println("选择的文件路径: " + selectedFile.getAbsolutePath());
                }
            }
        });

        // 将按钮添加到JFrame中
        frame.getContentPane().add(button);

        // 显示JFrame
        frame.setVisible(true);
    }
}