package com.bokesoft.erp.designerxmlattr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.AbstractNode;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yigo.common.util.FileUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.reflections.Reflections;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.*;

public class GenerateXmlAttrsJsonFile {
    public static void main(String[] args) {
        readXmlAttrs();
    }
    public static void readXmlAttrs() {
        try {
            //设计器中已配置的属性信息
            Map<String, String> fieldDesc = getFieldDesc();
            Map<String, JSONObject> map = Collections.synchronizedMap(new HashMap<>());
            Reflections reflections = new Reflections("com.bokesoft");
            //Meta开头，有getTagName方法的类
            Set<Class<? extends AbstractMetaObject>> classes = reflections.getSubTypesOf(AbstractMetaObject.class);
            classes.parallelStream().forEach(item -> generateXmlAttrsMap(item, map, fieldDesc));
            // 保存json数据
            String FunctionsJson = JSON.toJSONString(map, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.PrettyFormat);
            writeToFile(FunctionsJson);
        } catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
        }
    }

    private static void writeToFile(String functionsJson) {
        File file = FileUtils.getFile(WebDesignerConfiguration.getxmlAttrJsonFilePath());
        try (FileOutputStream outputStream = FileUtils.openOutputStream(file)) {
            outputStream.write(functionsJson.getBytes(StandardCharsets.UTF_8));
        } catch (IOException e) {
            LogSvr.getInstance().error(e.getMessage(), e);
        }
    }

    //读取组件的属性
    private static void generateXmlAttrsMap(Class<? extends AbstractMetaObject> clazz, Map<String, JSONObject> fieldMap, Map<String, String> fieldDesc) {
        try {
            clazz.getMethod("getTagName");//检查是否有getTagName方法，判断是否是xml相关
            String tagName = StringUtils.isNotEmpty(clazz.getSimpleName()) ? clazz.getSimpleName().substring(4) : "";
            if (StringUtils.isNotEmpty(tagName)) {
                readAttrsFromMeta(clazz, tagName, fieldMap, fieldDesc);
                while (clazz.getSuperclass() != null && clazz.getSuperclass() != AbstractMetaObject.class) {
                    clazz = (Class<? extends AbstractMetaObject>) clazz.getSuperclass();
                    readAttrsFromMeta(clazz, tagName, fieldMap, fieldDesc);
                }
            }
        } catch (NoSuchMethodException | FileNotFoundException e) {
            LogSvr.getInstance().error(e.getMessage(), e);
        }
    }

    private static void readAttrsFromMeta(Class<? extends AbstractMetaObject> clazz, String tagName, Map<String, JSONObject> fieldMap, Map<String, String> fieldDesc) throws FileNotFoundException {
        JSONObject jsonObject = new JSONObject();
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            PropertyDescriptor pd;
            try {
                pd = new PropertyDescriptor(field.getName(), clazz);//检查是否有get/set方法
            } catch (IntrospectionException e) {
                continue;
            }
            if (pd != null && (field.getType() == Integer.class
                    || field.getType() == String.class
                    || field.getType() == Boolean.class
                    || field.getType() == Byte.class
                    || field.getType() == Short.class
                    || field.getType() == Long.class
                    || field.getType() == Float.class
                    || field.getType() == Double.class
                    || field.getType() == DefSize.class)) {
                String attrName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                String fieldDtl = fieldDesc.get(attrName.toUpperCase());
                if (StringUtils.isNotEmpty(fieldDtl)) {
                    jsonObject.put(attrName, fieldDtl);
                }
            } else if (field.getType().toString().endsWith("Properties")) {
                for (Field childField : field.getType().getDeclaredFields()) {
                    childField.setAccessible(true);
                    try {
                        pd = new PropertyDescriptor(childField.getName(), field.getType());//检查是否有get/set方法
                    } catch (IntrospectionException e) {
                        continue;
                    }
                    if (pd != null && (childField.getType() == Integer.class
                            || childField.getType() == String.class
                            || childField.getType() == Boolean.class
                            || field.getType() == Byte.class
                            || field.getType() == Short.class
                            || field.getType() == Long.class
                            || field.getType() == Float.class
                            || field.getType() == Double.class)) {
                        String attrName = childField.getName().substring(0, 1).toUpperCase() + childField.getName().substring(1);
                        String fieldDtl = fieldDesc.get(attrName.toUpperCase());
                        if (StringUtils.isNotEmpty(fieldDtl)) {
                            jsonObject.put(attrName, fieldDtl);
                        }
                    }
                }
            }
        }
        if (jsonObject.length() > 0) {
            if (fieldMap.get(tagName) != null) {
                for (String key : fieldMap.get(tagName).keySet()) {
                    jsonObject.put(key, fieldMap.get(tagName).get(key));
                }
            }
            fieldMap.put(tagName, jsonObject);
        }
    }

    //xml属性信息
    private static Map<String, String> getFieldDesc() {
        Map<String, String> attrMap = new HashMap<>();
        try {
            String rootPath = "作为工具自行填写路径";
            String propertyLoadFilePath = FilePathHelper.toFrontFilePath(rootPath + "/solutions/sln-erpdesigner-solution/webconfig/Form/IOMetaObject/PropertyLoadPanel");
            String propertySettingFilePath = FilePathHelper.toFrontFilePath(rootPath + "/solutions/sln-erpdesigner-solution/webconfig/Form/IOMetaObject/PropertySettingPanel");
            File propertyLoadFile = new File(propertyLoadFilePath);
            File propertySettingFile = new File(propertySettingFilePath);
            File[] allFiles = ArrayUtils.addAll(propertyLoadFile.listFiles(), propertySettingFile.listFiles());
            for (File file : allFiles) {
                String xml = FileUtil.File2String(file.getAbsolutePath());
                if (xml == null){
                    continue;
                }
                XmlTree xmlTree = XmlParser.parse(xml, false, false);
                TagNode bodyNode = xmlTree.getRoot().findFirstTagNodeByTagName("Block");
                readDesignXml(bodyNode.getChildren(), attrMap);
            }
            return attrMap;
        } catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
            return attrMap;
        }
    }

    private static Map<String, String> readDesignXml(List<AbstractNode> attrNodes, Map<String, String> attrMap) {
        for (AbstractNode node : attrNodes) {
            if (node instanceof TagNode) {
                TagNode attrNode = (TagNode) node;
                if (StringUtils.endsWith(attrNode.getTagName(), "Panel")
                        || StringUtils.equals(attrNode.getTagName(), ConstantUtil.GRID)
                        || StringUtils.equals(attrNode.getTagName(), ConstantUtil.GRID_COLUMN_COLLECTION)) {
                    readDesignXml(attrNode.getChildren(), attrMap);
                } else {
                    String key = attrNode.getAttributes().get(ConstantUtil.KEY);
                    String caption = attrNode.getAttributes().get(ConstantUtil.CAPTION);
                    if (key != null && caption != null) {
                        //部分标识有前缀,去除大小写影响
                        key = key.lastIndexOf("_") != -1 ? key.substring(key.lastIndexOf("_") + 1).toUpperCase() : key.toUpperCase();
                        if (StringUtils.isNotBlank(attrMap.get(key)) && !ArrayUtils.contains(attrMap.get(key).split("/"), caption)) {
                            attrMap.put(key, attrMap.get(key) + "/" + caption);
                        } else {
                            attrMap.put(key, caption);
                        }
                    }
                }
            }
        }
        return attrMap;
    }
}
