package com.bokesoft.erp.all.initiator;

import com.bokesoft.erp.WebDesignerConfiguration;
import com.bokesoft.erp.desigerfunction.datasource.GenerateFunctionsJsonFile;
import com.bokesoft.erp.webdesigner.language.LanguageInitiator;
import com.bokesoft.erp.webdesigner.language.infrastructure.debugger.DesignerDebuggerImpl;
import com.bokesoft.yes.base.IStartListener;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.design.cmd.ExpAutoCompleteCmd;
import com.bokesoft.yes.design.io.LoadFileTree;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.ReloadForm;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.helper.FilePathHelper;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDataElementDefLoad;
import com.bokesoft.yes.meta.persist.dom.commondef.MetaDomainDefLoad;
import com.bokesoft.yes.parser.ExprDebuggerProxy;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;
import com.bokesoft.yigo.meta.domain.MetaDomain;
import com.bokesoft.yigo.meta.domain.MetaDomainCollection;
import com.bokesoft.yigo.meta.domain.MetaDomainDef;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * 初始化设计器相关配置
 *
 * @author zhangk
 */
public class InitializingDesigner implements IStartListener {

    private static List<String> FormulaKeys;

    private static boolean enable = false;
    private static int initCacheID = 0;//初始化前端文件树缓存

    public static int isInitCacheID() {
        return initCacheID;
    }

    public static void setInitCache(int initCacheID) {
        InitializingDesigner.initCacheID = initCacheID;
    }

    public static boolean isEnable() {
        return enable;
    }

    public static void setEnable(boolean enable) {
        InitializingDesigner.enable = enable;
    }

    @Override
    public void invoke(DefaultContext defaultContext) throws Throwable {

        Random random = new Random();
        initCacheID  = random.nextInt();

        // 为了提前进行变量初始化
        InitializingDesigner.getFormulaKeys();
        ExecutorService executorService = new ThreadPoolExecutor(6, 10, 10, TimeUnit.SECONDS, new ArrayBlockingQueue<>(5));
        String solutionspath = WebDesignerConfiguration.getDesignerDataPath() + File.separator + "solutions";
        //注入数据元素和域
        executorService.execute(() -> {
            InputStream domain = getClass().getResourceAsStream("/Designer_Domain.xml");
            MetaDomainDefLoad domainLoad = new MetaDomainDefLoad(AppRunType.App);
            InputStream dataElement = getClass().getResourceAsStream("/Designer_DataElement.xml");
            MetaDataElementDefLoad dataElementLoad = new MetaDataElementDefLoad(AppRunType.App);
            try {
                //域处理
                domainLoad.load(domain);
                MetaDomainDef metaDomainDef = (MetaDomainDef) domainLoad.getRootMetaObject();
                for (MetaDomain metaDomain : metaDomainDef.getDomainCollection()) {
                    MetaDomain domain1 = MetaUtil.getDomain(MetaFactory.getGlobalInstance(), metaDomain.getKey());
                    if(domain1 == null) {
                        String key = MetaFactory.getGlobalInstance().getSolution().getKey();
                        MetaDomainCollection domainCollection = MetaFactory.getGlobalInstance().getDomainDef(key).getDomainCollection();
                        domainCollection.add(metaDomain);
                    }
                }
                //数据元素处理
                dataElementLoad.load(dataElement);
                MetaDataElementDef metaDataElementDef = (MetaDataElementDef) dataElementLoad.getRootMetaObject();
                for (MetaDataElement metaDataElement : metaDataElementDef.getDataElementCollection()) {
                    MetaDataElement dataElement1 = MetaUtil.getDataElement(MetaFactory.getGlobalInstance(), metaDataElement.getKey());
                    if (dataElement1 == null) {
                        String key = MetaFactory.getGlobalInstance().getSolution().getKey();
                        MetaDataElementCollection dataElementCollection = MetaFactory.getGlobalInstance().getDataElementDef(key).getDataElementCollection();
                        String domainKey = metaDataElement.getDomainKey();
                        MetaDomain domain1 = MetaUtil.getDomain(MetaFactory.getGlobalInstance(), domainKey);
                        metaDataElement.setDomain(domain1);
                        dataElementCollection.add(metaDataElement);
                    }
                }

                MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
                Set<String> formKeySet = new HashSet<>(metaFormList.keySet());
                for (String formKey : formKeySet) {
                    ReloadForm.processTemplateDataElement(MetaFactory.getGlobalInstance(), MetaFactory.getGlobalInstance().getMetaForm(formKey));
                }
            } catch (Throwable e) {
                throw new RuntimeException(e);
            }

        });
        //执行生成所有表达式的服务端缓存
        executorService.execute(ExpAutoCompleteCmd::generateFunctionCache);
        if (InitializingDesigner.enable) {
            //执行生成设计器偏好等数据的json文件
            executorService.execute(() -> {
                String settingPath = WebDesignerConfiguration.getDesignerDataPath()  + File.separator + "DesignerData.xml";
                String designerPath = WebDesignerConfiguration.getDesignerDataPath();
                File file = new File(settingPath);
                File designerDir = new File(designerPath);
                if(!designerDir.exists()){
                    designerDir.mkdirs();
                }
                boolean exists = file.exists() && file.isFile();
                if(!exists){
                    writeDesignerDatatoFile(file);
                }
            });
            //  执行生成表达式后端json文件的类
            executorService.execute(() -> {
                GenerateFunctionsJsonFile.generateFunctionsJsonFile();
                GenerateFunctionsJsonFile.writeToFile(GenerateFunctionsJsonFile.FunctionsJson);
            });
            //设置Session过期时间
            executorService.execute(() -> {
                // Environment environment = SpringContextUtil.getApplicationContext().getBean(Environment.class);
                // boolean enable = environment.getProperty("application-erp.webdesigner.enable", boolean.class);
                //设置Session过期时间
                ISessionInfoProvider simpleProvider = SessionInfoProviderHolder.getSimpleProvider();
                ISessionInfoMap sessionInfoMap = simpleProvider.getSessionInfoMap();
                if (sessionInfoMap.getTimeout() == 3600) {//如果是默认的加大默认时间
                    sessionInfoMap.setTimeout(86400);
                }
            });
            //加载文件树
            executorService.execute(() -> {
                try {
                    if (!delAllFile(solutionspath)) {
                        (new File(solutionspath)).mkdir();
                    }

                    LoadFileTree.ensureLoad();

                    // 索引初始化
                    Collection<String> solutionPaths = LoadFileTree.metaDesignerSolutionPathMap.values();
                    LanguageInitiator.init(solutionPaths);

                    try {
                        Set<String> designerSolutionTmpDataPaths =
                                WebDesignerConfiguration.getDesignerSolutionTmpDataPaths();
                        for (String designerSolutionTmpDataPath : designerSolutionTmpDataPaths) {
                            boolean exists = delAllFile(designerSolutionTmpDataPath);
                            if (!exists) {
                                (new File(designerSolutionTmpDataPath)).mkdir();
                            }
                        }
                    } catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                } catch (Throwable e) {
                    LogSvr.getInstance().error(e.getMessage(), e);
                }
            });
            // 设置调试器
            DesignerDebuggerImpl debugger = new DesignerDebuggerImpl();
            ExprDebuggerProxy.setExprDebugger(debugger);
        }

        executorService.shutdown();
    }

    public static List<String> getFormulaKeys() throws IOException {
        if (InitializingDesigner.FormulaKeys != null) {
            return InitializingDesigner.FormulaKeys;
        }
        // 获得指定文件对象
        File file = FileUtils.getFile(FilePathHelper.getCoreSolutionPath(), "Formula");
        if (!file.exists()) {
            file.mkdir();
        }
        // 获得该文件夹内的所有文件
        File[] array = file.listFiles();
        // 文件夹下没有文件

        List<String> fileNames = new ArrayList<>();
        if (ArrayUtils.isEmpty(array)) {
            return fileNames;
        }
        for (int i = 0; i < array.length; i++) {
            if (array[i].isFile()) {
                String name = array[i].getName();
                fileNames.add(name.substring(0, name.indexOf(".")));
            }
        }
        InitializingDesigner.FormulaKeys = fileNames;
        return fileNames;
    }

    /**
     * 删除指定文件夹下的所有文件
     */
    private static boolean delAllFile(String path) {
        File file = new File(path);
        boolean exists = file.exists() && file.isDirectory();
        if (exists) {
            String[] tempList = file.list();
            File temp = null;
            if (tempList != null) {
                for (String s : tempList) {
                    if (path.endsWith(File.separator)) {
                        temp = new File(path + s);
                    } else {
                        temp = new File(path + File.separator + s);
                    }
                    if (temp.isFile()) {
                        temp.delete();
                    }
                    if (temp.isDirectory()) {
                        //先删除文件夹里面的文件
                        delAllFile(path + File.separator + s);
                        //再删除空文件夹
                        delFolder(path + File.separator + s);
                    }
                }
            }
        }
        return exists;
    }

    /**
     * 删除文件夹
     */
    public static void delFolder(String folderPath) {
        try {
            //删除完里面所有内容
            delAllFile(folderPath);
            java.io.File myFilePath = new java.io.File(folderPath);
            //删除空文件夹
            myFilePath.delete();
        } catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), e);
        }
    }
    public static void writeDesignerDatatoFile(File file){
        try {
            file.createNewFile();
            TagNode root = new TagNode("DesignerData", null);
            TagNode Preference = new TagNode("Preference", null);
            TagNode renderType = new TagNode("RenderType", null).setAttribute("Value","true");
            TagNode isShowData = new TagNode("IsShowData", null).setAttribute("Value","false");
            TagNode isSetKeyAndCaption = new TagNode("IsSetKeyAndCaption", null).setAttribute("Value","true");
            TagNode xmlWordWrap = new TagNode("XmlWordWrap", null).setAttribute("Value","true");
            TagNode showError = new TagNode("ShowError", null).setAttribute("Value","true");
            TagNode delayedProcessScope = new TagNode("DelayedProcessScope", null).setAttribute("Value","false");
            TagNode expandAllPropertyPanelGroup = new TagNode("ExpandAllPropertyPanelGroup", null).setAttribute("Value","false");
            TagNode autoLocateFileTree = new TagNode("AutoLocateFileTree", null).setAttribute("Value","true");
            Preference.addNode(renderType);
            Preference.addNode(isShowData);
            Preference.addNode(isSetKeyAndCaption);
            Preference.addNode(xmlWordWrap);
            Preference.addNode(showError);
            Preference.addNode(delayedProcessScope);
            Preference.addNode(expandAllPropertyPanelGroup);
            Preference.addNode(autoLocateFileTree);
            root.addNode(Preference);
            String xml = DesignIOMetaUtil.getXml(root);
            org.apache.commons.io.FileUtils.writeStringToFile(file,xml,"UTF-8");
        }  catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}
