package com.bokesoft.erp.all.controller.util;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.erp.all.controller.SettingControl;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.design.cmd.UICommand;
import com.bokesoft.yes.design.setting.impl.SettingService;
import com.bokesoft.yes.design.vo.ResponseResult;
import com.bokesoft.yes.design.vo.SettingVo;
import com.bokesoft.yes.tools.zip.GZIPTools;
import org.apache.commons.lang3.exception.ExceptionUtils;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class SettingControlUtil {

    private static final Logger logger = Logger.getLogger(SettingControl.class.getName());
    public static void getYigoData(SettingVo settingVo) throws Throwable {
        String yigoData = settingVo.getYigoData();
        if (yigoData != null) {
            byte[] bytes = Base64.decode(yigoData.getBytes());
            String resultDate = GZIPTools.decompress(new ByteArrayInputStream(bytes), "UTF-8");
            JSONObject jsonObject = JSONObject.parseObject(resultDate);
            settingVo.setDiff(jsonObject.getString("diff"));
            settingVo.setDocument(jsonObject.getString("document"));
            settingVo.setFormkey(jsonObject.getString("formkey"));
            settingVo.setPath(jsonObject.getString("path"));
            settingVo.setType(jsonObject.getString("type"));
        }
    }



    public static ResponseResult<JSONObject> getResponseResult(SettingVo settingVo, SettingService handleSetting) {
        ResponseResult<JSONObject> response = new ResponseResult<>();
        try {
            //对前端数据进行解压缩
            getYigoData(settingVo);
            return handleSetting.handleData(settingVo);
        } catch (Exception e) {
            String type = settingVo.getType();
            logger.warning("获取" + type + "数据失败，异常信息为:" + ExceptionUtils.getStackTrace(e));
            response.setCode(999);
            response.setMsg("获取获取" + type + "数据失败数据失败，失败信息为:" + e.getMessage());
            List<UICommand> uiCommands = new ArrayList<>();
            uiCommands.add(UICommand.showError(e.getMessage()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("UICommand",uiCommands);
            jsonObject.put("error",true);
            response.setData(jsonObject);
        } catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return response;
    }
}
