local function revtab(tab)
    local revtab = {}
    for k, v in pairs(tab) do
        revtab[v] = k
    end
    return revtab
end

local function unLockOneKey(lockkey)
    local splitString = {}
    string.gsub(
        lockkey,
        "[^:]+",
        function(w)
            table.insert(splitString, w)
        end
    )
    local len = #splitString
    if (splitString[len] == "R") then
        local key = splitString[1]
        for i = 2, len - 2 do
            key = key .. ":" .. splitString[i]
            local curSetKey = key .. ":RS"
            redis.call("srem", curSetKey, lockkey)
            if (i == len - 3) then
                curSetKey = key .. ":RSel"
                redis.call("srem", curSetKey, lockkey)
            end
        end
    else
        local key = splitString[1]
        for i = 2, len do
            key = key .. ":" .. splitString[i]
            local curSetKey = key .. ":WS"
            redis.call("srem", curSetKey, lockkey)
        end
    end
    redis.call("del", lockkey, lockkey .. "N")
end

local all_session_key = KEYS[1]
local active_sessions = revtab(ARGV)
local alllocksessions = redis.call("smembers", all_session_key)

local needclearsessions = {}
for index, session in pairs(alllocksessions) do
    if (active_sessions[session] == nil) then
        local docKeys = redis.call("smembers", session)
        for index, docKey in pairs(docKeys) do
            -- 得到加的锁key
            local lockKeys = redis.call("smembers", docKey)
            for index, lockKey in pairs(lockKeys) do
                unLockOneKey(lockKey)
            end
            --  删除dockey
            redis.call("del", docKey)
        end

        -- 删除session
        redis.call("srem", all_session_key, session)
    end
end
