/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.serviceloader;

import com.bokesoft.distro.tech.commons.basis.dependency.DependencySortCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class YigoServiceLoader {
    private static final Map<Class<?>, Iterable<Object>> map = new ConcurrentHashMap();
    private static final Map<Class<?>, Set<? extends Object>> registeredServices = new ConcurrentHashMap();

    public static <S> Iterable<S> load(Class<S> clazz) {
        Object object2;
        if (map.containsKey(clazz)) {
            return map.get(clazz);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ServiceLoader<S> serviceLoader = ServiceLoader.load(clazz, classLoader);
        List<Object> list = new ArrayList<S>();
        for (Object object2 : serviceLoader) {
            list.add(object2);
        }
        object2 = registeredServices.get(clazz);
        if (object2 != null) {
            list.addAll((Collection<S>)object2);
        }
        list = DependencySortCore.sort(list);
        map.put(clazz, list);
        return map.get(clazz);
    }

    public static synchronized <S> void register(Class<S> clazz2, S s) {
        if (!clazz2.isAssignableFrom(s.getClass())) {
            throw new UnsupportedOperationException("'" + s.getClass() + "' \u65e0\u6cd5\u88ab\u6ce8\u518c\u4e3a '" + clazz2 + "' \u7c7b\u578b\u7684\u670d\u52a1");
        }
        Set set = registeredServices.computeIfAbsent(clazz2, clazz -> {
            HashSet hashSet = new HashSet();
            return hashSet;
        });
        set.add(s);
        map.remove(clazz2);
    }
}

