/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.erp.scope;

import com.bokesoft.yes.erp.scope.CommonInfo;
import com.bokesoft.yes.erp.scope.DebugInfo;
import java.util.Stack;
import javassist.CtBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugInfos {
    private static final Logger logger = LoggerFactory.getLogger(DebugInfos.class);
    public static boolean isDebug = logger.isDebugEnabled();
    Stack<Object> a = isDebug ? new Stack() : null;
    private static DebugInfos noDebug;

    public void popInfo() {
        if (!isDebug) {
            return;
        }
        this.a.pop();
    }

    public void pushInfo(Object ... objectArray) {
        if (!isDebug) {
            return;
        }
        CommonInfo commonInfo = new CommonInfo(objectArray);
        this.a.push(commonInfo);
    }

    public void pushMethodAndOffset(CtBehavior ctBehavior, int n) {
        if (!isDebug) {
            return;
        }
        DebugInfo debugInfo = new DebugInfo(ctBehavior, n);
        this.a.push(debugInfo);
    }

    public void setMethodOffset(CtBehavior ctBehavior, int n) {
        if (!isDebug) {
            return;
        }
        if (this.a.size() == 0) {
            return;
        }
        DebugInfo debugInfo = (DebugInfo)this.a.peek();
        CtBehavior cfr_ignored_0 = debugInfo.a;
        debugInfo.b = n;
    }

    public static DebugInfos getDebugInfos(Object ... objectArray) {
        if (!isDebug) {
            return DebugInfos.getNoDebug();
        }
        DebugInfos debugInfos = new DebugInfos();
        debugInfos.pushInfo(objectArray);
        return debugInfos;
    }

    public static DebugInfos getNoDebug() {
        if (isDebug) {
            throw new AssertionError();
        }
        if (noDebug == null) {
            DebugInfos debugInfos = new DebugInfos();
            debugInfos.pushInfo("org.slf4j.Logger.isDebugEnabled()=false\uff0c\u65e0\u8c03\u8bd5\u4fe1\u606f\u3002");
            noDebug = debugInfos;
        }
        return noDebug;
    }

    public DebugInfos snapShot() {
        if (!isDebug) {
            return DebugInfos.getNoDebug();
        }
        DebugInfos debugInfos = new DebugInfos();
        int n = 0;
        int n2 = this.a.size();
        while (n < n2) {
            Object e = this.a.get(n);
            if (e instanceof CommonInfo) {
                debugInfos.a.add(e);
            } else {
                DebugInfo debugInfo = (DebugInfo)e;
                debugInfos.a.add(new DebugInfo(debugInfo.a, debugInfo.b));
            }
            ++n;
        }
        return debugInfos;
    }

    public String toString() {
        if (!isDebug) {
            return "\u975e\u8c03\u8bd5\u72b6\u6001\u4e0b\u65e0\u4fe1\u606f";
        }
        StringBuilder stringBuilder = new StringBuilder(512);
        for (Object e : this.a) {
            stringBuilder.append(e).append("\n");
        }
        return stringBuilder.toString();
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(512);
        for (Object e : this.a) {
            stringBuilder.append(e).append("\n");
        }
        return stringBuilder.toString();
    }
}

