/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.erp.message.base.context;

import com.bokesoft.yes.erp.message.base.model.MessageData;
import com.bokesoft.yes.erp.message.base.model.MessageEventData;
import com.bokesoft.yes.erp.message.base.model.MessageException;
import com.bokesoft.yes.erp.message.base.model.MessageType;
import com.bokesoft.yes.util.ERPStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageContext {
    private static final InheritableThreadLocal<List<MessageData>> MESSAGE_DATA_HOLDER = new InheritableThreadLocal();
    private static final InheritableThreadLocal<MessageEventData> EVENT_DATA_HOLDER = new InheritableThreadLocal();

    public static List<MessageData> getContextMessage() {
        List list = (List)MESSAGE_DATA_HOLDER.get();
        if (list == null) {
            list = Collections.synchronizedList(new ArrayList());
            MESSAGE_DATA_HOLDER.set(list);
            list = new ArrayList();
        }
        return list;
    }

    public static void reset() {
        MESSAGE_DATA_HOLDER.remove();
        EVENT_DATA_HOLDER.remove();
    }

    public static MessageEventData getMessageEventData() {
        MessageEventData messageEventData = (MessageEventData)EVENT_DATA_HOLDER.get();
        return messageEventData;
    }

    public static void setEventData(MessageEventData messageEventData) {
        EVENT_DATA_HOLDER.set(messageEventData);
    }

    public static List<MessageData> filterSkippedMessage(List<MessageData> list) {
        MessageEventData messageEventData = MessageContext.getMessageEventData();
        ArrayList<MessageData> arrayList = new ArrayList<MessageData>();
        if (messageEventData == null) {
            return arrayList;
        }
        List<String> list2 = messageEventData.getSkippedDigests();
        for (MessageData messageData : list) {
            if (messageData.isExisted(list2)) continue;
            arrayList.add(messageData);
        }
        return arrayList;
    }

    public static void pushMessageData(MessageData messageData, String string) {
        MessageContext.completeMessageData(messageData);
        if (ERPStringUtil.isNotBlankOrNull(string)) {
            messageData.setType(MessageType.valueOfString(string));
        }
        List<MessageData> list = MessageContext.getContextMessage();
        MessageEventData messageEventData = MessageContext.getMessageEventData();
        try {
            List<String> list2;
            if (messageData.getType().getValue() < messageEventData.getBreakLevel().getValue()) {
                boolean bl = false;
                for (MessageData messageData2 : list) {
                    if (!messageData2.getDigest().equalsIgnoreCase(messageData.getDigest())) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    list.add(messageData);
                }
            } else if (!(messageData.getType().getValue() == messageEventData.getSupportSkipLevel().getValue() && MessageContext.isOptSkippedAll(messageEventData, messageData) || messageData.isExisted(list2 = messageEventData.getSkippedDigests()))) {
                throw new MessageException(messageData, MessageContext.getContextMessage());
            }
        }
        finally {
            messageEventData.getContext().setPara("MessageList", list);
        }
    }

    public static void completeMessageData(MessageData messageData) {
        MessageEventData messageEventData = MessageContext.getMessageEventData();
        if (messageEventData == null) {
            throw new RuntimeException("\u8bf7\u8054\u7cfb\u5f00\u53d1\u8005\uff0c\u4fee\u6539\u62a5\u9519\u65b9\u5f0f:\u4e0d\u8981\u4f7f\u7528\u6d88\u606f\u673a\u5236\uff0c\u76f4\u63a5\u629b\u51fa\u9519\u8bef\u3002");
        }
        messageData.setFormId(messageEventData.getFormId()).setOptKey(messageEventData.getOptKey()).setOptType(messageEventData.getOptType()).setOptCaption(messageEventData.getOptCaption());
        try {
            messageData.complete();
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public static List<MessageData> getFinalMessageData() throws Throwable {
        List<MessageData> list = MessageContext.filterSkippedMessage(MessageContext.getContextMessage());
        return list;
    }

    public static boolean isOptSkippedAll(MessageEventData messageEventData, MessageData messageData) {
        boolean bl = false;
        if (messageData == null || messageData.getFormId() == null || messageData.getOptType() == null || messageData.getOptKey() == null) {
            return false;
        }
        List<String> list = messageEventData.getSkipAllMessages();
        if (list == null) {
            return false;
        }
        String string = messageData.getFormId().concat(messageData.getOptType()).concat(messageData.getOptKey());
        for (String string2 : list) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return bl;
    }
}

