/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.erp.lock;

import com.bokesoft.distro.tech.bizlock.api.IBizLock;
import com.bokesoft.distro.tech.bizlock.api.RWShareModel;
import com.bokesoft.distro.tech.bizlock.api.TagDataOption;
import com.bokesoft.distro.tech.bizlock.api.TagOption;
import com.bokesoft.distro.tech.bizlock.api.exception.BizLockProcessException;
import com.bokesoft.distro.tech.bizlock.api.struct.LockData;
import com.bokesoft.distro.tech.bizlock.api.struct.LockOption;
import com.bokesoft.distro.tech.bizlock.api.struct.TagsCondition;
import com.bokesoft.yes.erp.lock.ActiveFormContext;
import com.bokesoft.yes.erp.lock.IERPBizLock;
import com.bokesoft.yes.erp.lock.LockItem;
import com.bokesoft.yes.util.ERPDateUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.struct.util.DataTableCreator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ERPBizLock
implements IERPBizLock {
    private static final Logger logger = LoggerFactory.getLogger(ERPBizLock.class);
    private final IBizLock a;
    private final long b;
    private static final int LOCK_MODE_TAG_INDEX = 0;
    private static final int ERP_CLIENTID_TAG_INDEX = 1;
    private static final int YIGO_CLIENTID_TAG_INDEX = 2;
    private static final int FORM_ID_TAG_INDEX = 3;
    private static final int USER_ID_TAG_INDEX = 4;
    private static final int LOCK_VALUE_START_TAG_INDEX = 5;
    private static final int LOCK_OPT_FORM_KEY_ADDITION_INDEX = 0;
    private static final int LOCK_OPT_DOCUMENT_NUMBER_ADDITION_INDEX = 1;
    private static final String LOCK_VALUE_PREFIX = "LOCK_VALUE";

    private IBizLock a() {
        return this.a;
    }

    public ERPBizLock(IBizLock iBizLock, long l) {
        this.a = iBizLock;
        this.b = l;
    }

    @Override
    public String addLock(DefaultContext defaultContext, LockItem lockItem) {
        String string = lockItem.getLockBillKey();
        String string2 = lockItem.getLockObjectKey();
        Long[] longArray = lockItem.getLockValue();
        String string3 = lockItem.getLockMode();
        ActiveFormContext activeFormContext = lockItem.getLockViewerContent();
        String string4 = this.a(string, string2);
        String string5 = activeFormContext.getFormKey();
        String string6 = activeFormContext.getDocumentNumber();
        LockOption lockOption = ERPBizLock.c();
        List<String> list = ERPBizLock.a(activeFormContext, lockOption, string3, longArray);
        try {
            String[] stringArray = list.toArray(new String[0]);
            this.a().acquire(string4, stringArray, this.b, lockOption, new String[]{string5, string6});
            return "";
        }
        catch (BizLockProcessException bizLockProcessException) {
            logger.error(bizLockProcessException.getMessage(), (Throwable)bizLockProcessException);
            LockData lockData = bizLockProcessException.getLockData();
            if (lockData == null || defaultContext == null) {
                return (String)ExceptionUtils.rethrow((Throwable)bizLockProcessException);
            }
            return this.a(defaultContext, lockData);
        }
        catch (Exception exception) {
            return (String)ExceptionUtils.rethrow((Throwable)exception);
        }
    }

    private String a(String string, String string2) {
        return StringUtils.join((Object[])new String[]{string, string2.toUpperCase()}, (String)"|");
    }

    private String a(DefaultContext defaultContext, LockData lockData) {
        try {
            String[] stringArray = lockData.getTagValues();
            Long l = TypeConvertor.toLong((Object)stringArray[4]);
            String[] stringArray2 = lockData.getAdditionInfo();
            String string = "";
            if (stringArray2 != null && stringArray2.length > 0) {
                string = stringArray2[0];
            }
            String string2 = "";
            if (stringArray2 != null && stringArray2.length > 1) {
                string2 = stringArray2[1];
            }
            Item item = defaultContext.getDictCache().getItem("Operator", l.longValue());
            String string3 = TypeConvertor.toString((Object)item.getValue("Name"));
            String string4 = lockData.getLockType();
            String[] stringArray3 = StringUtils.split((String)string4, (String)"|");
            String string5 = stringArray3[0];
            IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
            String string6 = "";
            if (iMetaFactory.hasMetaForm(string)) {
                string6 = iMetaFactory.getMetaForm(string).getCaption();
            }
            StringBuilder stringBuilder = new StringBuilder(1024);
            this.a(stringBuilder, true, string3, "\u6b63\u5728\u64cd\u4f5c", string6, string2);
            if (string.equalsIgnoreCase(string5)) {
                this.a(stringBuilder, false, ";");
            } else {
                String string7 = "";
                if (iMetaFactory.hasMetaForm(string5)) {
                    string7 = iMetaFactory.getMetaForm(string5).getCaption();
                }
                this.a(stringBuilder, true, "\u65f6\u5df2\u5904\u7406", string7);
                this.a(stringBuilder, false, "%s;");
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return (String)ExceptionUtils.rethrow((Throwable)throwable);
        }
    }

    private void a(StringBuilder stringBuilder, boolean bl, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            stringBuilder.append(bl ? StringUtils.replace((String)string, (String)"%", (String)"%%") : string);
            ++n2;
        }
    }

    @Override
    public void batchUnLock(ActiveFormContext activeFormContext, String string, String string2, String string3, List<Long[]> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        String string4 = this.a(string2, string3);
        LockOption lockOption = ERPBizLock.c();
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>(list.size());
        try {
            for (Long[] longArray : list) {
                List<String> list2 = ERPBizLock.a(activeFormContext, lockOption, string, longArray);
                arrayList.add(list2);
                this.a().release(string4, list2.toArray(new String[0]), lockOption);
            }
        }
        catch (Exception exception) {
            ExceptionUtils.rethrow((Throwable)exception);
        }
    }

    @Override
    public void forceUnLock(ActiveFormContext activeFormContext, String string, String string2, String string3, Long[] longArray) {
        try {
            LockOption lockOption = ERPBizLock.c();
            List<String> list = ERPBizLock.a(activeFormContext, lockOption, string, longArray);
            String string4 = this.a(string2, string3);
            this.a().forceRelease(string4, list.toArray(new String[0]), lockOption);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public void unLock(String string, String ... stringArray) {
        TagsCondition tagsCondition = new TagsCondition().put(2, stringArray);
        if (!StringUtils.isBlank((CharSequence)string)) {
            tagsCondition.put(3, new String[]{string});
        }
        try {
            this.a().releaseByTags(tagsCondition);
        }
        catch (Exception exception) {
            ExceptionUtils.rethrow((Throwable)exception);
        }
    }

    @Override
    public String checkLock(DefaultContext defaultContext, LockItem lockItem) throws Throwable {
        return "";
    }

    @Override
    public void unLockTimeoutClientIDs() {
        long l = ERPDateUtil.getNowTime().getTime();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.a(1, l));
        linkedList.addAll(this.a(2, l));
        this.unLock(null, linkedList.toArray(new String[0]));
    }

    private Set<String> a(int n, long l) {
        HashSet<String> hashSet = new HashSet<String>();
        ISessionInfoProvider iSessionInfoProvider = SessionInfoProviderHolder.getProvider((int)1);
        ISessionInfoMap iSessionInfoMap = iSessionInfoProvider.getSessionInfoMap();
        long l2 = iSessionInfoMap.getTimeout() * 1000;
        Set set = iSessionInfoMap.getKeys();
        for (String string : set) {
            ISessionInfo iSessionInfo = iSessionInfoMap.get(string);
            long l3 = iSessionInfo.getLastActiveTime().getTime();
            if (l - l3 <= l2) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private List<LockData> a(Long l, long l2) {
        IBizLock iBizLock = this.a();
        TagsCondition tagsCondition = new TagsCondition().put(1, new String[]{TypeConvertor.toString((Object)l)});
        if (l2 > 0L) {
            tagsCondition.put(4, new String[]{TypeConvertor.toString((Object)l2)});
        }
        try {
            List list = iBizLock.queryByTags(tagsCondition);
            return list;
        }
        catch (BizLockProcessException bizLockProcessException) {
            return (List)ExceptionUtils.rethrow((Throwable)bizLockProcessException);
        }
    }

    @Override
    public DataTable getAllLocks(Long l, Long l2) throws Throwable {
        DataTable dataTable = ERPBizLock.b();
        List<LockData> list = this.a(l, (long)l2);
        if (list == null || list.size() == 0) {
            return dataTable;
        }
        for (LockData lockData : list) {
            if (lockData == null) continue;
            int n = dataTable.append();
            String string = lockData.getLockType();
            Object[] objectArray = lockData.getTagValues();
            long l3 = lockData.getCreateTime();
            String[] stringArray = StringUtils.split((String)string, (String)"|");
            dataTable.setString(n, "LockMode", objectArray[0]);
            dataTable.setLong(n, "ClientID", TypeConvertor.toLong((Object)objectArray[1]));
            dataTable.setString(n, "SessionID", objectArray[2]);
            dataTable.setString(n, "ActiveViewerID", objectArray[3]);
            dataTable.setLong(n, "OperatorID", TypeConvertor.toLong((Object)objectArray[4]));
            dataTable.setObject(n, "LockTime", (Object)new Date(l3));
            dataTable.setString(n, "OperatorMetaKey", stringArray[0]);
            dataTable.setString(n, "LockBillKey", stringArray[0]);
            dataTable.setString(n, "LockObjectKey", stringArray[1]);
            dataTable.setString(n, "LockValue", StringUtils.replace((String)StringUtils.join((Object[])objectArray, (String)",", (int)5, (int)objectArray.length), (String)"*", (String)"0"));
        }
        return dataTable;
    }

    private static DataTable b() {
        Object[][] objectArray = new Object[][]{{"OID", 1010}, {"SOID", 1010}, {"IsSelect", 1001}, {"SelectField", 1001}, {"Del", 1002}, {"ClientID", 1010}, {"SessionID", 1002}, {"ActiveViewerID", 1002}, {"OperatorID", 1010}, {"LockTime", 1003}, {"OperatorMetaKey", 1002}, {"LockMode", 1002}, {"LockBillKey", 1002}, {"LockObjectKey", 1002}, {"LockValue", 1002}};
        DataTable dataTable = DataTableCreator.create((Object[][])objectArray);
        return dataTable;
    }

    private static LockOption c() {
        LockOption lockOption = new LockOption();
        lockOption.appendTagOption((TagOption)new RWShareModel("RW", "\u9501\u6a21\u5f0f"));
        lockOption.appendTagOption((TagOption)TagDataOption.build((String)"ERPClientID", (String)"ERP\u96c6\u56e2ID").setReentrantMark());
        lockOption.appendTagOption((TagOption)TagDataOption.build((String)"YigoClientID", (String)"Yigo\u4f1a\u8bddID").setReentrantMark());
        lockOption.appendTagOption((TagOption)TagDataOption.build((String)"LockFormIIUD", (String)"\u754c\u9762ID").setReentrantMark());
        lockOption.appendTagOption((TagOption)TagDataOption.build((String)"UserID", (String)"\u7528\u6237ID").setReentrantMark());
        return lockOption;
    }

    private static List<String> a(ActiveFormContext activeFormContext, LockOption lockOption, String string, Long[] longArray) {
        String string2 = TypeConvertor.toString((Object)activeFormContext.getUserID());
        String string3 = activeFormContext.getSessionID();
        String string4 = TypeConvertor.toString((Object)activeFormContext.getClientID());
        String string5 = activeFormContext.getDocumentID();
        String string6 = activeFormContext.getLockGroupUUID();
        if (!StringUtils.isBlank((CharSequence)string6)) {
            string5 = string6;
        }
        ArrayList<String> arrayList = new ArrayList<String>(longArray.length + 5);
        arrayList.add(string);
        arrayList.add(string4);
        arrayList.add(string3);
        arrayList.add(string5);
        arrayList.add(string2);
        int n = 0;
        while (n < longArray.length) {
            Long l = longArray[n];
            if (l <= 0L) {
                arrayList.add("*");
            } else {
                arrayList.add(TypeConvertor.toString((Object)l));
            }
            String string7 = LOCK_VALUE_PREFIX + n;
            lockOption.appendTagOption((TagOption)TagDataOption.build((String)string7, (String)string7).setPrimaryKey());
            ++n;
        }
        return arrayList;
    }
}

