/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.util.deparser;

import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.update.Update;

public class UpdateDeParser {
    protected StringBuffer buffer;
    protected ExpressionVisitor expressionVisitor;

    public UpdateDeParser() {
    }

    public UpdateDeParser(ExpressionVisitor expressionVisitor, StringBuffer buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public void deParse(Update update) {
        Table dataSourceTable;
        this.buffer.append("UPDATE ");
        if (update.isIgnore()) {
            this.buffer.append("IGNORE ");
        }
        Table table = update.getTable();
        this.buffer.append(table.getWholeTableName());
        if (table.getAlias() != null) {
            this.buffer.append(" ").append(table.getAlias());
        }
        if ((dataSourceTable = update.getDataSourceTable()) != null) {
            this.buffer.append(", ").append(dataSourceTable.getWholeTableName());
            if (dataSourceTable.getAlias() != null) {
                this.buffer.append(" ").append(dataSourceTable.getAlias());
            }
        }
        this.buffer.append(" SET ");
        int i = 0;
        while (i < update.getColumns().size()) {
            Column column = (Column)update.getColumns().get(i);
            this.buffer.append(column.getWholeColumnName());
            this.buffer.append("=");
            Expression expression = (Expression)update.getExpressions().get(i);
            expression.accept(this.expressionVisitor);
            if (i < update.getColumns().size() - 1) {
                this.buffer.append(", ");
            }
            ++i;
        }
        if (update.getWhere() != null) {
            this.buffer.append(" WHERE ");
            update.getWhere().accept(this.expressionVisitor);
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }
}

