/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.util.deparser;

import java.util.Iterator;
import net.boke.jsqlparser.statement.StatementVisitor;
import net.boke.jsqlparser.statement.alter.Alter;
import net.boke.jsqlparser.statement.create.index.CreateIndex;
import net.boke.jsqlparser.statement.create.table.CreateTable;
import net.boke.jsqlparser.statement.delete.Delete;
import net.boke.jsqlparser.statement.drop.Drop;
import net.boke.jsqlparser.statement.insert.Insert;
import net.boke.jsqlparser.statement.replace.Replace;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.WithItem;
import net.boke.jsqlparser.statement.truncate.Truncate;
import net.boke.jsqlparser.statement.update.Update;
import net.boke.jsqlparser.util.deparser.CreateTableDeParser;
import net.boke.jsqlparser.util.deparser.DeleteDeParser;
import net.boke.jsqlparser.util.deparser.ExpressionDeParser;
import net.boke.jsqlparser.util.deparser.InsertDeParser;
import net.boke.jsqlparser.util.deparser.ReplaceDeParser;
import net.boke.jsqlparser.util.deparser.SelectDeParser;
import net.boke.jsqlparser.util.deparser.UpdateDeParser;

public class StatementDeParser
implements StatementVisitor {
    protected StringBuffer buffer;

    public StatementDeParser(StringBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(CreateTable createTable) {
        CreateTableDeParser createTableDeParser = new CreateTableDeParser(this.buffer);
        createTableDeParser.deParse(createTable);
    }

    @Override
    public void visit(Delete delete) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        DeleteDeParser deleteDeParser = new DeleteDeParser(expressionDeParser, this.buffer);
        deleteDeParser.deParse(delete);
    }

    @Override
    public void visit(Drop drop) {
    }

    @Override
    public void visit(Insert insert) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        InsertDeParser insertDeParser = new InsertDeParser(expressionDeParser, selectDeParser, this.buffer);
        insertDeParser.deParse(insert);
    }

    @Override
    public void visit(Replace replace) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        ReplaceDeParser replaceDeParser = new ReplaceDeParser(expressionDeParser, selectDeParser, this.buffer);
        replaceDeParser.deParse(replace);
    }

    @Override
    public void visit(Select select) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator iter = select.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = (WithItem)iter.next();
                this.buffer.append(withItem);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        select.getSelectBody().accept(selectDeParser);
    }

    @Override
    public void visit(Truncate truncate) {
    }

    @Override
    public void visit(Update update) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        UpdateDeParser updateDeParser = new UpdateDeParser(expressionDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        updateDeParser.deParse(update);
    }

    @Override
    public void visit(CreateIndex createIndex) {
        this.buffer.append(createIndex.toString());
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void visit(Alter alter) {
    }
}

