/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.statement.select;

import com.bokesoft.yes.mid.mysqls.processselect.InTableGroups;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.base.IElementVisitor;
import net.boke.jsqlparser.base.ISqlElement;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.OracleHierarchicalExpression;
import net.boke.jsqlparser.expression.OracleHint;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.AllColumns;
import net.boke.jsqlparser.statement.select.AllTableColumns;
import net.boke.jsqlparser.statement.select.Distinct;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.Limit;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SelectVisitor;
import net.boke.jsqlparser.statement.select.Top;

public class PlainSelect
extends AbstractSqlElement
implements SelectBody {
    private Distinct distinct = null;
    private List selectItems;
    private List<SelectExpressionItem> assistItems;
    private boolean calcAssistItem;
    private boolean noSplit;
    private Table into;
    private FromItem fromItem;
    private List joins;
    private Expression where;
    private List groupByColumnReferences;
    private List orderByElements;
    private Expression having;
    private Limit limit;
    private Top top;
    private String forXmlPath;
    private boolean forUpdate = false;
    private boolean oracleSiblings = false;
    private OracleHierarchicalExpression oracleHierarchical = null;
    private OracleHint oracleHint = null;

    public boolean hasAssistCol() {
        if (this.calcAssistItem) {
            return this.assistItems != null;
        }
        if (this.selectItems != null) {
            for (Object value : this.selectItems) {
                if (value instanceof SelectExpressionItem) {
                    SelectExpressionItem selectItem = (SelectExpressionItem)value;
                    if (!selectItem.isAssistCol()) continue;
                    if (this.assistItems == null) {
                        this.assistItems = new ArrayList<SelectExpressionItem>();
                    }
                    this.assistItems.add(selectItem);
                    continue;
                }
                if (value instanceof AllTableColumns || value instanceof AllColumns) continue;
                throw new RuntimeException();
            }
        }
        this.calcAssistItem = true;
        return this.assistItems != null;
    }

    public List<SelectExpressionItem> getAssistCols() {
        return this.assistItems;
    }

    public boolean isNoSplit() {
        return this.noSplit;
    }

    public void setNoSplit(boolean noSplit) {
        this.noSplit = noSplit;
    }

    public boolean hasInAllTable(InTableGroups inTableGroups) {
        if (inTableGroups == null || inTableGroups.size() == 0) {
            return false;
        }
        if (this.joins == null || this.joins.size() == 0) {
            return false;
        }
        for (Object join : this.joins) {
            FromItem fromItem = ((Join)join).getRightItem();
            if (!(fromItem instanceof Table) || !inTableGroups.containsObject(fromItem)) continue;
            return true;
        }
        return false;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public Table getInto() {
        return this.into;
    }

    public List getSelectItems() {
        return this.selectItems;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setFromItem(FromItem item) {
        this.fromItem = item;
    }

    public void setInto(Table table) {
        this.into = table;
    }

    public void setSelectItems(List list) {
        this.selectItems = list;
    }

    public void setWhere(Expression where) {
        this.where = where;
    }

    public List getJoins() {
        return this.joins;
    }

    public void setJoins(List list) {
        this.joins = list;
    }

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public List getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List orderByElements) {
        this.orderByElements = orderByElements;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Top getTop() {
        return this.top;
    }

    public void setTop(Top top) {
        this.top = top;
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    public void setDistinct(Distinct distinct) {
        this.distinct = distinct;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public List getGroupByColumnReferences() {
        return this.groupByColumnReferences;
    }

    public void setGroupByColumnReferences(List list) {
        this.groupByColumnReferences = list;
    }

    public String getForXmlPath() {
        return this.forXmlPath;
    }

    public void setForXmlPath(String forXmlPath) {
        this.forXmlPath = forXmlPath;
    }

    public void setForUpdate(boolean b) {
        this.forUpdate = true;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public boolean isOracleSiblings() {
        return this.oracleSiblings;
    }

    public void setOracleSiblings(boolean oracleSiblings) {
        this.oracleSiblings = oracleSiblings;
    }

    public OracleHierarchicalExpression getOracleHierarchical() {
        return this.oracleHierarchical;
    }

    public void setOracleHierarchical(OracleHierarchicalExpression oracleHierarchical) {
        this.oracleHierarchical = oracleHierarchical;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder(1024);
        sql.append("SELECT ");
        sql.append(this.distinct != null ? this.distinct + " " : "");
        sql.append(this.top != null ? this.top + " " : "");
        sql.append(PlainSelect.getStringList(this.selectItems));
        if (this.fromItem != null) {
            sql.append(" FROM ").append(this.fromItem);
        }
        if (this.joins != null) {
            for (Join join : this.joins) {
                if (join.isSimple()) {
                    sql.append(", ").append(join);
                    continue;
                }
                sql.append(" ").append(join);
            }
        }
        sql.append(this.where != null ? " WHERE " + this.where : "");
        if (this.oracleHierarchical != null) {
            sql.append(this.oracleHierarchical.toString());
        }
        sql.append(PlainSelect.getFormatedList(this.groupByColumnReferences, "GROUP BY"));
        sql.append(this.having != null ? " HAVING " + this.having : "");
        sql.append(PlainSelect.orderByToString(this.oracleSiblings, this.orderByElements));
        sql.append(this.limit != null ? "" + this.limit : "");
        if (this.forUpdate) {
            sql.append(" FOR UPDATE");
        }
        if (this.forXmlPath != null) {
            sql.append(" FOR XML PATH (").append(this.forXmlPath).append(")");
        }
        return sql.toString();
    }

    public String toStringWithoutLimit() {
        StringBuilder sql = new StringBuilder(128);
        sql.append("SELECT ");
        sql.append(this.distinct != null ? this.distinct + " " : "");
        sql.append(this.top != null ? this.top + " " : "");
        sql.append(PlainSelect.getStringList(this.selectItems));
        sql.append(" FROM " + this.fromItem);
        if (this.joins != null) {
            for (Join join : this.joins) {
                if (join.isSimple()) {
                    sql.append(", " + join);
                    continue;
                }
                sql.append(" " + join);
            }
        }
        sql.append(this.where != null ? " WHERE " + this.where : "");
        if (this.oracleHierarchical != null) {
            sql.append(this.oracleHierarchical.toString());
        }
        sql.append(PlainSelect.getFormatedList(this.groupByColumnReferences, "GROUP BY"));
        sql.append(this.having != null ? " HAVING " + this.having : "");
        sql.append(PlainSelect.orderByToString(this.oracleSiblings, this.orderByElements));
        if (this.forUpdate) {
            sql.append(" FOR UPDATE");
        }
        if (this.forXmlPath != null) {
            sql.append(" FOR XML PATH (").append(this.forXmlPath).append(")");
        }
        return sql.toString();
    }

    public static String orderByToString(boolean oracleSiblings, List orderByElements) {
        return PlainSelect.getFormatedList(orderByElements, oracleSiblings ? "ORDER SIBLINGS BY" : "ORDER BY");
    }

    public static String getFormatedList(List list, String expression) {
        return PlainSelect.getFormatedList(list, expression, true, false);
    }

    public static String getFormatedList(List list, String expression, boolean useComma, boolean useBrackets) {
        String sql = PlainSelect.getStringList(list, useComma, useBrackets);
        if (sql.length() > 0) {
            sql = expression.length() > 0 ? " " + expression + " " + sql : " " + sql;
        }
        return sql;
    }

    public static String getStringList(List list) {
        return PlainSelect.getStringList(list, true, false);
    }

    public static String getStringList(List list, boolean useComma, boolean useBrackets) {
        StringBuilder ans = new StringBuilder();
        String comma = ",";
        if (!useComma) {
            comma = "";
        }
        if (list != null) {
            if (useBrackets) {
                ans.append("(");
            }
            int i = 0;
            while (i < list.size()) {
                ans.append(list.get(i));
                ans.append(i < list.size() - 1 ? String.valueOf(comma) + " " : "");
                ++i;
            }
            if (useBrackets) {
                ans.append(")");
            }
        }
        return ans.toString();
    }

    @Override
    public void traversalChildren(IElementVisitor sqlElementVisitor) {
        if (this.selectItems != null) {
            for (Object item : this.selectItems) {
                ((ISqlElement)item).traversal(sqlElementVisitor);
            }
        }
        if (this.into != null) {
            this.into.traversal(sqlElementVisitor);
        }
        if (this.fromItem != null) {
            this.fromItem.traversal(sqlElementVisitor);
        }
        if (this.joins != null) {
            for (Object join : this.joins) {
                ((ISqlElement)join).traversal(sqlElementVisitor);
            }
        }
        if (this.groupByColumnReferences != null) {
            for (Object groupBy : this.groupByColumnReferences) {
                ((ISqlElement)groupBy).traversal(sqlElementVisitor);
            }
        }
        if (this.orderByElements != null) {
            for (Object orderBy : this.orderByElements) {
                ((ISqlElement)orderBy).traversal(sqlElementVisitor);
            }
        }
        if (this.where != null) {
            this.where.traversal(sqlElementVisitor);
        }
        if (this.having != null) {
            this.having.traversal(sqlElementVisitor);
        }
        if (this.limit != null) {
            this.limit.traversal(sqlElementVisitor);
        }
    }
}

