/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.statement.create.index;

import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.StatementVisitor;

public class CreateIndex
implements Statement {
    private boolean unique;
    private String name;
    private Table table;
    private List<String> columns = new ArrayList<String>();

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.intern();
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void addColumn(String column) {
        this.columns.add(column);
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512).append("CREATE ");
        if (this.isUnique()) {
            sb.append("UNIQUE ");
        }
        sb.append("INDEX ").append(this.getName()).append(" ON ").append(this.getTable()).append(" (").append(this.columns.get(0));
        int i = 1;
        int size = this.columns.size();
        while (i < size) {
            sb.append(", ").append(this.columns.get(i));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }
}

