/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.query.util;

import java.sql.SQLException;
import java.util.List;
import net.boke.jsqlparser.base.ISourceBindable;
import net.boke.jsqlparser.base.ISqlElement;
import net.boke.jsqlparser.query.source.AbstractQuerySource;
import net.boke.jsqlparser.query.source.QuerySourceFactory;
import net.boke.jsqlparser.query.source.RootSource;
import net.boke.jsqlparser.query.source.SubSelectSource;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SubSelect;

public class SourceBindUtil {
    public static AbstractQuerySource<?> rebindAllSource(ISourceBindable elem) throws SQLException {
        if (elem instanceof Select) {
            return SourceBindUtil.rebindRootSource((Select)elem);
        }
        return SourceBindUtil.rebindNormalSource((ISqlElement)elem);
    }

    public static RootSource rebindRootSource(Select select) throws SQLException {
        AbstractQuerySource<?> rootSource = select.getQuerySource();
        if (rootSource != null) {
            rootSource.clearAll();
            select.traversal(element -> {
                element.bindQuerySource(null);
                return true;
            });
        }
        RootSource root = new RootSource(select);
        root.bindPartsSource();
        return root;
    }

    public static AbstractQuerySource<?> rebindNormalSource(ISqlElement elem) throws SQLException {
        AbstractQuerySource<?> orgSource = elem.getQuerySource();
        if (orgSource != null) {
            orgSource.clearAll();
            elem.traversal(element -> {
                element.bindQuerySource(null);
                return true;
            });
        }
        AbstractQuerySource<?> source = QuerySourceFactory.create(elem);
        source.bindPartsSource();
        return source;
    }

    public static void bindSource(List expressions, AbstractQuerySource<?> source) throws SQLException {
        for (Object item : expressions) {
            SourceBindUtil.bindSource((ISqlElement)item, source);
        }
    }

    public static void bindSource(ISqlElement expression, AbstractQuerySource<?> source) throws SQLException {
        SourceBindUtil.bindSubSource4Bindable(expression, source);
        expression.traversal(element -> {
            block3: {
                if (!(element instanceof SubSelect)) break block3;
                SubSelectSource subSource = new SubSelectSource((SubSelect)element);
                subSource.bindPartsSource();
                return false;
            }
            try {
                SourceBindUtil.bindSubSource4Bindable(element, source);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return true;
        });
    }

    private static void bindSubSource4Bindable(ISourceBindable bindable, AbstractQuerySource<?> source) throws SQLException {
        if (bindable instanceof Column) {
            SourceBindUtil.bindSubSource4Column((Column)bindable, source);
        } else {
            bindable.bindQuerySource(source);
        }
    }

    private static void bindSubSource4Column(Column column, AbstractQuerySource<?> source) throws SQLException {
        if (column.getQuerySource() == null) {
            String tableName = column.getTable() == null ? null : column.getTable().getAliasName();
            AbstractQuerySource<?> subSource = source.getSourceByTableAlias(tableName);
            if (subSource == null) {
                subSource = source.getSourceByColumn(column);
            }
            if (subSource != null) {
                column.bindQuerySource(subSource);
                if (column.getTable() != null) {
                    column.getTable().bindQuerySource(subSource);
                }
            } else if (source.isResultColumn(column.getColumnName())) {
                column.bindQuerySource(source);
            }
        }
    }
}

