/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.expression;

import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;

public class StringValue
extends AbstractSqlElement
implements Expression {
    private String value = null;

    public StringValue(String escapedValue) {
        this.value = escapedValue.startsWith("'") && escapedValue.endsWith("'") ? escapedValue.substring(1, escapedValue.length() - 1).intern() : escapedValue.intern();
    }

    public String getValue() {
        return this.value;
    }

    public String getNotExcapedValue() {
        StringBuffer buffer = new StringBuffer(this.value);
        int index = 0;
        int deletesNum = 0;
        while ((index = this.value.indexOf("''", index)) != -1) {
            buffer.deleteCharAt(index - deletesNum);
            index += 2;
            ++deletesNum;
        }
        return buffer.toString();
    }

    public void setValue(String string) {
        this.value = string.intern();
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30);
        sb.append("'");
        sb.append(this.value);
        sb.append("'");
        return sb.toString();
    }
}

