/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.expression;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;

public class OracleHint
extends AbstractSqlElement
implements Expression {
    private static final Pattern SINGLE_LINE = Pattern.compile("--\\+ *([^ ].*[^ ])");
    private static final Pattern MULTI_LINE = Pattern.compile("\\/\\*\\+ *([^ ].*[^ ]) *\\*+\\/", 40);
    private static final Pattern INDEX_VALUE_PATTERN = Pattern.compile("INDEX\\s*\\(\\s*(\\S+)\\s*(\\S+)\\s*\\)", 2);
    private String value;
    private boolean singleLine = false;
    private final Map<String, Set<String>> tableIndexNames = new LinkedHashMap<String, Set<String>>();

    public static boolean isHintMatch(String comment) {
        return SINGLE_LINE.matcher(comment).find() || MULTI_LINE.matcher(comment).find();
    }

    public final void setComment(String comment) {
        Matcher m = SINGLE_LINE.matcher(comment);
        if (m.find()) {
            this.value = m.group(1);
            this.singleLine = true;
        } else {
            m = MULTI_LINE.matcher(comment);
            if (m.find()) {
                this.value = m.group(1);
                this.singleLine = false;
            }
        }
        if (this.value != null) {
            m = INDEX_VALUE_PATTERN.matcher(this.value);
            while (m.find()) {
                String group = m.group(0);
                this.value = this.value.replace(group, "");
                String aliasName = m.group(1);
                String indexName = m.group(2);
                Set names = this.tableIndexNames.computeIfAbsent(aliasName, key -> new LinkedHashSet());
                names.add(indexName);
            }
            this.value = this.value.trim();
        }
    }

    public void addIndexName(String aliasName, List<String> indexNames) {
        Set names = this.tableIndexNames.computeIfAbsent(aliasName, key -> new LinkedHashSet());
        names.addAll(indexNames);
    }

    public String getValue() {
        return this.value;
    }

    public boolean isSingleLine() {
        return this.singleLine;
    }

    public void setSingleLine(boolean singleLine) {
        this.singleLine = singleLine;
    }

    public Map<String, Set<String>> getTableIndexNames() {
        return this.tableIndexNames;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.tableIndexNames.size() > 0) {
            for (Map.Entry<String, Set<String>> entry : this.tableIndexNames.entrySet()) {
                String aliasName = entry.getKey();
                Set<String> indexNames = entry.getValue();
                for (String indexName : indexNames) {
                    buffer.append(" INDEX(").append(aliasName).append(" ").append(indexName.toUpperCase()).append(")");
                }
            }
        }
        if (this.singleLine) {
            return "--+" + buffer + " " + this.value + "\n";
        }
        return "/*+" + buffer + " " + this.value + "*/";
    }

    public OracleHint withSingleLine(boolean singleLine) {
        this.setSingleLine(singleLine);
        return this;
    }
}

