/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.expression;

import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.base.IElementVisitor;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;

public class OracleHierarchicalExpression
extends AbstractSqlElement
implements Expression {
    private Expression startExpression;
    private Expression connectExpression;
    private boolean noCycle = false;
    private boolean prior = false;
    boolean connectFirst = false;

    public Expression getStartExpression() {
        return this.startExpression;
    }

    public void setStartExpression(Expression startExpression) {
        this.startExpression = startExpression;
    }

    public Expression getConnectExpression() {
        return this.connectExpression;
    }

    public void setConnectExpression(Expression connectExpression) {
        this.connectExpression = connectExpression;
    }

    public boolean isNoCycle() {
        return this.noCycle;
    }

    public void setNoCycle(boolean noCycle) {
        this.noCycle = noCycle;
    }

    public boolean isPrior() {
        return this.prior;
    }

    public void setPrior(boolean prior) {
        this.prior = prior;
    }

    public boolean isConnectFirst() {
        return this.connectFirst;
    }

    public void setConnectFirst(boolean connectFirst) {
        this.connectFirst = connectFirst;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isConnectFirst()) {
            b.append(" CONNECT BY ");
            if (this.isNoCycle()) {
                b.append("NOCYCLE ");
            }
            if (this.isPrior()) {
                b.append("PRIOR ");
            }
            b.append(this.connectExpression.toString());
            if (this.startExpression != null) {
                b.append(" START WITH ").append(this.startExpression.toString());
            }
        } else {
            if (this.startExpression != null) {
                b.append(" START WITH ").append(this.startExpression.toString());
            }
            b.append(" CONNECT BY ");
            if (this.isNoCycle()) {
                b.append("NOCYCLE ");
            }
            if (this.isPrior()) {
                b.append("PRIOR ");
            }
            b.append(this.connectExpression.toString());
        }
        return b.toString();
    }

    public OracleHierarchicalExpression withStartExpression(Expression startExpression) {
        this.setStartExpression(startExpression);
        return this;
    }

    public OracleHierarchicalExpression withConnectExpression(Expression connectExpression) {
        this.setConnectExpression(connectExpression);
        return this;
    }

    public OracleHierarchicalExpression withNoCycle(boolean noCycle) {
        this.setNoCycle(noCycle);
        return this;
    }

    public OracleHierarchicalExpression withConnectFirst(boolean connectFirst) {
        this.setConnectFirst(connectFirst);
        return this;
    }

    public <E extends Expression> E getStartExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getStartExpression()));
    }

    public <E extends Expression> E getConnectExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getConnectExpression()));
    }

    @Override
    public void traversalChildren(IElementVisitor sqlElementVisitor) {
        if (this.startExpression != null) {
            this.startExpression.traversal(sqlElementVisitor);
        }
        if (this.connectExpression != null) {
            this.connectExpression.traversal(sqlElementVisitor);
        }
    }
}

