/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.sql;

import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.dbmanager.interceptor.stage.visitor.BaseExpressionVisitor;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.i18n.StringTable;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.sql.MDBNotSupportException;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.Limit;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SelectItem;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.select.Union;
import org.jfree.util.StringUtils;

public class SelectSqlInfoCheckLimit
extends SelectSqlInfo {
    public SelectSqlInfoCheckLimit(String sql, Select select) {
        super(sql, select);
    }

    public void checkLimit() {
        SelectBody selectBody = this.select.getSelectBody();
        this.checkLimitOnlySupportOuterLimit(selectBody);
        if (selectBody instanceof PlainSelect && ((PlainSelect)selectBody).getLimit() != null || selectBody instanceof Union && ((Union)selectBody).getLimit() != null) {
            this.checkLimitNotSupportGroupDistinctUnion(selectBody);
            this.checkLimitSubsequentJoinTableOnlyOneRecord(selectBody);
        }
    }

    private void checkLimitOnlySupportOuterLimit(SelectBody selectBody) {
        Limit outerLimit = selectBody instanceof PlainSelect ? ((PlainSelect)selectBody).getLimit() : (selectBody instanceof Union ? ((Union)selectBody).getLimit() : null);
        selectBody.traversal(elem -> {
            if (elem instanceof Limit && elem != outerLimit) {
                throw new MDBNotSupportException(27, this.sql, StringTable.getString(null, "Err_027_LimitOnlySupportOuterLimit"));
            }
            return true;
        });
    }

    private void checkLimitNotSupportGroupDistinctUnion(SelectBody selectBody) {
        selectBody.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                PlainSelect firstSubPlainSelect;
                SubSelect firstFromItem;
                if (plainSelect.getFromItem() instanceof SubSelect && plainSelect.getJoins() != null && (firstFromItem = (SubSelect)plainSelect.getFromItem()).getSelectBody() instanceof PlainSelect && (firstSubPlainSelect = (PlainSelect)firstFromItem.getSelectBody()).getDistinct() != null) {
                    throw new MDBNotSupportException(21, SelectSqlInfoCheckLimit.this.sql, StringTable.getString(null, "Err_021_LimitNotSupportDistinct"));
                }
                super.visit(plainSelect);
            }

            @Override
            public void visit(Union union) {
                throw new MDBNotSupportException(22, SelectSqlInfoCheckLimit.this.sql, StringTable.getString(null, "Err_022_LimitNotSupportUnion"));
            }

            @Override
            public void visit(InExpression inExpression) {
            }

            @Override
            public void visit(SelectExpressionItem selectExpressionItem) {
            }
        });
    }

    private void checkLimitSubsequentJoinTableOnlyOneRecord(SelectBody selectBody) {
        final RefObject firstMainTable = new RefObject(null);
        final RefObject firstDataObject = new RefObject(null);
        final ArrayList precedingMainTables = new ArrayList();
        final Stack whereExpStack = new Stack();
        final Stack joinStack = new Stack();
        final Stack onExpStack = new Stack();
        final ArrayList precedingFromItems = new ArrayList();
        selectBody.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                if (plainSelect.getGroupByColumnReferences() != null && firstMainTable.getValue() == null) {
                    throw new MDBNotSupportException(20, SelectSqlInfoCheckLimit.this.sql, StringTable.getString(null, "Err_020_LimitNotSupportGroup"));
                }
                whereExpStack.push(plainSelect.getWhere());
                this.checkFromItem(plainSelect.getFromItem());
                if (plainSelect.getJoins() != null) {
                    for (Object tmp : plainSelect.getJoins()) {
                        Join join = (Join)tmp;
                        joinStack.push(join);
                        onExpStack.push(join.getOnExpression());
                        this.checkFromItem(join.getRightItem());
                        onExpStack.pop();
                        joinStack.pop();
                    }
                }
                whereExpStack.pop();
            }

            private void checkFromItem(FromItem fromItem) {
                if (fromItem instanceof Table) {
                    if (firstMainTable.getValue() == null) {
                        firstMainTable.setValue((Object)((Table)fromItem));
                        precedingMainTables.add((Table)fromItem);
                        precedingFromItems.add(fromItem);
                    } else if (!SelectSqlInfoCheckLimit.this.hasSameDataObjectEqualsTo(whereExpStack, onExpStack, (Table)firstMainTable.getValue(), precedingMainTables, (RefObject<MetaDataObject>)firstDataObject, precedingFromItems, (Table)fromItem)) {
                        SelectSqlInfoCheckLimit.this.checkTableOneRecord((Table)fromItem, null, precedingFromItems, joinStack, whereExpStack, onExpStack);
                        precedingFromItems.add(fromItem);
                    }
                } else if (fromItem instanceof SubSelect) {
                    if (!$assertionsDisabled && !(((SubSelect)fromItem).getSelectBody() instanceof PlainSelect)) {
                        throw new AssertionError();
                    }
                    PlainSelect subPlainSelect = (PlainSelect)((SubSelect)fromItem).getSelectBody();
                    if (subPlainSelect.getGroupByColumnReferences() != null) {
                        Object firstGroupBy;
                        if (firstMainTable.getValue() == null) {
                            throw new MDBNotSupportException(20, SelectSqlInfoCheckLimit.this.sql, StringTable.getString(null, "Err_020_LimitNotSupportGroup"));
                        }
                        SelectExpressionItem groupByField = null;
                        if (subPlainSelect.getGroupByColumnReferences().size() == 1 && (firstGroupBy = subPlainSelect.getGroupByColumnReferences().get(0)) instanceof Column && ((Column)firstGroupBy).getExtendSelectItemInGroupByOrderByHaving().getExpression() instanceof Column) {
                            groupByField = ((Column)firstGroupBy).getExtendSelectItemInGroupByOrderByHaving();
                        }
                        if (groupByField == null) {
                            throw new MDBNotSupportException(25, SelectSqlInfoCheckLimit.this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_025_LimitSubsequentTableGroupByOneField"), (Object[])new Object[]{subPlainSelect}));
                        }
                        SelectSqlInfoCheckLimit.this.checkTableOneRecord(fromItem, groupByField, precedingFromItems, joinStack, whereExpStack, onExpStack);
                        precedingFromItems.add(fromItem);
                    } else {
                        SelectItem primarySelectItem = SelectSqlInfoCheckLimit.this.getPrimarySelectItem(subPlainSelect);
                        if (primarySelectItem != null) {
                            SelectSqlInfoCheckLimit.this.checkTableOneRecord(fromItem, primarySelectItem, precedingFromItems, joinStack, whereExpStack, onExpStack);
                        } else {
                            fromItem.accept(this);
                        }
                    }
                }
            }
        });
    }

    private boolean hasSameDataObjectEqualsTo(Stack<Expression> whereExpStack, Stack<Expression> onExpStack, Table firstTable, List<Table> precedingMainTables, RefObject<MetaDataObject> firstDataObject, List<FromItem> precedingFromItems, Table fromItem) {
        assert (firstTable != null);
        EqualsTo sameDataObjectEqualsTo = null;
        block0: for (Table mainTable : precedingMainTables) {
            EqualsTo tmp;
            if (sameDataObjectEqualsTo == null) {
                for (Expression exp : whereExpStack) {
                    tmp = SelectSqlInfoCheckLimit.findSameDataObjectEqualsToInExpression(exp, mainTable, fromItem);
                    if (tmp == null) continue;
                    precedingFromItems.add(fromItem);
                    sameDataObjectEqualsTo = tmp;
                    break;
                }
            }
            if (sameDataObjectEqualsTo != null) continue;
            for (Expression exp : onExpStack) {
                tmp = SelectSqlInfoCheckLimit.findSameDataObjectEqualsToInExpression(exp, mainTable, fromItem);
                if (tmp == null) continue;
                precedingFromItems.add(fromItem);
                sameDataObjectEqualsTo = tmp;
                continue block0;
            }
        }
        if (sameDataObjectEqualsTo != null) {
            precedingMainTables.add(fromItem);
            if (firstDataObject.getValue() == null) {
                MetaDataObject metaDataObject = DataObjects.getDataObjectBy2TableNames(firstTable.getName(), fromItem.getName());
                if (metaDataObject == null) {
                    throw new RuntimeException("\u5206\u5e93\u7cfb\u7edf\u9519\uff0c\u8868" + firstTable.getName() + "\u548c\u8868" + fromItem.getName() + "\u6ca1\u6709\u5173\u8054\u3002");
                }
                firstDataObject.setValue((Object)metaDataObject);
            } else if (DataObjects.getMetaTableByTableNameIgnoreCase((MetaDataObject)firstDataObject.getValue(), fromItem.getName()) == null) {
                throw new RuntimeException("\u5206\u5e93\u7cfb\u7edf\u9519\uff0c\u8868" + fromItem.getName() + "\u5728\u6570\u636e\u5bf9\u8c61" + ((MetaDataObject)firstDataObject.getValue()).getKey() + "\u4e2d\u4e0d\u5b58\u5728\u3002");
            }
        }
        return sameDataObjectEqualsTo != null;
    }

    private boolean isLinkedHeadOID(Stack<Expression> onExpStack) {
        RefObject ref = new RefObject((Object)false);
        for (Expression exp : onExpStack) {
            exp.traversal(elem -> {
                Table table;
                Column column;
                FromItem fromItem;
                if (elem instanceof Column && (fromItem = (column = (Column)elem).getExtendFromItem()) instanceof Table && DataObjects.isHeadTable((table = (Table)fromItem).getName()) && ("OID".equalsIgnoreCase(column.getColumnName()) || "SOID".equalsIgnoreCase(column.getColumnName()))) {
                    ref.setValue((Object)true);
                    return false;
                }
                return true;
            });
        }
        return (Boolean)ref.getValue();
    }

    private void checkTableOneRecord(final FromItem fromItem, SelectItem primarySelectItem, List<FromItem> precedingFromItems, Stack<Join> joinStack, Stack<Expression> whereExpStack, Stack<Expression> onExpStack) {
        boolean isLeftJoin = false;
        for (Join join : joinStack) {
            if (!join.isLeft()) continue;
            isLeftJoin = true;
            break;
        }
        if (!isLeftJoin) {
            throw new MDBNotSupportException(26, this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_026_LimitSubsequentTableOnlySupportLeftJoin"), (Object[])new Object[]{fromItem}));
        }
        EqualsTo oneRecordEqualsTo = null;
        if (primarySelectItem == null) {
            boolean isHeadTable;
            assert (fromItem instanceof Table);
            Table table = (Table)fromItem;
            oneRecordEqualsTo = this.findOneRecordEqualsToInExpression(table, "OID", null, precedingFromItems, onExpStack);
            if (oneRecordEqualsTo == null && (isHeadTable = DataObjects.isHeadTable(table.getName()))) {
                oneRecordEqualsTo = this.findOneRecordEqualsToInExpression(table, "SOID", null, precedingFromItems, onExpStack);
            }
            if (oneRecordEqualsTo == null && this.isLinkedHeadOID(onExpStack)) {
                oneRecordEqualsTo = this.findOneRecordEqualsToInExpression(table, "SOID", null, precedingFromItems, onExpStack);
            }
            if (oneRecordEqualsTo == null && StringUtils.endsWithIgnoreCase((String)table.getName(), (String)"_t")) {
                oneRecordEqualsTo = this.findOneRecordEqualsToInExpression(table, "SrcLangOID", null, precedingFromItems, onExpStack);
            }
        } else {
            oneRecordEqualsTo = this.findOneRecordEqualsToInExpression(null, null, primarySelectItem, precedingFromItems, onExpStack);
        }
        if (oneRecordEqualsTo == null) {
            throw new MDBNotSupportException(23, this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_023_LimitSubsequentTableNotOneRecord"), (Object[])new Object[]{fromItem}));
        }
        for (Expression exp : whereExpStack) {
            if (exp == null) continue;
            exp.accept(new BaseExpressionVisitor(){

                @Override
                public void visit(Column tableColumn) {
                    if (tableColumn.getExtendFromItem() == fromItem) {
                        throw new MDBNotSupportException(24, SelectSqlInfoCheckLimit.this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_024_LimitSubsequentTableHasWhereExpression"), (Object[])new Object[]{fromItem, tableColumn}));
                    }
                }
            });
        }
    }

    private EqualsTo findOneRecordEqualsToInExpression(Table table, String columnName, SelectItem primarySelectItem, List<FromItem> precedingFromItems, Stack<Expression> onExpStack) {
        EqualsTo oneRecordEqualsTo = null;
        for (Expression exp : onExpStack) {
            EqualsTo tmp;
            if (exp == null || (tmp = this.findOneRecordEqualsToInExpression(table, columnName, primarySelectItem, exp, precedingFromItems)) == null) continue;
            oneRecordEqualsTo = tmp;
            break;
        }
        return oneRecordEqualsTo;
    }

    private EqualsTo findOneRecordEqualsToInExpression(Table table, String columnName, SelectItem primarySelectItem, Expression expression, List<FromItem> precedingFromItems) {
        block9: {
            if (expression instanceof Parenthesis) {
                return this.findOneRecordEqualsToInExpression(table, columnName, primarySelectItem, ((Parenthesis)expression).getExpression(), precedingFromItems);
            }
            if (expression instanceof AndExpression) {
                EqualsTo equalsTo = this.findOneRecordEqualsToInExpression(table, columnName, primarySelectItem, ((AndExpression)expression).getLeftExpression(), precedingFromItems);
                if (equalsTo != null) {
                    return equalsTo;
                }
                return this.findOneRecordEqualsToInExpression(table, columnName, primarySelectItem, ((AndExpression)expression).getRightExpression(), precedingFromItems);
            }
            if (!(expression instanceof EqualsTo) || !(((EqualsTo)expression).getLeftExpression() instanceof Column) || !(((EqualsTo)expression).getRightExpression() instanceof Column)) break block9;
            Column leftColumn = (Column)((EqualsTo)expression).getLeftExpression();
            Column rightColumn = (Column)((EqualsTo)expression).getRightExpression();
            if (leftColumn != null && rightColumn != null) {
                if (leftColumn.getExtendFromItem() == table && leftColumn.getColumnName().equalsIgnoreCase(columnName) || primarySelectItem != null && primarySelectItem == leftColumn.getExtendSelectItem()) {
                    Column rightUnderlyingColumn = rightColumn.getUnderlyingTableColumn();
                    FromItem rightUnderlyingFromItem = rightUnderlyingColumn == null ? null : rightUnderlyingColumn.getExtendFromItem();
                    for (FromItem beforeFromItem : precedingFromItems) {
                        if (rightUnderlyingFromItem != beforeFromItem) continue;
                        return (EqualsTo)expression;
                    }
                } else if (rightColumn.getExtendFromItem() == table && rightColumn.getColumnName().equalsIgnoreCase(columnName) || primarySelectItem != null && primarySelectItem == rightColumn.getExtendSelectItem()) {
                    Column leftUnderlyingColumn = leftColumn.getUnderlyingTableColumn();
                    FromItem leftUnderlyingFromItem = leftUnderlyingColumn == null ? null : leftUnderlyingColumn.getExtendFromItem();
                    for (FromItem beforeFromItem : precedingFromItems) {
                        if (leftUnderlyingFromItem != beforeFromItem) continue;
                        return (EqualsTo)expression;
                    }
                }
            }
        }
        return null;
    }

    private SelectItem getPrimarySelectItem(PlainSelect plainSelect) {
        Table table;
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table && (table = (Table)fromItem).getName().equalsIgnoreCase("EAM_YearChange") && this.findFieldEqualsToConstant(table, "CompanyCodeID", plainSelect.getWhere()) != null && this.findFieldEqualsToConstant(table, "FiscalYear", plainSelect.getWhere()) != null) {
            for (Object selectItem : plainSelect.getSelectItems()) {
                if (!(selectItem instanceof SelectExpressionItem) || !(((SelectExpressionItem)selectItem).getExpression() instanceof Column) || !((Column)((SelectExpressionItem)selectItem).getExpression()).getColumnName().equalsIgnoreCase("AssetCardSOID")) continue;
                return (SelectItem)selectItem;
            }
        }
        return null;
    }

    private EqualsTo findFieldEqualsToConstant(Table table, String fieldName, Expression expression) {
        Column leftColumn;
        if (expression instanceof Parenthesis) {
            return this.findFieldEqualsToConstant(table, fieldName, ((Parenthesis)expression).getExpression());
        }
        if (expression instanceof AndExpression) {
            EqualsTo equalsTo = this.findFieldEqualsToConstant(table, fieldName, ((AndExpression)expression).getLeftExpression());
            if (equalsTo != null) {
                return equalsTo;
            }
            return this.findFieldEqualsToConstant(table, fieldName, ((AndExpression)expression).getRightExpression());
        }
        if (expression instanceof EqualsTo && ((EqualsTo)expression).getLeftExpression() instanceof Column && ParsedSqlUtil.isConstant(((EqualsTo)expression).getRightExpression()) && (leftColumn = (Column)((EqualsTo)expression).getLeftExpression()).getExtendFromItem() == table && leftColumn.getColumnName().equalsIgnoreCase(fieldName)) {
            return (EqualsTo)expression;
        }
        return null;
    }

    public static EqualsTo findSameDataObjectEqualsToInExpression(Expression expression, FromItem fromItem0, FromItem fromItem1) {
        if (expression instanceof Parenthesis) {
            return SelectSqlInfoCheckLimit.findSameDataObjectEqualsToInExpression(((Parenthesis)expression).getExpression(), fromItem0, fromItem1);
        }
        if (expression instanceof AndExpression) {
            EqualsTo equalsTo = SelectSqlInfoCheckLimit.findSameDataObjectEqualsToInExpression(((AndExpression)expression).getLeftExpression(), fromItem0, fromItem1);
            if (equalsTo != null) {
                return equalsTo;
            }
            return SelectSqlInfoCheckLimit.findSameDataObjectEqualsToInExpression(((AndExpression)expression).getRightExpression(), fromItem0, fromItem1);
        }
        if (expression instanceof EqualsTo && ((EqualsTo)expression).getLeftExpression() instanceof Column && ((EqualsTo)expression).getRightExpression() instanceof Column) {
            Column leftColumn = ((Column)((EqualsTo)expression).getLeftExpression()).getUnderlyingTableColumn();
            Column rightColumn = ((Column)((EqualsTo)expression).getRightExpression()).getUnderlyingTableColumn();
            if (leftColumn != null && rightColumn != null && (leftColumn.getExtendFromItem() == fromItem0 && rightColumn.getExtendFromItem() == fromItem1 || leftColumn.getExtendFromItem() == fromItem1 && rightColumn.getExtendFromItem() == fromItem0) && (leftColumn.getColumnName().equalsIgnoreCase("OID") || leftColumn.getColumnName().equalsIgnoreCase("SOID") || leftColumn.getColumnName().equalsIgnoreCase("POID")) && (rightColumn.getColumnName().equalsIgnoreCase("OID") || rightColumn.getColumnName().equalsIgnoreCase("SOID") || rightColumn.getColumnName().equalsIgnoreCase("POID"))) {
                return (EqualsTo)expression;
            }
        }
        return null;
    }
}

