/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.sql;

import com.bokesoft.yes.common.struct.LinkedHashMapIgnoreCase;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.dbcache.structure.OrderBy;
import com.bokesoft.yes.mid.dbmanager.interceptor.stage.visitor.BaseExpressionVisitor;
import com.bokesoft.yes.mid.mysqls.dbstruct.DBStruct;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupType;
import com.bokesoft.yes.mid.mysqls.i18n.StringTable;
import com.bokesoft.yes.mid.mysqls.processselect.AssignColumnToFromItem;
import com.bokesoft.yes.mid.mysqls.processselect.IComplexSQL;
import com.bokesoft.yes.mid.mysqls.processselect.InTableGroups;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.processselect.SplitSelectIntoGroup;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuerys;
import com.bokesoft.yes.mid.mysqls.result.function.ExpressionLocation;
import com.bokesoft.yes.mid.mysqls.result.function.ISelectExpressionHolder;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.GroupFunctionConvertor;
import com.bokesoft.yes.mid.mysqls.result.util.TypeUtils;
import com.bokesoft.yes.mid.mysqls.resultset.SimpleDocumentDBUtil;
import com.bokesoft.yes.mid.mysqls.sql.ColumnValue;
import com.bokesoft.yes.mid.mysqls.sql.Field;
import com.bokesoft.yes.mid.mysqls.sql.MDBNotSupportException;
import com.bokesoft.yes.mid.mysqls.sql.SplitSubUnion;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yes.mid.mysqls.sql.SqlUtil;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.mchange.util.AssertException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.boke.jsqlparser.JSQLParserException;
import net.boke.jsqlparser.base.ISqlElement;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.InverseExpression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.Between;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExistsExpression;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.IsNullExpression;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.MultiInExpression;
import net.boke.jsqlparser.query.extend.ParseHelper;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.select.AllColumns;
import net.boke.jsqlparser.statement.select.AllTableColumns;
import net.boke.jsqlparser.statement.select.Distinct;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.Limit;
import net.boke.jsqlparser.statement.select.OrderByElement;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SelectItem;
import net.boke.jsqlparser.statement.select.SubJoin;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.select.Union;

public class SelectSqlInfo
extends SqlInfo
implements ISelectExpressionHolder {
    protected Select select;
    private List<Table> allTables;
    private List<String> allTableNames = null;
    protected List<String> mColumnNamesInResultSet;
    protected List<Field> fields;
    public static final String[] STRS_NoSupportFunctionsInExpression = new String[]{"max", "min", "count", "avg"};
    private boolean hasParsedFunctionGroupByOrderBy = false;
    private List<String> functions;
    private List<Expression> groupColumns;
    private List<String> groupColumnAlias;
    private SortCriteria[] orderColumns;
    private SortCriteria[] orderColumnAlias;
    Boolean hasStatisticsFunctionForNoGroup = null;
    private GroupFunctionConvertor groupFunctionConvertor = null;
    private Set<Integer> removedParameterIndexes = null;
    private boolean isLoadSubSelects = false;
    private IComplexSQL complexSQL = null;
    private String selectMainTable;
    private InTableGroups inTableGroups = new InTableGroups();
    private List<OrderBy> orderByObjects;
    private Boolean isDistinct;
    private Boolean isSameSingleGroup = null;
    private int addColumnCount = 0;
    private int columnCountForFunctions = 0;
    Boolean isNoGroup = null;
    Boolean isDataMayRepeat = null;

    public SelectSqlInfo(String sql, Select select) {
        super(sql);
        this.select = select;
    }

    @Override
    public Statement getStatement() {
        return this.select;
    }

    public Limit getLimit() {
        if (this.select.getSelectBody() instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)this.select.getSelectBody();
            Limit limit = plainSelect.getLimit();
            return limit;
        }
        return null;
    }

    public String getSqlWithoutLimit() {
        PlainSelect plainSelect = (PlainSelect)this.select.getSelectBody();
        String sqlWithoutLimit = plainSelect.toStringWithoutLimit();
        return sqlWithoutLimit;
    }

    @Override
    public String parseTableName() {
        List<Table> allTables = this.getAllTables();
        return allTables.isEmpty() ? null : allTables.get(0).getName();
    }

    public String getTableName(String tableNameOrAlias) {
        Table tmp = ParsedSqlUtil.getTableByTableNameOrAlias(this.getAllTables(), tableNameOrAlias);
        if (tmp != null) {
            return tmp.getName();
        }
        return tableNameOrAlias;
    }

    public List<Table> getAllTables() {
        if (this.allTables == null) {
            this.allTables = ParsedSqlUtil.getAllTable(this.select, this.inTableGroups);
        }
        return this.allTables;
    }

    public void reProcessAllTables() {
        this.allTables = null;
        this.allTableNames = null;
        this.inTableGroups = new InTableGroups();
        this.getAllTables();
    }

    public synchronized List<String> getAllTableNames() {
        if (this.allTableNames != null) {
            return this.allTableNames;
        }
        this.allTableNames = new ArrayList<String>();
        for (Table table : this.getAllTables()) {
            String tableName = table.getName();
            if (this.allTableNames.contains(tableName)) continue;
            this.allTableNames.add(tableName);
        }
        return this.allTableNames;
    }

    @Override
    public ColumnValue parseGroupOriginalValue(String columnKey) throws SQLException {
        PlainSelect plainSelect = ParsedSqlUtil.getPlainSelect(this.select.getSelectBody());
        Expression where = ParsedSqlUtil.fetchWhereByColumn(plainSelect, columnKey);
        return SelectSqlInfo.parsePrimaryKeyValueInWhere(where, columnKey, this.getJdbcParameters(), null);
    }

    @Override
    public ColumnValue parseGroupNewValue(String columneKey) throws SQLException {
        return null;
    }

    public static ColumnValue parsePrimaryKeyValueInWhere(Expression expression, String columnKey, List<JdbcParameter> jdbcParameters, ColumnValue result) throws SQLException {
        if (expression instanceof Parenthesis) {
            return SelectSqlInfo.parsePrimaryKeyValueInWhere(((Parenthesis)expression).getExpression(), columnKey, jdbcParameters, result);
        }
        if (expression instanceof AndExpression) {
            result = SelectSqlInfo.parsePrimaryKeyValueInWhere(((AndExpression)expression).getLeftExpression(), columnKey, jdbcParameters, result);
            result = SelectSqlInfo.parsePrimaryKeyValueInWhere(((AndExpression)expression).getRightExpression(), columnKey, jdbcParameters, result);
            return result;
        }
        if (expression instanceof EqualsTo) {
            EqualsTo binaryExpression = (EqualsTo)expression;
            if (!binaryExpression.isNot()) {
                String columnName;
                if (binaryExpression.getLeftExpression() instanceof Column) {
                    String columnName2 = ((Column)binaryExpression.getLeftExpression()).getColumnName();
                    if (columnKey.equalsIgnoreCase(columnName2)) {
                        Expression value = binaryExpression.getRightExpression();
                        if (value instanceof Column) {
                            return result;
                        }
                        ColumnValue columnValue = result = result == null ? new ColumnValue() : result;
                        if (value instanceof JdbcParameter) {
                            result.parameterIndex = jdbcParameters.indexOf((JdbcParameter)value) + 1;
                        } else {
                            result.valueInSQL = value.toString();
                        }
                        return result;
                    }
                } else if (binaryExpression.getRightExpression() instanceof Column && columnKey.equalsIgnoreCase(columnName = ((Column)binaryExpression.getRightExpression()).getColumnName())) {
                    Expression value = binaryExpression.getLeftExpression();
                    if (value instanceof Column) {
                        return result;
                    }
                    ColumnValue columnValue = result = result == null ? new ColumnValue() : result;
                    if (value instanceof JdbcParameter) {
                        result.parameterIndex = jdbcParameters.indexOf((JdbcParameter)value) + 1;
                    } else {
                        result.valueInSQL = value.toString();
                    }
                    return result;
                }
            }
        } else if (expression instanceof InExpression) {
            InExpression inexp = (InExpression)expression;
            if (!inexp.isNot()) {
                String columnName;
                String string = columnName = inexp.getLeftExpression() instanceof Column ? ((Column)inexp.getLeftExpression()).getColumnName() : inexp.getLeftExpression().toString();
                if (columnKey.equalsIgnoreCase(columnName)) {
                    if (inexp.getItemsList() instanceof SubSelect) {
                        return null;
                    }
                    List values = ((ExpressionList)inexp.getItemsList()).getExpressions();
                    result = result == null ? new ColumnValue() : result;
                    int i = 0;
                    while (i < values.size()) {
                        Object value = values.get(i);
                        if (value instanceof JdbcParameter) {
                            result.addInParameterIndex(jdbcParameters.indexOf((JdbcParameter)value) + 1);
                        } else {
                            result.addInValue(((LongValue)value).getValue());
                        }
                        ++i;
                    }
                    return result;
                }
            }
        } else if (expression instanceof MultiInExpression) {
            MultiInExpression minExp = (MultiInExpression)expression;
            List<Column> columnList = minExp.getColumnList();
            int size = columnList.size();
            int i = 0;
            while (i < size) {
                String columnName = columnList.get(i).getColumnName();
                if (columnKey.equalsIgnoreCase(columnName)) {
                    result = result == null ? new ColumnValue() : result;
                    List<List<Expression>> valueListList = minExp.getValuesList();
                    int listIndex = 0;
                    int listSize = valueListList.size();
                    while (listIndex < listSize) {
                        List<Expression> valueList = valueListList.get(listIndex);
                        Expression value = valueList.get(i);
                        if (value instanceof JdbcParameter) {
                            result.addInParameterIndex(jdbcParameters.indexOf((JdbcParameter)value) + 1);
                        } else {
                            result.addInValue(((LongValue)value).getValue());
                        }
                        ++listIndex;
                    }
                    return result;
                }
                ++i;
            }
        } else if (expression instanceof Between) {
            String columnName;
            Between between = (Between)expression;
            if (!between.isNot() && between.getLeftExpression() instanceof Column && columnKey.equalsIgnoreCase(columnName = ((Column)between.getLeftExpression()).getColumnName())) {
                ColumnValue start = new ColumnValue();
                Expression value = between.getBetweenExpressionStart();
                if (value instanceof JdbcParameter) {
                    start.parameterIndex = jdbcParameters.indexOf((JdbcParameter)value) + 1;
                } else {
                    start.valueInSQL = value.toString();
                }
                ColumnValue end = new ColumnValue();
                value = between.getBetweenExpressionEnd();
                if (value instanceof JdbcParameter) {
                    end.parameterIndex = jdbcParameters.indexOf((JdbcParameter)value) + 1;
                } else {
                    end.valueInSQL = value.toString();
                }
                result = result == null ? new ColumnValue() : result;
                result.setStart(start);
                result.setEnd(end);
                return result;
            }
        } else if (expression instanceof GreaterThanEquals) {
            String columnName;
            GreaterThanEquals greaterThanEquals = (GreaterThanEquals)expression;
            if (greaterThanEquals.getLeftExpression() instanceof Column && columnKey.equalsIgnoreCase(columnName = ((Column)greaterThanEquals.getLeftExpression()).getColumnName())) {
                ColumnValue start = new ColumnValue();
                Expression value = greaterThanEquals.getRightExpression();
                if (value instanceof JdbcParameter) {
                    start.parameterIndex = jdbcParameters.indexOf((JdbcParameter)value) + 1;
                } else {
                    start.valueInSQL = value.toString();
                }
                result = result == null ? new ColumnValue() : result;
                result.setStart(start);
                return result;
            }
        } else if (expression instanceof MinorThanEquals) {
            String columnName;
            MinorThanEquals minorThanEquals = (MinorThanEquals)expression;
            if (minorThanEquals.getLeftExpression() instanceof Column && columnKey.equalsIgnoreCase(columnName = ((Column)minorThanEquals.getLeftExpression()).getColumnName())) {
                ColumnValue end = new ColumnValue();
                result = result == null ? new ColumnValue() : result;
                Expression value = minorThanEquals.getRightExpression();
                if (value instanceof JdbcParameter) {
                    end.parameterIndex = jdbcParameters.indexOf((JdbcParameter)value) + 1;
                } else {
                    end.valueInSQL = value.toString();
                }
                result = result == null ? new ColumnValue() : result;
                result.setEnd(end);
                return result;
            }
        } else if (expression instanceof OrExpression && (columnKey.equalsIgnoreCase("OID") || columnKey.equalsIgnoreCase("SOID")) && ((OrExpression)expression).getLeftExpression() instanceof EqualsTo && ((OrExpression)expression).getRightExpression() instanceof EqualsTo) {
            EqualsTo leftExp = (EqualsTo)((OrExpression)expression).getLeftExpression();
            EqualsTo rightExp = (EqualsTo)((OrExpression)expression).getRightExpression();
            if (leftExp.getLeftExpression() instanceof Column && ((Column)leftExp.getLeftExpression()).getColumnName().equalsIgnoreCase("OID") && rightExp.getLeftExpression() instanceof Column && ((Column)rightExp.getLeftExpression()).getColumnName().equalsIgnoreCase("SOID") && leftExp.getRightExpression() instanceof LongValue && rightExp.getRightExpression() instanceof LongValue && ((LongValue)leftExp.getRightExpression()).getValue() == ((LongValue)rightExp.getRightExpression()).getValue()) {
                result = result == null ? new ColumnValue() : result;
                result.valueInSQL = ((LongValue)leftExp.getRightExpression()).getValue();
                return result;
            }
        }
        return result;
    }

    protected List<Field> getFields() {
        return this.getFields(null);
    }

    public int getColumnCount() {
        return this.getColumnNamesInResultSet().size();
    }

    public int getColumnIndex(String columnName) throws Throwable {
        List<String> columns = this.getColumnNamesInResultSet();
        int i = 0;
        int size = columns.size();
        while (i < size) {
            if (columnName.equalsIgnoreCase(columns.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Table getColumnTable(int index) {
        return this.getFields().get(index).getTable();
    }

    public String getColumnNameInResultSet(int index) {
        return this.getColumnNamesInResultSet().get(index);
    }

    public int getColumnDataType(int index) throws Throwable {
        return this.getFields().get(index).getDataType();
    }

    public String[] getFunctions() {
        if (!this.hasParsedFunctionGroupByOrderBy) {
            this.processFunctionGroupByOrderBy();
        }
        return this.functions == null ? null : this.functions.toArray(new String[this.functions.size()]);
    }

    public boolean hasStatisticsFunction() {
        if (this.isNoGroup()) {
            if (this.hasStatisticsFunctionForNoGroup == null) {
                final RefObject has = new RefObject((Object)false);
                PlainSelect plainSelect = ParsedSqlUtil.getPlainSelect(this.select.getSelectBody());
                plainSelect.accept(new BaseExpressionVisitor(){

                    @Override
                    public void visit(Function function) {
                        String name = function.getName();
                        if ("sum".equalsIgnoreCase(name) || "max".equalsIgnoreCase(name) || "min".equalsIgnoreCase(name) || "avg".equalsIgnoreCase(name) || "count".equalsIgnoreCase(name)) {
                            has.setValue((Object)true);
                        }
                        super.visit(function);
                    }
                });
                this.hasStatisticsFunctionForNoGroup = (Boolean)has.getValue();
            }
            return this.hasStatisticsFunctionForNoGroup;
        }
        return this.getFunctions() != null;
    }

    public List<String> getFunctionsForAssert() {
        if (!this.hasParsedFunctionGroupByOrderBy) {
            this.processFunctionGroupByOrderBy();
        }
        return this.functions;
    }

    public List<Expression> getGroupColumns() {
        if (!this.hasParsedFunctionGroupByOrderBy) {
            this.processFunctionGroupByOrderBy();
        }
        return this.groupColumns;
    }

    @Override
    public List<String> getGroupColumnAlias() {
        if (!this.hasParsedFunctionGroupByOrderBy) {
            this.processFunctionGroupByOrderBy();
        }
        return this.groupColumnAlias;
    }

    public SortCriteria[] getSortCriteria() {
        if (!this.hasParsedFunctionGroupByOrderBy) {
            this.processFunctionGroupByOrderBy();
        }
        return this.orderColumns;
    }

    public SortCriteria[] getSortCriteriaAlias() {
        if (!this.hasParsedFunctionGroupByOrderBy) {
            this.processFunctionGroupByOrderBy();
        }
        return this.orderColumnAlias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFunctionGroupByOrderBy() {
        if (!this.isNoGroup()) {
            AssignColumnToFromItem.assign(this.select);
        }
        if (!this.hasParsedFunctionGroupByOrderBy) {
            SelectSqlInfo selectSqlInfo = this;
            synchronized (selectSqlInfo) {
                if (!this.hasParsedFunctionGroupByOrderBy) {
                    SelectBody selectBody = this.select.getSelectBody();
                    ParseHelper.rebindRootSource(this.select);
                    if (selectBody instanceof PlainSelect && !this.isNoGroup()) {
                        PlainSelect plainSelect = (PlainSelect)selectBody;
                        List selectItems = plainSelect.getSelectItems();
                        List<?> groups = plainSelect.getGroupByColumnReferences();
                        List<?> orders = plainSelect.getOrderByElements();
                        while (selectItems.size() == 1 && selectItems.get(0) instanceof AllColumns) {
                            if (!(plainSelect.getFromItem() instanceof SubSelect) || !((selectBody = ((SubSelect)plainSelect.getFromItem()).getSelectBody()) instanceof PlainSelect)) break;
                            plainSelect = (PlainSelect)selectBody;
                            selectItems = plainSelect.getSelectItems();
                            if (groups == null) {
                                groups = plainSelect.getGroupByColumnReferences();
                            }
                            if (orders != null) continue;
                            orders = plainSelect.getOrderByElements();
                        }
                        boolean isGroupInSubPlain = false;
                        if (plainSelect.getFromItem() instanceof SubSelect && plainSelect == this.select.getSelectBody() && ((SubSelect)plainSelect.getFromItem()).getSelectBody() instanceof PlainSelect && plainSelect.getJoins() == null) {
                            PlainSelect subPlainSelect = ParsedSqlUtil.getPlainSelect(((SubSelect)plainSelect.getFromItem()).getSelectBody());
                            if (groups == null) {
                                groups = SelectSqlInfo.processSubPlainGroupByOrderBy(plainSelect, subPlainSelect, subPlainSelect.getGroupByColumnReferences());
                                boolean bl = isGroupInSubPlain = groups != null;
                            }
                            if (orders == null) {
                                orders = SelectSqlInfo.processSubPlainGroupByOrderBy(plainSelect, subPlainSelect, subPlainSelect.getOrderByElements());
                            }
                        }
                        this.processGroupBy(plainSelect, groups);
                        this.processOrderBy(plainSelect, orders);
                        this.columnCountForFunctions = this.processFunction(plainSelect, 0, isGroupInSubPlain);
                    }
                    this.hasParsedFunctionGroupByOrderBy = true;
                }
            }
        }
    }

    public void addRemovedParameterIndex(int index) {
        if (this.removedParameterIndexes == null) {
            this.removedParameterIndexes = new TreeSet<Integer>();
        }
        this.removedParameterIndexes.add(index);
    }

    public Set<Integer> getRemovedParameterIndexes() {
        if (this.groupFunctionConvertor == null || this.removedParameterIndexes == null) {
            return Collections.emptySet();
        }
        return this.removedParameterIndexes;
    }

    public void prepareGroupFunctionChanges() throws SQLException {
        SelectBody selectBody = this.select.getSelectBody();
        if (selectBody instanceof PlainSelect && !this.isNoGroup() && this.groupFunctionConvertor == null) {
            PlainSelect subPlainSelect;
            SelectBody subBody;
            Expression extHaving = null;
            List extOrderBy = null;
            PlainSelect plainSelect = (PlainSelect)selectBody;
            List selectItems = plainSelect.getSelectItems();
            if (selectItems.size() == 1 && selectItems.get(0) instanceof AllColumns && plainSelect.getFromItem() instanceof SubSelect && (subBody = ((SubSelect)plainSelect.getFromItem()).getSelectBody()) instanceof PlainSelect && (subPlainSelect = (PlainSelect)subBody).getGroupByColumnReferences() != null) {
                if (plainSelect.getWhere() != null) {
                    plainSelect.getWhere().traversal(elem -> {
                        if (elem instanceof JdbcParameter) {
                            JdbcParameter para = (JdbcParameter)elem;
                            int index = -1;
                            index = para.getIndexInSql() < 0 ? para.getIndex() : para.getIndexInSql() + 1;
                            this.addRemovedParameterIndex(index);
                        }
                        return true;
                    });
                    if (!ParsedSqlUtil.isConstantExpression(plainSelect.getWhere())) {
                        extHaving = plainSelect.getWhere();
                        plainSelect.setWhere(null);
                    }
                }
                extOrderBy = plainSelect.getOrderByElements();
                plainSelect = subPlainSelect;
                selectItems = plainSelect.getSelectItems();
            }
            this.groupFunctionConvertor = new GroupFunctionConvertor(plainSelect, extHaving, extOrderBy);
            this.groupFunctionConvertor.prepareChanges(selectItems, this);
        }
    }

    public boolean commitGroupFunctionChanges() throws SQLException {
        if (this.groupFunctionConvertor != null && this.groupFunctionConvertor.commitChanges()) {
            if (this.complexSQL != null) {
                this.complexSQL = SplitSelectIntoGroup.splitSelectIntoGroup(this);
            }
            return true;
        }
        return this.removedParameterIndexes != null && !this.removedParameterIndexes.isEmpty();
    }

    private static List<?> processSubPlainGroupByOrderBy(PlainSelect plainSelect, PlainSelect subPlainSelect, List<?> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Column> result = new ArrayList<Column>(list.size());
        int i = 0;
        while (i < list.size()) {
            Expression orgExp = (Expression)list.get(i);
            if (orgExp instanceof Column) {
                SelectExpressionItem selectItem = ((Column)orgExp).getExtendSelectItemInGroupByOrderByHaving();
                String shortName = ParsedSqlUtil.getSelectItemShortName(selectItem);
                if (shortName == null) {
                    throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u5728\u5b50\u67e5\u8be2 " + subPlainSelect + " \u7684\u67e5\u8be2\u9879\u4e2d\u627e\u4e0d\u5230\u5206\u7ec4\u9879 " + orgExp + "\uff0c\u4e0d\u652f\u6301\u3002");
                }
                SelectExpressionItem selectItemInPlainSelect = null;
                int j = 0;
                int selectItemSize = plainSelect.getSelectItems().size();
                while (j < selectItemSize) {
                    SelectExpressionItem tmp;
                    if (plainSelect.getSelectItems().get(j) instanceof SelectExpressionItem && (tmp = (SelectExpressionItem)plainSelect.getSelectItems().get(j)).getExpression() instanceof Column && shortName.equalsIgnoreCase(((Column)tmp.getExpression()).getColumnName())) {
                        selectItemInPlainSelect = tmp;
                        break;
                    }
                    ++j;
                }
                if (selectItemInPlainSelect != null) {
                    result.add(new Column(null, ParsedSqlUtil.getSelectItemShortName(selectItemInPlainSelect)).setExtendSelectItemInGroupByOrderByHaving(selectItemInPlainSelect));
                }
            }
            ++i;
        }
        return result;
    }

    private void processOrderBy(PlainSelect plainSelect, List<?> orders) {
        if (orders != null && orders.size() > 0) {
            this.orderColumns = new SortCriteria[orders.size()];
            ArrayList<SortCriteria> aliasSort = new ArrayList<SortCriteria>();
            int i = 0;
            int count = orders.size();
            while (i < count) {
                OrderByElement orderItem = (OrderByElement)orders.get(i);
                Expression expression = orderItem.getExpression();
                PlainSelect findPlainSelect = plainSelect.getOrderByElements() == orders ? plainSelect : (PlainSelect)this.select.getSelectBody();
                String realColumnName = null;
                if (expression instanceof Column) {
                    Column orderColumn = (Column)expression;
                    SelectExpressionItem selectItem = orderColumn.getExtendSelectItemInGroupByOrderByHaving();
                    if (selectItem == null) {
                        realColumnName = ParsedSqlUtil.getNoRepeatColumnAlias(this, plainSelect, orderColumn, null, null);
                        SelectExpressionItem newSelectItem = new SelectExpressionItem();
                        assert (orderColumn.getExtendFromItem() != null);
                        newSelectItem.setExpression((Column)ParsedSqlUtil.cloneExpression(orderColumn));
                        newSelectItem.setAlias(realColumnName);
                        this.addSelectItem(plainSelect, newSelectItem);
                        if (!realColumnName.equals(orderColumn.getColumnName())) {
                            orderColumn.setTable(null);
                            orderColumn.setColumnName(realColumnName);
                        }
                        orderColumn.clearAssignFromItem();
                        orderColumn.setExtendSelectItemInGroupByOrderByHaving(newSelectItem);
                    } else {
                        realColumnName = ParsedSqlUtil.getSelectItemShortName(selectItem);
                    }
                }
                this.orderColumns[i] = new SortCriteria(realColumnName, orderItem.isAsc());
                aliasSort.add(new SortCriteria(realColumnName, orderItem.isAsc()));
                ++i;
            }
            if (aliasSort.size() > 0) {
                this.orderColumnAlias = new SortCriteria[aliasSort.size()];
                aliasSort.toArray(this.orderColumnAlias);
            }
        }
    }

    private List<?> getSelectItems(PlainSelect plainSelect) {
        SelectBody selectBody;
        List selectItems = plainSelect.getSelectItems();
        if (selectItems.size() == 1 && selectItems.get(0) instanceof AllColumns && plainSelect.getFromItem() instanceof SubSelect && (selectBody = ((SubSelect)plainSelect.getFromItem()).getSelectBody()) instanceof PlainSelect) {
            PlainSelect subPlainSelect = (PlainSelect)selectBody;
            return this.getSelectItems(subPlainSelect);
        }
        return selectItems;
    }

    /*
     * Unable to fully structure code
     */
    private int processFunction(PlainSelect plainSelect, int columnIndex, boolean isGroupInSubPlain) {
        selectItems = this.getSelectItems(plainSelect);
        i = 0;
        count = selectItems.size();
        while (i < count) {
            block6: {
                block8: {
                    block7: {
                        block5: {
                            obj = selectItems.get(i);
                            if (!(obj instanceof AllColumns)) break block5;
                            fromItem = plainSelect.getFromItem();
                            columnIndex = this.processFunction(fromItem, columnIndex);
                            if (plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0) {
                                throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u4e0d\u652f\u6301select * from\u540e\u9762\u76f4\u63a5\u5e26join\u3002\n" + plainSelect.toString());
                            }
                            break block6;
                        }
                        if (!(obj instanceof AllTableColumns)) break block7;
                        curColumn = (AllTableColumns)obj;
                        columnTableName = curColumn.getTable().getName();
                        fromItem = ParsedSqlUtil.getFromItem(plainSelect, columnTableName);
                        columnIndex = this.processFunction(fromItem, columnIndex);
                        break block6;
                    }
                    selectExpressionItem = (SelectExpressionItem)obj;
                    selectExpression = selectExpressionItem.getExpression();
                    if (isGroupInSubPlain) {
                        subSelectItem = ParsedSqlUtil.findSelectItemByColumnOrExpression(plainSelect, selectExpression, false, false, null);
                        selectExpression = ((SelectExpressionItem)subSelectItem).getExpression();
                    }
                    if (!(selectExpression instanceof Function)) break block8;
                    if (!this.processFunction((Function)selectExpression, columnIndex)) ** GOTO lbl-1000
                    ++columnIndex;
                    break block6;
                }
                if ((selectExpression instanceof BinaryExpression || selectExpression instanceof CaseExpression || selectExpression instanceof Parenthesis || selectExpression instanceof IsNullExpression) && this.processExpression(selectExpression, columnIndex)) {
                    ++columnIndex;
                } else lbl-1000:
                // 2 sources

                {
                    SqlUtil.checkNoFunction(selectExpression, SelectSqlInfo.STRS_NoSupportFunctionsInExpression);
                    ++columnIndex;
                }
            }
            ++i;
        }
        return columnIndex;
    }

    private int processFunction(FromItem fromItem, int columnIndex) {
        if (fromItem instanceof Table) {
            LinkedHashMapIgnoreCase<MetaColumn> columns;
            String tableName = ((Table)fromItem).getName();
            try {
                columns = DataObjects.getInstance().getColumnsByTableName(tableName);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            columnIndex += columns.size();
        } else if (((SubSelect)fromItem).getSelectBody() instanceof SubSelect) {
            PlainSelect subPlainSelect = ParsedSqlUtil.getPlainSelect(((SubSelect)fromItem).getSelectBody());
            columnIndex = this.processFunction(subPlainSelect, columnIndex, false);
        }
        return columnIndex;
    }

    private void processGroupBy(PlainSelect plainSelect, List<?> groups) {
        if (groups != null) {
            this.groupColumns = new ArrayList<Expression>();
            this.groupColumnAlias = new ArrayList<String>();
            int i = 0;
            int count = groups.size();
            while (i < count) {
                Expression groupItem = (Expression)groups.get(i);
                if (!(groupItem instanceof JdbcParameter)) {
                    this.groupColumns.add(groupItem);
                    if (groupItem instanceof Column) {
                        Column groupColumn = (Column)groupItem;
                        SelectExpressionItem selectItem = groupColumn.getExtendSelectItemInGroupByOrderByHaving();
                        String realColumnName = null;
                        if (selectItem == null) {
                            assert (groupColumn.getExtendFromItem() != null);
                            realColumnName = ParsedSqlUtil.getNoRepeatColumnAlias(this, plainSelect, groupItem, null, null);
                            SelectExpressionItem newSelectItem = new SelectExpressionItem();
                            newSelectItem.setExpression((Column)ParsedSqlUtil.cloneExpression(groupColumn));
                            newSelectItem.setAlias(realColumnName);
                            this.addSelectItem(plainSelect, newSelectItem);
                            groupColumn.clearAssignFromItem();
                            groupColumn.setExtendSelectItemInGroupByOrderByHaving(newSelectItem);
                        } else {
                            realColumnName = ParsedSqlUtil.getSelectItemShortName(selectItem);
                        }
                        this.groupColumnAlias.add(realColumnName);
                    } else {
                        throw new RuntimeException("\u5206\u5e93\u62a5\u9519\uff0c\u4e0d\u652f\u6301");
                    }
                }
                ++i;
            }
        }
    }

    private boolean processExpression(Expression expression, int i) {
        if (expression instanceof BinaryExpression) {
            this.processExpression(((BinaryExpression)expression).getLeftExpression(), i);
            this.processExpression(((BinaryExpression)expression).getRightExpression(), i);
        } else if (expression instanceof Parenthesis) {
            this.processExpression(((Parenthesis)expression).getExpression(), i);
        } else if (expression instanceof CaseExpression) {
            List whenClauses = ((CaseExpression)expression).getWhenClauses();
            for (WhenClause whenExp : whenClauses) {
                this.processExpression(whenExp, i);
            }
            Expression elseExpression = ((CaseExpression)expression).getElseExpression();
            if (elseExpression != null) {
                this.processExpression(elseExpression, i);
            }
        } else if (expression instanceof WhenClause) {
            this.processExpression(((WhenClause)expression).getThenExpression(), i);
            this.processExpression(((WhenClause)expression).getWhenExpression(), i);
        } else if (expression instanceof Function) {
            this.processFunction((Function)expression, i);
        } else if (expression instanceof IsNullExpression) {
            this.processExpression(((IsNullExpression)expression).getLeftExpression(), i);
        } else if (expression instanceof InverseExpression) {
            this.processExpression(((InverseExpression)expression).getExpression(), i);
        } else if (!(expression instanceof InExpression || expression instanceof Column || ParsedSqlUtil.isConstant(expression))) {
            throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u672a\u652f\u6301\u7684\u8ba1\u7b97\u8868\u8fbe\u5f0f\uff0c" + expression + "\u3002");
        }
        return true;
    }

    private boolean processFunction(Function function, int i) {
        List paras;
        String functionName = function.getName();
        if (functionName.equalsIgnoreCase("avg")) {
            throw new RuntimeException("\u5206\u8868\u5206\u5e93\u76ee\u524d\u4e0d\u652f\u6301avg\u51fd\u6570\uff0c" + this.getSql() + "\u3002");
        }
        if (functionName.equalsIgnoreCase("group_concat")) {
            throw new RuntimeException("\u5206\u8868\u5206\u5e93\u76ee\u524d\u4e0d\u652f\u6301group_concat\u51fd\u6570\uff0c" + this.getSql() + "\u3002");
        }
        if (functionName.equalsIgnoreCase("max") || functionName.equalsIgnoreCase("min") || functionName.equalsIgnoreCase("count") || functionName.equalsIgnoreCase("sum")) {
            if (this.functions != null && i < this.functions.size() && this.functions.get(i) != null && !this.functions.get(i).equalsIgnoreCase(functionName)) {
                throw new RuntimeException("\u5206\u8868\u5206\u5e93\u76ee\u524d\u4e0d\u652f\u6301\u5728\u540c\u4e00\u5217\u591a\u4e2a\u7c7b\u578b\u51fd\u6570\uff0c" + this.getSql() + "\u3002");
            }
            if (this.functions == null) {
                this.functions = new ArrayList<String>();
            }
            while (this.functions.size() <= i) {
                this.functions.add(null);
            }
            this.functions.set(i, functionName);
            return true;
        }
        if ((functionName.equalsIgnoreCase("coalesce") || functionName.equalsIgnoreCase("ifnull")) && (paras = function.getParameters().getExpressions()).size() == 2 && ParsedSqlUtil.isConstantZero((Expression)paras.get(1))) {
            return this.processExpression((Expression)paras.get(0), i);
        }
        return false;
    }

    public String getAliasByColumnName(String columnName, List<?> selectItems) {
        Expression exp;
        String alias;
        SelectExpressionItem selectItem;
        String colName = columnName.substring(columnName.indexOf(".") + 1);
        for (Object obj : selectItems) {
            String tableName;
            String realName;
            if (obj instanceof SelectExpressionItem) {
                String curColumnName;
                selectItem = (SelectExpressionItem)obj;
                alias = selectItem.getAlias();
                exp = selectItem.getExpression();
                if (exp instanceof Column) {
                    String wholeColumnName = ((Column)exp).getWholeColumnName();
                    String curColumnName2 = ((Column)exp).getColumnName();
                    if (!wholeColumnName.equalsIgnoreCase(columnName) && !columnName.equalsIgnoreCase(curColumnName2) && !colName.equalsIgnoreCase(curColumnName2)) continue;
                    if (alias != null) {
                        return alias;
                    }
                    return ((Column)exp).getColumnName();
                }
                if (!(exp instanceof Function) || !columnName.equalsIgnoreCase(curColumnName = exp.toString())) continue;
                return alias;
            }
            if (obj instanceof AllColumns) {
                return colName;
            }
            if (!(obj instanceof AllTableColumns) || !DBStruct.isExistColumnInTable(colName, realName = this.getTableName(tableName = ((AllTableColumns)obj).getTable().getName()))) continue;
            return colName;
        }
        for (Object obj : selectItems) {
            if (!(obj instanceof SelectExpressionItem)) continue;
            selectItem = (SelectExpressionItem)obj;
            alias = selectItem.getAlias();
            exp = selectItem.getExpression();
            if (exp instanceof Column || !ParsedSqlUtil.isExistColumn(columnName, exp)) continue;
            return alias;
        }
        return null;
    }

    public String getAliasByColumnName(Object column, List<?> selectItems) {
        Expression exp;
        String alias;
        SelectExpressionItem selectItem;
        String columnName = column.toString();
        String result = null;
        String colName = columnName.substring(columnName.indexOf(".") + 1);
        for (Object obj : selectItems) {
            String tableName;
            String realName;
            if (obj instanceof SelectExpressionItem) {
                String curColumnName;
                selectItem = (SelectExpressionItem)obj;
                alias = selectItem.getAlias();
                exp = selectItem.getExpression();
                if (exp instanceof Column && column instanceof Column) {
                    Table columeTable = ((Column)column).getTable();
                    String selectTableName = "";
                    if (columeTable != null) {
                        selectTableName = columeTable.getName();
                    }
                    String curColumnName2 = ((Column)exp).getColumnName();
                    Expression expression = selectItem.getExpression();
                    Table selectTable = ((Column)expression).getTable();
                    String tableName2 = "";
                    if (selectTable != null) {
                        tableName2 = selectTable.getName();
                    }
                    if (tableName2 != null && selectTableName != null && tableName2.equalsIgnoreCase(selectTableName) && curColumnName2.equalsIgnoreCase(((Column)column).getColumnName())) {
                        if (alias != null) {
                            return alias;
                        }
                        return ((Column)expression).getColumnName();
                    }
                    if (!curColumnName2.equalsIgnoreCase(((Column)column).getColumnName())) continue;
                    if (alias != null) {
                        result = alias;
                        continue;
                    }
                    result = ((Column)expression).getColumnName();
                    continue;
                }
                if (!(exp instanceof Function) || !columnName.equalsIgnoreCase(curColumnName = exp.toString())) continue;
                return alias;
            }
            if (obj instanceof AllColumns) {
                return colName;
            }
            if (!(obj instanceof AllTableColumns) || !DBStruct.isExistColumnInTable(colName, realName = this.getTableName(tableName = ((AllTableColumns)obj).getTable().getName()))) continue;
            return colName;
        }
        for (Object obj : selectItems) {
            if (!(obj instanceof SelectExpressionItem)) continue;
            selectItem = (SelectExpressionItem)obj;
            alias = selectItem.getAlias();
            exp = selectItem.getExpression();
            if (exp instanceof Column || !ParsedSqlUtil.isExistColumn(columnName, exp)) continue;
            return alias;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComplexSQL getComplexSQL() throws SQLException {
        if (!this.isLoadSubSelects) {
            SelectSqlInfo selectSqlInfo = this;
            synchronized (selectSqlInfo) {
                if (!this.isLoadSubSelects) {
                    if (this.getAllTables().size() > 1 && !this.isSameSingleGroup()) {
                        this.checkSupportMultiDBs();
                        AssignColumnToFromItem.assign(this.select);
                        this.getJdbcParameters();
                        Select orgSelect = this.select;
                        Select tmp = new SplitSubUnion().splitSubUnion(this.sql, this.select);
                        this.setSelectMainTable(this.parseTableName());
                        if (orgSelect != tmp) {
                            this.select = tmp;
                            AssignColumnToFromItem.reAssign(this.select);
                            this.reProcessAllTables();
                        }
                        this.complexSQL = SplitSelectIntoGroup.splitSelectIntoGroup(this);
                        if (this.complexSQL == null && this.addColumnCount == 0) {
                            try {
                                this.select = (Select)SqlInfos.instance.reparseSql(this.sql);
                            }
                            catch (JSQLParserException e) {
                                throw new RuntimeException("ERROR");
                            }
                            this.clearJdbcParameters();
                        }
                    }
                    this.isLoadSubSelects = true;
                }
            }
        }
        return this.complexSQL;
    }

    public void setComplexSQL(SubQuerys result) {
        this.isLoadSubSelects = true;
        this.complexSQL = result;
    }

    public Select getSelect() {
        return this.select;
    }

    public String getSelectMainTable() {
        return this.selectMainTable;
    }

    public void setSelectMainTable(String selectMainTable) {
        this.selectMainTable = selectMainTable;
    }

    public InTableGroups getInTableGroups() {
        this.getAllTables();
        return this.inTableGroups;
    }

    public void setInTableGroups(InTableGroups inTableGroups) {
        this.inTableGroups = inTableGroups;
    }

    public List<OrderBy> getOrderByElements() {
        if (this.groupFunctionConvertor != null && this.groupFunctionConvertor.hasGroupFunction()) {
            return this.groupFunctionConvertor.getOrgOrderBy();
        }
        this.processFunctionGroupByOrderBy();
        if (this.orderByObjects == null) {
            SelectBody selectBody = this.select.getSelectBody();
            ArrayList<OrderBy> tmp = new ArrayList<OrderBy>();
            if (selectBody instanceof PlainSelect && !this.isNoGroup()) {
                PlainSelect plainSelect = (PlainSelect)selectBody;
                List orderByElements = plainSelect.getOrderByElements();
                int size = orderByElements != null ? orderByElements.size() : 0;
                tmp.ensureCapacity(size);
                int i = 0;
                int length = size;
                while (i < length) {
                    Expression expression = ((OrderByElement)orderByElements.get(i)).getExpression();
                    boolean isAsc = ((OrderByElement)orderByElements.get(i)).isAsc();
                    if (expression instanceof Column) {
                        Column column = (Column)expression;
                        assert (column.getExtendSelectItemInGroupByOrderByHaving() != null);
                        String realColumnName = ParsedSqlUtil.getSelectItemShortName(column.getExtendSelectItemInGroupByOrderByHaving());
                        tmp.add(new OrderBy(realColumnName, -1, isAsc));
                    }
                    ++i;
                }
            }
            this.orderByObjects = tmp;
        }
        return this.orderByObjects;
    }

    public boolean isDistinct() {
        if (this.isDistinct == null) {
            boolean tmp = false;
            SelectBody selectBody = this.select.getSelectBody();
            while (selectBody instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)selectBody;
                if (plainSelect.getDistinct() != null) {
                    tmp = true;
                    break;
                }
                selectBody = null;
                List selectItems = plainSelect.getSelectItems();
                if (selectItems.size() != 1 || !(selectItems.get(0) instanceof AllColumns) || !(plainSelect.getFromItem() instanceof SubSelect)) continue;
                selectBody = ((SubSelect)plainSelect.getFromItem()).getSelectBody();
            }
            this.isDistinct = tmp;
        }
        return this.isDistinct != false || this.groupFunctionConvertor != null && this.groupFunctionConvertor.getOrgDistinct() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameSingleGroup() {
        if (this.isSameSingleGroup != null) {
            return this.isSameSingleGroup;
        }
        SelectSqlInfo selectSqlInfo = this;
        synchronized (selectSqlInfo) {
            if (this.isSameSingleGroup == null) {
                this.isSameSingleGroup = ParsedSqlUtil.isSameSingleGroup(this.getAllTableNames());
            }
        }
        return this.isSameSingleGroup;
    }

    public int getAddColumnCount() {
        if (!this.hasParsedFunctionGroupByOrderBy) {
            this.processFunctionGroupByOrderBy();
        }
        return this.addColumnCount;
    }

    public void checkSupportMultiDBs() {
        SelectBody selectBody = this.select.getSelectBody();
        this.checkSelectItem(selectBody);
        this.checkFromItem(selectBody);
        this.checkWhereOn(selectBody);
        this.checkGroupBy(selectBody);
        this.checkOrderBy(selectBody);
        this.checkLimit(selectBody);
        this.checkNoUnionInSubSelect(selectBody);
        this.checkLock(selectBody);
        this.checkINInORExpression(selectBody);
    }

    private void checkSelectItem(SelectBody selectBody) {
        this.checkSelectItemAllColumnWithJoin(selectBody);
        this.checkSelectItemExpressionNoAliasName(selectBody);
        this.checkSelectItemFunction(selectBody);
        this.checkSelectItemJDBCParameter(selectBody);
    }

    private void checkSelectItemFunction(SelectBody selectBody) {
        block4: {
            block3: {
                if (!(selectBody instanceof PlainSelect)) break block3;
                List<?> selectItems = this.getSelectItems((PlainSelect)selectBody);
                int i = 0;
                int count = selectItems.size();
                while (i < count) {
                    Object obj = selectItems.get(i);
                    if (obj instanceof SelectExpressionItem) {
                        SelectExpressionItem selectExpItem = (SelectExpressionItem)obj;
                        selectExpItem.getExpression().accept(new BaseExpressionVisitor(){

                            @Override
                            public void visit(Function function) {
                                String functionName = function.getName();
                                if (functionName.equalsIgnoreCase("avg") || functionName.equalsIgnoreCase("group_concat")) {
                                    throw new MDBNotSupportException(1, SelectSqlInfo.this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_001_SelectItemNotSupportFunction"), (Object[])new Object[]{functionName}));
                                }
                            }
                        });
                    }
                    ++i;
                }
                break block4;
            }
            if (!(selectBody instanceof Union)) break block4;
            for (Object obj : ((Union)selectBody).getPlainSelects()) {
                this.checkSelectItemFunction((SelectBody)obj);
            }
        }
    }

    private void checkSelectItemJDBCParameter(SelectBody selectBody) {
        selectBody.traversal(elem -> {
            if (elem instanceof SelectExpressionItem) {
                SelectExpressionItem selectExpItem = (SelectExpressionItem)elem;
                selectExpItem.getExpression().accept(new BaseExpressionVisitor(){

                    @Override
                    public void visit(JdbcParameter jdbcParameter) {
                        throw new MDBNotSupportException(2, SelectSqlInfo.this.sql, StringTable.getString(null, "Err_002_SelectItemNotSupportJDBCParameter"));
                    }

                    @Override
                    public void visit(SubSelect subSelect) {
                        SelectSqlInfo.this.checkSelectItemJDBCParameter(subSelect.getSelectBody());
                    }
                });
            }
            return true;
        });
    }

    private void checkFromItem(SelectBody selectBody) {
        this.checkFromItemNotSupportSystemTable();
        this.checkFromItemNotSupportRightOrFullJoin(selectBody);
        this.checkFromItemNotSupportSubJoin(selectBody);
        this.checkFromItemJoinMustHasEquals(selectBody);
    }

    private void checkFromItemNotSupportSystemTable() {
        List<String> allTableNames = this.getAllTableNames();
        String firstSystemTable = null;
        boolean hasMDBTable = false;
        for (String tableName : allTableNames) {
            List<MetaDataObject> dataObjects;
            TableGroupProp group = TableGroupProps.getInstance().getTableGroupProp(tableName);
            if (group != null) {
                hasMDBTable = true;
                continue;
            }
            if (firstSystemTable != null || (dataObjects = DataObjects.getInstance().getDataObjectsByTableName(tableName)) != null && !dataObjects.isEmpty()) continue;
            firstSystemTable = tableName;
        }
        if (hasMDBTable && firstSystemTable != null) {
            throw new MDBNotSupportException(3, this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_003_NotSupportSystemTable"), (Object[])new Object[]{firstSystemTable}));
        }
    }

    private void checkFromItemNotSupportRightOrFullJoin(SelectBody selectBody) {
        selectBody.traversal(elem -> {
            if (elem instanceof Join && (((Join)elem).isRight() || ((Join)elem).isFull())) {
                throw new MDBNotSupportException(4, this.sql, StringTable.getString(null, "Err_004_NotSupportRightOrFullJoin"));
            }
            return true;
        });
    }

    private void checkFromItemNotSupportSubJoin(SelectBody selectBody) {
        selectBody.traversal(elem -> {
            if (elem instanceof SubJoin) {
                throw new MDBNotSupportException(5, this.sql, StringTable.getString(null, "Err_005_NotSupportSubJoin"));
            }
            return true;
        });
    }

    private void checkFromItemJoinMustHasEquals(SelectBody selectBody) {
        block8: {
            block7: {
                if (this.isNoGroup()) {
                    return;
                }
                if (!(selectBody instanceof PlainSelect)) break block7;
                PlainSelect plainSelect = (PlainSelect)selectBody;
                if (plainSelect.getFromItem() == null || plainSelect.getJoins() == null) break block8;
                AssignColumnToFromItem.assign(this.select);
                ArrayList<FromItem> beforeJoinFromItems = new ArrayList<FromItem>();
                beforeJoinFromItems.add(plainSelect.getFromItem());
                for (Object obj : plainSelect.getJoins()) {
                    Join join = (Join)obj;
                    boolean foundEqualsTo = false;
                    for (FromItem beforeJoinFromItem : beforeJoinFromItems) {
                        if (ParsedSqlUtil.findEqualsToInExpression(join.getOnExpression(), join.getRightItem(), beforeJoinFromItem) != null) {
                            foundEqualsTo = true;
                            break;
                        }
                        if (ParsedSqlUtil.findEqualsToInExpression(plainSelect.getWhere(), join.getRightItem(), beforeJoinFromItem) == null) continue;
                        foundEqualsTo = true;
                        break;
                    }
                    if (!foundEqualsTo) {
                        throw new MDBNotSupportException(6, this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_006_JoinMustHasEqualsTo"), (Object[])new Object[]{join.getRightItem()}));
                    }
                    beforeJoinFromItems.add(join.getRightItem());
                }
                break block8;
            }
            if (selectBody instanceof Union) {
                for (Object obj : ((Union)selectBody).getPlainSelects()) {
                    this.checkFromItemJoinMustHasEquals((SelectBody)obj);
                }
            }
        }
    }

    private void checkSelectItemExpressionNoAliasName(SelectBody selectBody) {
        selectBody.traversal(elem -> {
            SelectExpressionItem selectExpItem;
            if (elem instanceof SelectExpressionItem && !((selectExpItem = (SelectExpressionItem)elem).getExpression() instanceof Column) && selectExpItem.getAlias() == null) {
                throw new MDBNotSupportException(8, this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_008_SelectItemExpressionNoAliasName"), (Object[])new Object[]{selectExpItem.getExpression()}));
            }
            return true;
        });
    }

    public void checkSelectItemAllColumnWithJoin(SelectBody selectBody) {
        selectBody.traversal(elem -> {
            PlainSelect plainSelect;
            if (elem instanceof PlainSelect && (plainSelect = (PlainSelect)elem).getFromItem() != null && plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0 && plainSelect.getSelectItems().get(0) instanceof AllColumns) {
                throw new MDBNotSupportException(7, this.sql, StringTable.getString(null, "Err_007_NotSupportAllColumnWithJoin"));
            }
            return true;
        });
    }

    private void checkWhereOn(SelectBody selectBody) {
        this.checkWhereOnSubSelect(selectBody);
        this.checkWhereOnNotSupportNotInNotExists(selectBody);
        this.checkWhereOnNotSupportMultiInSubSelect(selectBody);
    }

    private void checkWhereOnSubSelect(SelectBody selectBody) {
        selectBody.traversal(elem -> {
            Expression whereOnExp = null;
            if (elem instanceof Join) {
                whereOnExp = ((Join)elem).getOnExpression();
            } else if (elem instanceof PlainSelect) {
                whereOnExp = ((PlainSelect)elem).getWhere();
            }
            if (whereOnExp != null) {
                RefObject checkedSubSelect = new RefObject(null);
                whereOnExp.traversal(expression -> {
                    if (expression instanceof Join) {
                        if (!(((Join)expression).getRightItem() instanceof SubSelect)) return true;
                        checkedSubSelect.setValue((Object)((SubSelect)((Join)expression).getRightItem()));
                        return true;
                    } else if (expression instanceof SelectExpressionItem) {
                        if (!(((SelectExpressionItem)expression).getExpression() instanceof SubSelect)) return true;
                        checkedSubSelect.setValue((Object)((SubSelect)((SelectExpressionItem)expression).getExpression()));
                        return true;
                    } else if (expression instanceof InExpression) {
                        InExpression inExpression = (InExpression)expression;
                        if (!(inExpression.getItemsList() instanceof SubSelect)) return true;
                        checkedSubSelect.setValue((Object)((SubSelect)inExpression.getItemsList()));
                        return true;
                    } else if (expression instanceof MultiInExpression) {
                        MultiInExpression multiInExpression = (MultiInExpression)expression;
                        if (!(multiInExpression.getValuesList().get(0).get(0) instanceof SubSelect)) return true;
                        checkedSubSelect.setValue((Object)((SubSelect)multiInExpression.getValuesList().get(0).get(0)));
                        return true;
                    } else if (expression instanceof ExistsExpression) {
                        ExistsExpression existsExpression = (ExistsExpression)expression;
                        if (!(existsExpression.getRightExpression() instanceof SubSelect)) return true;
                        checkedSubSelect.setValue((Object)((SubSelect)existsExpression.getRightExpression()));
                        return true;
                    } else if (expression instanceof BinaryExpression) {
                        SelectBody subSelectBody_;
                        BinaryExpression binaryExpression;
                        if (!this.isNoGroup()) {
                            AssignColumnToFromItem.assign(this.select);
                        }
                        if (!((binaryExpression = (BinaryExpression)expression).getLeftExpression() instanceof Column) || !(binaryExpression.getRightExpression() instanceof SubSelect) || !((subSelectBody_ = ((SubSelect)binaryExpression.getRightExpression()).getSelectBody()) instanceof PlainSelect) || ((PlainSelect)subSelectBody_).getJoins() != null) return true;
                        FromItem leftFromItem = ((Column)binaryExpression.getLeftExpression()).getExtendFromItem();
                        FromItem subFromItem = ((PlainSelect)subSelectBody_).getFromItem();
                        if (!(leftFromItem instanceof Table) || !(subFromItem instanceof Table) || !((Table)leftFromItem).getName().equalsIgnoreCase(((Table)subFromItem).getName()) || TableGroupProps.getInstance().getTableGroupProp(((Table)leftFromItem).getName()) != null) throw new MDBNotSupportException(9, this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_009_WhereOnSubSelectInExistsBinarySameNoGroupTable"), (Object[])new Object[]{binaryExpression.getRightExpression()}));
                        checkedSubSelect.setValue((Object)((SubSelect)binaryExpression.getRightExpression()));
                        return true;
                    } else {
                        if (!(expression instanceof SubSelect)) return true;
                        if (checkedSubSelect.getValue() != expression) throw new MDBNotSupportException(9, this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_009_WhereOnSubSelectInExistsBinarySameNoGroupTable"), (Object[])new Object[]{expression}));
                        checkedSubSelect.setValue(null);
                    }
                    return true;
                });
            }
            return true;
        });
    }

    private void checkWhereOnNotSupportNotInNotExists(SelectBody selectBody) {
        selectBody.traversal(elem -> {
            if (elem instanceof ExistsExpression && ((ExistsExpression)elem).isNot()) {
                throw new MDBNotSupportException(10, this.sql, StringTable.getString(null, "Err_010_NotSupportNotExists"));
            }
            return true;
        });
    }

    private void checkWhereOnNotSupportMultiInSubSelect(SelectBody selectBody) {
        selectBody.traversal(elem -> {
            if (elem instanceof MultiInExpression) {
                MultiInExpression multiInExpression = (MultiInExpression)elem;
                List<List<Expression>> valuesList = multiInExpression.getValuesList();
                for (List<Expression> values : valuesList) {
                    for (Expression value : values) {
                        if (!(value instanceof SubSelect)) continue;
                        throw new MDBNotSupportException(11, this.sql, StringTable.getString(null, "Err_011_NotSupportMultiInSubSelect"));
                    }
                }
            }
            return true;
        });
    }

    private void checkGroupBy(SelectBody selectBody) {
        this.checkGroupByNotSupportConstant(selectBody);
        this.checkGroupByNotSupportNonColumnExpression(selectBody);
        this.checkGroupBySelectItemAliasAmbiguous(selectBody);
        this.checkGroupBySelectItemSupportOneFunctionExceptMultiSum(selectBody);
    }

    private void checkGroupByNotSupportConstant(SelectBody selectBody) {
        selectBody.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                if (plainSelect.getGroupByColumnReferences() != null) {
                    for (Object groupByColumnReference : plainSelect.getGroupByColumnReferences()) {
                        if (!ParsedSqlUtil.isConstant(groupByColumnReference)) continue;
                        throw new MDBNotSupportException(13, SelectSqlInfo.this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_013_GroupByNotSupportConstant"), (Object[])new Object[]{groupByColumnReference}));
                    }
                }
                super.visit(plainSelect);
            }
        });
    }

    private void checkGroupByNotSupportNonColumnExpression(SelectBody selectBody) {
        selectBody.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                if (plainSelect.getGroupByColumnReferences() != null) {
                    for (Object groupByColumnReference : plainSelect.getGroupByColumnReferences()) {
                        if (!(groupByColumnReference instanceof Expression) || groupByColumnReference instanceof Column) continue;
                        throw new MDBNotSupportException(14, SelectSqlInfo.this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_014_GroupByNotSupportNonColumnExpression"), (Object[])new Object[]{groupByColumnReference}));
                    }
                }
                super.visit(plainSelect);
            }
        });
    }

    private void checkGroupBySelectItemAliasAmbiguous(SelectBody selectBody) {
        if (this.isNoGroup()) {
            return;
        }
        AssignColumnToFromItem.assign(this.select);
        selectBody.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                if (plainSelect.getGroupByColumnReferences() != null) {
                    for (Object groupByColumnReference : plainSelect.getGroupByColumnReferences()) {
                        if (!(groupByColumnReference instanceof Column) || ((Column)groupByColumnReference).getExtendSelectItemInGroupByOrderByHaving() == null || ((Column)groupByColumnReference).getExtendFromItem() == null) continue;
                        throw new MDBNotSupportException(15, SelectSqlInfo.this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_015_GroupBySelectItemAliasAmbiguous"), (Object[])new Object[]{groupByColumnReference}));
                    }
                }
                super.visit(plainSelect);
            }
        });
    }

    private void checkGroupBySelectItemSupportOneFunctionExceptMultiSum(SelectBody selectBody) {
        selectBody.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                if (plainSelect.getGroupByColumnReferences() != null) {
                    for (final Object selectItem : plainSelect.getSelectItems()) {
                        if (!(selectItem instanceof SelectExpressionItem)) continue;
                        final RefObject existFunctionName = new RefObject(null);
                        ((SelectExpressionItem)selectItem).getExpression().accept(new BaseExpressionVisitor(){

                            @Override
                            public void visit(Function function) {
                                String functionName = function.getName();
                                if (functionName.equalsIgnoreCase("sum") || functionName.equalsIgnoreCase("max") || functionName.equalsIgnoreCase("min") || functionName.equalsIgnoreCase("count")) {
                                    if (existFunctionName.getValue() == null) {
                                        existFunctionName.setValue((Object)functionName);
                                    } else if (!"sum".equalsIgnoreCase(functionName) || !"sum".equalsIgnoreCase((String)existFunctionName.getValue())) {
                                        throw new MDBNotSupportException(16, (this).SelectSqlInfo.this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_016_GroupBySelectItemSupportOneFunctionExceptMultiSum"), (Object[])new Object[]{selectItem}));
                                    }
                                }
                            }
                        });
                    }
                }
                super.visit(plainSelect);
            }
        });
    }

    private void checkOrderBy(SelectBody selectBody) {
        this.checkOrderByNotSupportConstant(selectBody);
        this.checkOrderByNotSupportNonColumnExpression(selectBody);
    }

    private void checkOrderByNotSupportConstant(SelectBody selectBody) {
        selectBody.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                if (plainSelect.getOrderByElements() != null) {
                    for (Object orderByElement : plainSelect.getOrderByElements()) {
                        Expression orderByExp = ((OrderByElement)orderByElement).getExpression();
                        if (!ParsedSqlUtil.isConstant(orderByExp)) continue;
                        throw new MDBNotSupportException(18, SelectSqlInfo.this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_018_OrderByNotSupportConstant"), (Object[])new Object[]{orderByExp}));
                    }
                }
                super.visit(plainSelect);
            }
        });
    }

    private void checkOrderByNotSupportNonColumnExpression(SelectBody selectBody) {
        selectBody.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                if (plainSelect.getOrderByElements() != null) {
                    for (Object orderByElement : plainSelect.getOrderByElements()) {
                        Expression orderByExp = ((OrderByElement)orderByElement).getExpression();
                        if (orderByExp instanceof Column) continue;
                        throw new MDBNotSupportException(19, SelectSqlInfo.this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_019_OrderByNotSupportNonColumnExpression"), (Object[])new Object[]{orderByElement}));
                    }
                }
                super.visit(plainSelect);
            }
        });
    }

    private void checkLimit(SelectBody selectBody) {
    }

    private void checkNoUnionInSubSelect(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect && ((PlainSelect)selectBody).getSelectItems().size() == 1 && ((PlainSelect)selectBody).getSelectItems().get(0) instanceof AllColumns && ((PlainSelect)selectBody).getJoins() == null && ((PlainSelect)selectBody).getFromItem() instanceof SubSelect) {
            selectBody = ((SubSelect)((PlainSelect)selectBody).getFromItem()).getSelectBody();
        }
        final RefObject subSelectRef = new RefObject(null);
        selectBody.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(SubSelect subSelect) {
                subSelectRef.setValue((Object)subSelect);
                super.visit(subSelect);
                subSelectRef.setValue(null);
            }

            @Override
            public void visit(Union union) {
                if (subSelectRef.getValue() != null) {
                    throw new MDBNotSupportException(29, SelectSqlInfo.this.sql, SimpleStringFormat.format((String)StringTable.getString(null, "Err_029_UnionNonSupportInSubSelect"), (Object[])new Object[]{subSelectRef.getValue()}));
                }
            }
        });
    }

    private void checkLock(SelectBody selectBody) {
        if (this.isNoGroup()) {
            return;
        }
        selectBody.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(PlainSelect plainSelect) {
                if (plainSelect.isForUpdate()) {
                    throw new MDBNotSupportException(30, SelectSqlInfo.this.sql, StringTable.getString(null, "Err_030_NotSupportLock"));
                }
                super.visit(plainSelect);
            }
        });
    }

    private void checkINInORExpression(SelectBody selectBody) {
        final RefObject isOr = new RefObject((Object)false);
        final RefObject isIn = new RefObject((Object)false);
        selectBody.accept(new BaseExpressionVisitor(){

            @Override
            public void visit(OrExpression orExpression) {
                boolean oldValue = (Boolean)isOr.getValue();
                isOr.setValue((Object)true);
                isIn.setValue((Object)false);
                super.visit(orExpression);
                if (((Boolean)isIn.getValue()).booleanValue()) {
                    throw new RuntimeException("SQL\u4e0d\u652f\u6301\u5206\u5e93\uff0cOr\u6761\u4ef6" + orExpression.toString() + "\u5305\u542bIn\u5b50\u53e5\uff0c\u8bf7\u4fee\u6539\u3002\n" + SelectSqlInfo.this.sql);
                }
                isOr.setValue((Object)oldValue);
            }

            @Override
            public void visit(InExpression inExpression) {
                if (inExpression.getItemsList() instanceof SubSelect) {
                    isIn.setValue((Object)((Boolean)isOr.getValue()));
                }
                super.visit(inExpression);
            }
        });
    }

    public void addColumnIndex(boolean isSum, String newAlias) {
        if (this.hasParsedFunctionGroupByOrderBy) {
            if (isSum) {
                if (this.functions == null) {
                    this.functions = new ArrayList<String>(this.columnCountForFunctions + 1);
                }
                while (this.functions.size() <= this.columnCountForFunctions) {
                    this.functions.add(null);
                }
                this.functions.set(this.columnCountForFunctions, "sum");
            }
            ++this.columnCountForFunctions;
        }
    }

    public boolean addSelectItem(PlainSelect plainSelect, SelectItem selectItem) {
        boolean result;
        if (plainSelect == null) {
            plainSelect = ParsedSqlUtil.getPlainSelect(this.select.getSelectBody());
        }
        if ((result = ParsedSqlUtil.addSelectItem(plainSelect, selectItem)) && this.fields == null) {
            ++this.addColumnCount;
        }
        return result;
    }

    @Override
    public boolean isNoGroup() {
        if (this.isNoGroup == null) {
            this.isNoGroup = ParsedSqlUtil.isNoGroup(this);
        }
        return this.isNoGroup;
    }

    public boolean isDataMayRepeat() {
        if (this.isDataMayRepeat == null) {
            boolean hasDetailTableInGroupByDetailTable = false;
            boolean hasDataMayRepeat = false;
            if (!this.isDistinct()) {
                List<Table> tables = this.getAllTables();
                InTableGroups inTables = this.getInTableGroups();
                int i = 0;
                int size = tables.size();
                while (i < size) {
                    TableGroupProp tableGroupProp;
                    if (!(inTables != null && inTables.containsObject(tables.get(i)) || (tableGroupProp = TableGroupProps.getInstance().getTableGroupProp(tables.get(i).getName())) == null)) {
                        if (tableGroupProp.getFixedType() == TableGroupType.DetailTableInGroupByDetailTable) {
                            hasDetailTableInGroupByDetailTable = true;
                        } else if (tableGroupProp.getFixedType() == TableGroupType.HeadTableInGroupByDetailTable || tableGroupProp.getVariableTypes() != null && tableGroupProp.getVariableTypes().containsValue(TableGroupType.HeadTableInGroupByDetailTable) || tableGroupProp.getFixedType() == TableGroupType.OtherDetailTableInGroupByDetailTable || tableGroupProp.getVariableTypes() != null && tableGroupProp.getVariableTypes().containsValue(TableGroupType.OtherDetailTableInGroupByDetailTable)) {
                            hasDataMayRepeat = true;
                        }
                    }
                    ++i;
                }
            }
            this.isDataMayRepeat = hasDataMayRepeat && !hasDetailTableInGroupByDetailTable;
        }
        return this.isDataMayRepeat;
    }

    public void reProcessFunctionGroupByOrderBy() {
        this.hasParsedFunctionGroupByOrderBy = false;
        this.processFunctionGroupByOrderBy();
    }

    public List<String> getColumnNamesInResultSet() {
        if (this.mColumnNamesInResultSet == null) {
            ArrayList<String> tmp = new ArrayList<String>();
            if (this.select.getSelectBody() instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)this.select.getSelectBody();
                this.getColumnNamesInResultSet(plainSelect, tmp);
            } else if (this.select.getSelectBody() instanceof Union) {
                Union union = (Union)this.select.getSelectBody();
                this.getColumnNamesInResultSet((PlainSelect)union.getPlainSelects().get(0), tmp);
            }
            this.mColumnNamesInResultSet = tmp;
        }
        return this.mColumnNamesInResultSet;
    }

    private List<String> getColumnNamesInResultSet(PlainSelect plainSelect, List<String> result) {
        result = result == null ? new ArrayList<String>() : result;
        FromItem fromItem = plainSelect.getFromItem();
        List selectItems = plainSelect.getSelectItems();
        boolean paraIndex = false;
        for (Object obj : selectItems) {
            if (obj instanceof AllColumns) {
                if (fromItem instanceof Table) {
                    String tableName = ((Table)fromItem).getName();
                    LinkedHashMapIgnoreCase<MetaColumn> columns = DataObjects.getInstance().getColumnsByTableName(tableName);
                    for (MetaColumn metaColumn : columns.values()) {
                        result.add(metaColumn.getBindingDBColumnName());
                    }
                    continue;
                }
                if (!(fromItem instanceof SubSelect)) continue;
                this.getColumnNamesInResultSet(ParsedSqlUtil.getPlainSelect(((SubSelect)fromItem).getSelectBody()), result);
                continue;
            }
            if (obj instanceof AllTableColumns) {
                AllTableColumns curColumn = (AllTableColumns)obj;
                String columnTableName = curColumn.getTable().getName();
                FromItem fromItemColumn = ParsedSqlUtil.getFromItem(plainSelect, columnTableName);
                if (fromItemColumn instanceof Table) {
                    LinkedHashMapIgnoreCase<MetaColumn> allColumns = DataObjects.getInstance().getColumnsByTableName(((Table)fromItemColumn).getName());
                    for (MetaColumn metaColumn : allColumns.values()) {
                        result.add(metaColumn.getBindingDBColumnName());
                    }
                    continue;
                }
                if (!(fromItemColumn instanceof SubSelect)) continue;
                this.getColumnNamesInResultSet(ParsedSqlUtil.getPlainSelect(((SubSelect)fromItemColumn).getSelectBody()), result);
                continue;
            }
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)obj;
            result.add(ParsedSqlUtil.getSelectItemShortName(selectExpressionItem));
        }
        return result;
    }

    public List<Field> getFields(List<Parameters> parametersList) {
        AssignColumnToFromItem.assign(this.select);
        if (this.fields == null) {
            ArrayList<Field> tmp = new ArrayList<Field>();
            if (this.select.getSelectBody() instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)this.select.getSelectBody();
                this.getFields(plainSelect, parametersList, tmp);
            } else if (this.select.getSelectBody() instanceof Union) {
                Union union = (Union)this.select.getSelectBody();
                this.getFields((PlainSelect)union.getPlainSelects().get(0), parametersList, tmp);
            }
            this.fields = tmp;
        }
        return this.fields;
    }

    private List<Field> getFields(PlainSelect plainSelect, List<Parameters> parametersList, List<Field> result) {
        result = result == null ? new ArrayList<Field>() : result;
        FromItem fromItem = plainSelect.getFromItem();
        List selectItems = plainSelect.getSelectItems();
        int paraIndex = 0;
        for (Object obj : selectItems) {
            Field field;
            if (obj instanceof AllColumns) {
                if (fromItem instanceof Table) {
                    String tableName = ((Table)fromItem).getName();
                    LinkedHashMapIgnoreCase<MetaColumn> columns = DataObjects.getInstance().getColumnsByTableName(tableName);
                    for (MetaColumn metaColumn : columns.values()) {
                        result.add(new Field((Table)fromItem, metaColumn));
                    }
                    continue;
                }
                if (!(fromItem instanceof SubSelect)) continue;
                List<Field> fields = this.getFields(ParsedSqlUtil.getPlainSelect(((SubSelect)fromItem).getSelectBody()), parametersList, null);
                result.addAll(fields);
                continue;
            }
            if (obj instanceof AllTableColumns) {
                AllTableColumns curColumn = (AllTableColumns)obj;
                String columnTableName = curColumn.getTable().getName();
                FromItem fromItemColumn = ParsedSqlUtil.getFromItem(plainSelect, columnTableName);
                if (fromItemColumn instanceof Table) {
                    LinkedHashMapIgnoreCase<MetaColumn> allColumns = DataObjects.getInstance().getColumnsByTableName(((Table)fromItemColumn).getName());
                    for (MetaColumn metaColumn : allColumns.values()) {
                        result.add(new Field((Table)fromItemColumn, metaColumn));
                    }
                    continue;
                }
                if (!(fromItemColumn instanceof SubSelect)) continue;
                List<Field> fields = this.getFields(ParsedSqlUtil.getPlainSelect(((SubSelect)fromItemColumn).getSelectBody()), parametersList, null);
                result.addAll(fields);
                continue;
            }
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)obj;
            String columnAlias = ParsedSqlUtil.getSelectItemShortName(selectExpressionItem);
            Expression expression = selectExpressionItem.getExpression();
            Table realTable = null;
            String realTableColumn = null;
            while (expression instanceof Column && realTable == null) {
                realTableColumn = ((Column)expression).getExtendTableColumn();
                if (realTableColumn != null) {
                    realTable = (Table)((Column)expression).getExtendFromItem();
                }
                if (realTable != null) continue;
                SubSelect realSubSelect = (SubSelect)((Column)expression).getExtendFromItem();
                expression = ((Column)expression).getExtendSelectItem().getExpression();
            }
            if (realTable != null) {
                String tableName = realTable.getName();
                MetaColumn metaColumn = (MetaColumn)DataObjects.getInstance().getColumnsByTableName(tableName).get(realTableColumn);
                Field field2 = new Field(realTable, metaColumn, columnAlias);
                field2.setColumnName(realTableColumn);
                result.add(field2);
                continue;
            }
            if (expression instanceof JdbcParameter) {
                assert (false);
                field = new Field(null, null, columnAlias);
                if (parametersList != null) {
                    field.dataType = SimpleDocumentDBUtil.convertDataType(parametersList.get(0).getType(++paraIndex));
                    result.add(field);
                    continue;
                }
                throw new RuntimeException("\u5206\u5e93\u5206\u8868:" + selectExpressionItem.toString() + " \u6ca1\u6709\u53c2\u6570\u503c");
            }
            if (expression instanceof Expression) {
                field = new Field(null, null, columnAlias);
                field.dataType = TypeUtils.getCalcItemDataType(expression);
                result.add(field);
                continue;
            }
            throw new RuntimeException("\u5206\u5e93\u5206\u8868:" + selectExpressionItem.toString() + " \u5b57\u6bb5\u6ca1\u6709\u5904\u7406");
        }
        return result;
    }

    private static Field getSelectField(SelectBody subBody, String columnTableName, String columnName) throws Throwable {
        PlainSelect plainSelect = null;
        if (subBody instanceof PlainSelect) {
            plainSelect = (PlainSelect)subBody;
        } else if (subBody instanceof Union) {
            plainSelect = (PlainSelect)((Union)subBody).getPlainSelects().get(0);
        }
        return SelectSqlInfo.getSelectField(plainSelect, columnTableName, columnName);
    }

    private static Field getSelectField(PlainSelect plainSelect, String columnTableName, String columnName) throws Throwable {
        FromItem fromItem = plainSelect.getFromItem();
        Field result = SelectSqlInfo.getSelectField(fromItem, columnTableName, columnName);
        if (result == null) {
            List joins = plainSelect.getJoins();
            int joinSize = joins == null ? 0 : joins.size();
            int i = 0;
            while (i < joinSize) {
                Join join = (Join)joins.get(i);
                fromItem = join.getRightItem();
                result = SelectSqlInfo.getSelectField(fromItem, columnTableName, columnName);
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    private static Field getSelectField(FromItem fromItem, String columnTableName, String columnName) throws Throwable {
        if (fromItem instanceof Table) {
            MetaColumn metaColumn;
            String tableName = ((Table)fromItem).getName();
            if ((columnTableName == null || columnTableName.equalsIgnoreCase(fromItem.getAlias()) || columnTableName.equalsIgnoreCase(tableName)) && (metaColumn = (MetaColumn)DataObjects.getInstance().getColumnsByTableName(tableName).get(columnName)) != null) {
                Field field = new Field((Table)fromItem, metaColumn, null);
                field.setColumnName(columnName);
                return field;
            }
            return null;
        }
        if (fromItem instanceof SubSelect) {
            SelectBody selectBody = ((SubSelect)fromItem).getSelectBody();
            return SelectSqlInfo.getSelectField(selectBody, columnTableName, columnName);
        }
        if (fromItem == null) {
            return null;
        }
        throw new AssertException("\u65e2\u4e0d\u662f\u8868\uff0c\u53c8\u4e0d\u662f\u5b50\u67e5\u8be2\uff0c\u76ee\u524d\u4e0d\u652f\u6301\uff0c" + fromItem.toString());
    }

    private Field getSubSelectField(SubSelect subSelect, String columnName) throws Throwable {
        SelectBody subBody = subSelect.getSelectBody();
        PlainSelect plainSelect = null;
        if (subBody instanceof PlainSelect) {
            plainSelect = (PlainSelect)subBody;
        } else if (subBody instanceof Union) {
            plainSelect = (PlainSelect)((Union)subBody).getPlainSelects().get(0);
        }
        String sql = plainSelect.toString();
        SelectSqlInfo sqlInfo = (SelectSqlInfo)SqlInfos.instance.getSqlInfo(sql);
        List<Field> subFields = sqlInfo.getFields(null);
        for (Field field : subFields) {
            if (!field.getColumnNameInResultSet().equalsIgnoreCase(columnName) && (field.getName() == null || !field.getName().equalsIgnoreCase(columnName))) continue;
            return field;
        }
        return null;
    }

    public ISqlElement getResultElement(String columnKey) throws SQLException {
        FromItem fromItem;
        SelectBody subBody = this.select.getSelectBody();
        PlainSelect plainSelect = null;
        if (subBody instanceof PlainSelect) {
            plainSelect = (PlainSelect)subBody;
        } else if (subBody instanceof Union) {
            plainSelect = (PlainSelect)((Union)subBody).getPlainSelects().get(0);
        }
        if (plainSelect.getSelectItems().size() == 1 && plainSelect.getSelectItems().get(0) instanceof AllColumns && (fromItem = plainSelect.getFromItem()) instanceof SubSelect) {
            SelectBody body = ((SubSelect)fromItem).getSelectBody();
            if (body instanceof PlainSelect) {
                plainSelect = (PlainSelect)body;
            } else if (body instanceof Union) {
                body = (PlainSelect)((Union)body).getPlainSelects().get(0);
            }
        }
        for (Object item : plainSelect.getSelectItems()) {
            if (!(item instanceof SelectExpressionItem) || !columnKey.equalsIgnoreCase(((SelectExpressionItem)item).getColumnNameInResultSet())) continue;
            return (SelectExpressionItem)item;
        }
        return null;
    }

    @Override
    public List<ExpressionLocation> getGroupFunctions() {
        if (this.groupFunctionConvertor == null) {
            return Collections.emptyList();
        }
        return this.groupFunctionConvertor.getFinalGroupFuncs();
    }

    @Override
    public List<SelectExpressionItem> getDetailFunctionItems() throws SQLException {
        IComplexSQL complexSQL = this.getComplexSQL();
        if (complexSQL instanceof SubQuerys) {
            SubQuerys subQuerys = (SubQuerys)complexSQL;
            return subQuerys.getCalcItems();
        }
        return null;
    }

    @Override
    public List<Field> getResultFields() {
        return this.getFields();
    }

    public int getFinalColumnCount() {
        int size = this.getFields().size();
        return size - this.getAddColumnCount();
    }

    public Expression getExtendHavingExpression() throws SQLException {
        IComplexSQL complexSQL = this.getComplexSQL();
        if (complexSQL instanceof SubQuerys) {
            SubQuerys subQuerys = (SubQuerys)complexSQL;
            return subQuerys.getExtendHavingExpression();
        }
        return null;
    }

    @Override
    public Expression getGroupHaving() throws SQLException {
        if (this.groupFunctionConvertor != null) {
            return this.groupFunctionConvertor.getOrgHaving();
        }
        return null;
    }

    @Override
    public Distinct getGroupDistinct() {
        if (this.groupFunctionConvertor != null && this.groupFunctionConvertor.hasGroupFunction()) {
            return this.groupFunctionConvertor.getOrgDistinct();
        }
        return null;
    }

    public Limit getGroupLimit() {
        if (this.groupFunctionConvertor != null && this.groupFunctionConvertor.hasGroupFunction()) {
            return this.groupFunctionConvertor.getOrgLimit();
        }
        return null;
    }

    public boolean isDistinctUnion() {
        if (this.isUnion()) {
            return !((Union)this.select.getSelectBody()).isAll();
        }
        return false;
    }

    public boolean isUnion() {
        return this.select.getSelectBody() instanceof Union;
    }
}

