/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.route.service.eval;

import com.bokesoft.yes.mid.mysqls.result.util.TypeUtils;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.math.BigDecimal;
import java.util.Stack;
import net.boke.jsqlparser.expression.AllComparisonExpression;
import net.boke.jsqlparser.expression.AnyComparisonExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.DateValue;
import net.boke.jsqlparser.expression.DoubleValue;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.InverseExpression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.NullValue;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.TimeValue;
import net.boke.jsqlparser.expression.TimestampValue;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.operators.arithmetic.Addition;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.boke.jsqlparser.expression.operators.arithmetic.Concat;
import net.boke.jsqlparser.expression.operators.arithmetic.Division;
import net.boke.jsqlparser.expression.operators.arithmetic.Modulo;
import net.boke.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.Between;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExistsExpression;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.IsNullExpression;
import net.boke.jsqlparser.expression.operators.relational.LikeExpression;
import net.boke.jsqlparser.expression.operators.relational.Matches;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.MultiInExpression;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.SubSelect;

public class ConstConditionExecutor
implements ExpressionVisitor {
    private static final Object ANY_RESULT = new Object();
    private final Stack<Object> stackValues = new Stack();

    public Boolean execute(Expression expression) {
        Object result = this.calcExpression(expression);
        if (result == ANY_RESULT) {
            return null;
        }
        return TypeConvertor.toBoolean((Object)result);
    }

    private Object calcExpression(Expression expression) {
        if (expression == null) {
            return ANY_RESULT;
        }
        expression.accept(this);
        return this.stackValues.pop();
    }

    @Override
    public void visit(Function function) {
        this.stackValues.push(ANY_RESULT);
    }

    @Override
    public void visit(NullValue nullValue) {
        this.stackValues.push(ANY_RESULT);
    }

    @Override
    public void visit(InverseExpression inverseExpression) {
        Object value = this.calcExpression(inverseExpression.getExpression());
        if (value instanceof Long) {
            this.stackValues.push(-1L * (Long)value);
            return;
        }
        if (value instanceof Integer) {
            this.stackValues.push(-1 * (Integer)value);
            return;
        }
        if (value instanceof Double) {
            this.stackValues.push(-1.0 * (Double)value);
            return;
        }
        this.stackValues.push(ANY_RESULT);
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        this.stackValues.push(ANY_RESULT);
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.stackValues.push(doubleValue.getValue());
    }

    @Override
    public void visit(LongValue longValue) {
        this.stackValues.push(longValue.getValue());
    }

    @Override
    public void visit(DateValue dateValue) {
        this.stackValues.push(dateValue.getValue());
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.stackValues.push(timeValue.getValue());
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.stackValues.push(timestampValue.getValue());
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        Object result = this.calcExpression(parenthesis.getExpression());
        this.stackValues.push(result);
    }

    @Override
    public void visit(StringValue stringValue) {
        this.stackValues.push(stringValue.getValue());
    }

    @Override
    public void visit(Addition addition) {
        Object result1 = this.calcExpression(addition.getLeftExpression());
        Object result2 = this.calcExpression(addition.getRightExpression());
        if (this.containsUnknowValue(result1, result2)) {
            this.stackValues.push(ANY_RESULT);
            return;
        }
        int dataType = TypeUtils.getCompatibleType(result1, result2);
        switch (dataType) {
            case 1: {
                Long l1 = TypeConvertor.toLong((Object)result1);
                Long l2 = TypeConvertor.toLong((Object)result2);
                this.stackValues.push(l1 + l2);
                return;
            }
            case 4: {
                BigDecimal d1 = TypeConvertor.toBigDecimal((Object)result1);
                BigDecimal d2 = TypeConvertor.toBigDecimal((Object)result2);
                this.stackValues.push(d1.add(d2));
                return;
            }
            case 2: {
                String s1 = TypeConvertor.toString((Object)result1);
                String s2 = TypeConvertor.toString((Object)result2);
                this.stackValues.push(String.valueOf(s1) + s2);
                return;
            }
        }
        throw new RuntimeException("Unsupport Expression:" + addition.toString());
    }

    @Override
    public void visit(Subtraction subtraction) {
        Object result1 = this.calcExpression(subtraction.getLeftExpression());
        Object result2 = this.calcExpression(subtraction.getRightExpression());
        if (this.containsUnknowValue(result1, result2)) {
            this.stackValues.push(ANY_RESULT);
            return;
        }
        int dataType = TypeUtils.getCompatibleType(result1, result2);
        switch (dataType) {
            case 1: {
                Long l1 = TypeConvertor.toLong((Object)result1);
                Long l2 = TypeConvertor.toLong((Object)result2);
                this.stackValues.push(l1 - l2);
                return;
            }
            case 4: {
                BigDecimal d1 = TypeConvertor.toBigDecimal((Object)result1);
                BigDecimal d2 = TypeConvertor.toBigDecimal((Object)result2);
                this.stackValues.push(d1.subtract(d2));
                return;
            }
        }
        throw new RuntimeException("Unsupport Expression:" + subtraction.toString());
    }

    @Override
    public void visit(Multiplication multiplication) {
        Object result1 = this.calcExpression(multiplication.getLeftExpression());
        Object result2 = this.calcExpression(multiplication.getRightExpression());
        if (this.containsUnknowValue(result1, result2)) {
            this.stackValues.push(ANY_RESULT);
            return;
        }
        int dataType = TypeUtils.getCompatibleType(result1, result2);
        switch (dataType) {
            case 1: {
                Long l1 = TypeConvertor.toLong((Object)result1);
                Long l2 = TypeConvertor.toLong((Object)result2);
                this.stackValues.push(l1 * l2);
                return;
            }
            case 4: {
                BigDecimal d1 = TypeConvertor.toBigDecimal((Object)result1);
                BigDecimal d2 = TypeConvertor.toBigDecimal((Object)result2);
                this.stackValues.push(d1.multiply(d2));
                return;
            }
        }
        throw new RuntimeException("Unsupport Expression:" + multiplication.toString());
    }

    @Override
    public void visit(Division division) {
        Object result1 = this.calcExpression(division.getLeftExpression());
        Object result2 = this.calcExpression(division.getRightExpression());
        if (this.containsUnknowValue(result1, result2)) {
            this.stackValues.push(ANY_RESULT);
            return;
        }
        BigDecimal d1 = TypeConvertor.toBigDecimal((Object)result1);
        BigDecimal d2 = TypeConvertor.toBigDecimal((Object)result2);
        this.stackValues.push(d1.divide(d2, 10, 5));
    }

    @Override
    public void visit(AndExpression andExpression) {
        Object result1 = this.calcExpression(andExpression.getLeftExpression());
        Object result2 = this.calcExpression(andExpression.getRightExpression());
        Object result = result1 == ANY_RESULT && result2 == ANY_RESULT ? ANY_RESULT : (result1 == ANY_RESULT ? (TypeConvertor.toBoolean((Object)result2) != false ? ANY_RESULT : Boolean.valueOf(false)) : (result2 == ANY_RESULT ? (TypeConvertor.toBoolean((Object)result1) != false ? ANY_RESULT : Boolean.valueOf(false)) : Boolean.valueOf(TypeConvertor.toBoolean((Object)result1) != false && TypeConvertor.toBoolean((Object)result2) != false)));
        this.stackValues.push(result);
    }

    @Override
    public void visit(OrExpression orExpression) {
        Object result1 = this.calcExpression(orExpression.getLeftExpression());
        Object result2 = this.calcExpression(orExpression.getRightExpression());
        Object result = result1 == ANY_RESULT && result2 == ANY_RESULT ? ANY_RESULT : (result1 == ANY_RESULT ? (TypeConvertor.toBoolean((Object)result2) != false ? Boolean.valueOf(true) : ANY_RESULT) : (result2 == ANY_RESULT ? (TypeConvertor.toBoolean((Object)result1) != false ? Boolean.valueOf(true) : ANY_RESULT) : Boolean.valueOf(TypeConvertor.toBoolean((Object)result1) != false || TypeConvertor.toBoolean((Object)result2) != false)));
        this.stackValues.push(result);
    }

    @Override
    public void visit(Between between) {
        Object end;
        Object start;
        Object value = this.calcExpression(between.getLeftExpression());
        if (this.containsUnknowValue(value, start = this.calcExpression(between.getBetweenExpressionStart()), end = this.calcExpression(between.getBetweenExpressionEnd()))) {
            this.stackValues.push(ANY_RESULT);
        } else {
            this.stackValues.push(TypeConvertor.compare((Object)value, (Object)start) >= 0 && TypeConvertor.compare((Object)value, (Object)end) <= 0);
        }
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        Object result2;
        Object result1 = this.calcExpression(equalsTo.getLeftExpression());
        if (this.containsUnknowValue(result1, result2 = this.calcExpression(equalsTo.getRightExpression()))) {
            this.stackValues.push(ANY_RESULT);
        } else {
            this.stackValues.push(TypeConvertor.compare((Object)result1, (Object)result2) == 0);
        }
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        Object result2;
        Object result1 = this.calcExpression(greaterThan.getLeftExpression());
        if (this.containsUnknowValue(result1, result2 = this.calcExpression(greaterThan.getRightExpression()))) {
            this.stackValues.push(ANY_RESULT);
        } else {
            this.stackValues.push(TypeConvertor.compare((Object)result1, (Object)result2) > 0);
        }
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        Object result2;
        Object result1 = this.calcExpression(greaterThanEquals.getLeftExpression());
        if (this.containsUnknowValue(result1, result2 = this.calcExpression(greaterThanEquals.getRightExpression()))) {
            this.stackValues.push(ANY_RESULT);
        } else {
            this.stackValues.push(TypeConvertor.compare((Object)result1, (Object)result2) >= 0);
        }
    }

    @Override
    public void visit(InExpression inExpression) {
        Object[] inValues;
        Object value = this.calcExpression(inExpression.getLeftExpression());
        if (this.containsUnknowValue(value)) {
            this.stackValues.push(ANY_RESULT);
            return;
        }
        Object[] objectArray = inValues = this.calcExpressionListResults((ExpressionList)inExpression.getItemsList());
        int n = inValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object invalue = objectArray[n2];
            if (TypeConvertor.compare((Object)value, (Object)invalue) == 0) {
                this.stackValues.push(!inExpression.isNot());
                return;
            }
            ++n2;
        }
        this.stackValues.push(inExpression.isNot());
    }

    @Override
    public void visit(MultiInExpression inExpression) {
        this.stackValues.push(ANY_RESULT);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        this.stackValues.push(ANY_RESULT);
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.stackValues.push(ANY_RESULT);
    }

    @Override
    public void visit(MinorThan minorThan) {
        Object result2;
        Object result1 = this.calcExpression(minorThan.getLeftExpression());
        if (this.containsUnknowValue(result1, result2 = this.calcExpression(minorThan.getRightExpression()))) {
            this.stackValues.push(ANY_RESULT);
        } else {
            this.stackValues.push(TypeConvertor.compare((Object)result1, (Object)result2) < 0);
        }
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        Object result2;
        Object result1 = this.calcExpression(minorThanEquals.getLeftExpression());
        if (this.containsUnknowValue(result1, result2 = this.calcExpression(minorThanEquals.getRightExpression()))) {
            this.stackValues.push(ANY_RESULT);
        } else {
            this.stackValues.push(TypeConvertor.compare((Object)result1, (Object)result2) <= 0);
        }
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        Object result2;
        Object result1 = this.calcExpression(notEqualsTo.getLeftExpression());
        if (this.containsUnknowValue(result1, result2 = this.calcExpression(notEqualsTo.getRightExpression()))) {
            this.stackValues.push(ANY_RESULT);
        } else {
            this.stackValues.push(TypeConvertor.compare((Object)result1, (Object)result2) != 0);
        }
    }

    @Override
    public void visit(Column tableColumn) {
        this.stackValues.push(ANY_RESULT);
    }

    @Override
    public void visit(SubSelect subSelect) {
        throw new RuntimeException("Unsupport Expression:" + subSelect.toString());
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        this.stackValues.push(ANY_RESULT);
    }

    @Override
    public void visit(WhenClause whenClause) {
        this.stackValues.push(ANY_RESULT);
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        this.stackValues.push(ANY_RESULT);
    }

    @Override
    public void visit(AllComparisonExpression allComparisonExpression) {
        throw new RuntimeException("Unsupport Expression:" + allComparisonExpression.toString());
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        throw new RuntimeException("Unsupport Expression:" + anyComparisonExpression.toString());
    }

    @Override
    public void visit(Concat concat) {
        Object result1 = this.calcExpression(concat.getLeftExpression());
        Object result2 = this.calcExpression(concat.getRightExpression());
        if (this.containsUnknowValue(result1, result2)) {
            this.stackValues.push(ANY_RESULT);
            return;
        }
        int dataType = TypeUtils.getCompatibleType(result1, result2);
        if (dataType == 2) {
            String s1 = TypeConvertor.toString((Object)result1);
            String s2 = TypeConvertor.toString((Object)result2);
            this.stackValues.push(String.valueOf(s1) + s2);
            return;
        }
        throw new RuntimeException("Unsupport Expression:" + concat.toString());
    }

    @Override
    public void visit(Matches matches) {
        throw new RuntimeException("Unsupport Expression:" + matches.toString());
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        throw new RuntimeException("Unsupport Expression:" + bitwiseAnd.toString());
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        throw new RuntimeException("Unsupport Expression:" + bitwiseOr.toString());
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        throw new RuntimeException("Unsupport Expression:" + bitwiseXor.toString());
    }

    @Override
    public void visit(Modulo modulo) {
        Object result1 = this.calcExpression(modulo.getLeftExpression());
        Object result2 = this.calcExpression(modulo.getRightExpression());
        if (this.containsUnknowValue(result1, result2)) {
            this.stackValues.push(ANY_RESULT);
            return;
        }
        int dataType = TypeUtils.getCompatibleType(result1, result2);
        switch (dataType) {
            case 1: {
                Long l1 = TypeConvertor.toLong((Object)result1);
                Long l2 = TypeConvertor.toLong((Object)result2);
                this.stackValues.push(l1 % l2);
                return;
            }
            case 4: {
                BigDecimal d1 = TypeConvertor.toBigDecimal((Object)result1);
                BigDecimal d2 = TypeConvertor.toBigDecimal((Object)result2);
                this.stackValues.push(d1.remainder(d2));
                return;
            }
        }
        throw new RuntimeException("Unsupport Expression:" + modulo.toString());
    }

    private Object[] calcExpressionListResults(ExpressionList expList) {
        if (expList == null || expList.getExpressions() == null) {
            return new Object[0];
        }
        int index = 0;
        Expression paraExp = null;
        Object[] results = new Object[expList.getExpressions().size()];
        for (Object obj : expList.getExpressions()) {
            paraExp = (Expression)obj;
            results[index] = this.calcExpression(paraExp);
            ++index;
        }
        return results;
    }

    private boolean containsUnknowValue(Object ... values) {
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value == ANY_RESULT || value == null || value instanceof NullValue) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

