/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.route.service;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupConfig;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.log.ShardingWarnLogger;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.result.eval.JSqlExpressionExecutor;
import com.bokesoft.yes.mid.mysqls.result.eval.context.JSqlTableEvalContext;
import com.bokesoft.yes.mid.mysqls.route.dsn.DSNRouteTable;
import com.bokesoft.yes.mid.mysqls.route.dsn.DSNRouteTableManager;
import com.bokesoft.yes.mid.mysqls.route.dsn.ShardingDSNPool;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingGroup;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingTable;
import com.bokesoft.yes.mid.mysqls.route.meta.ShardingMetaConfig;
import com.bokesoft.yes.mid.mysqls.route.service.convert.finals.FinalConditionContext;
import com.bokesoft.yes.mid.mysqls.route.service.convert.finals.FinalConditionConvertor;
import com.bokesoft.yes.mid.mysqls.route.service.convert.group.GroupConditionContext;
import com.bokesoft.yes.mid.mysqls.route.service.convert.group.GroupConditionConvertor;
import com.bokesoft.yes.mid.mysqls.route.service.eval.ConstConditionExecutor;
import com.bokesoft.yes.mid.mysqls.route.util.ShardingUtil;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfo;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.PlainSelect;

public class ShardingRouteService {
    public static OneOrMultiValue<DSNTableName> fetchDSN(String tableName, SelectSqlInfo selectSqlInfo, Parameters parameters, IDBManager dbm) throws Throwable {
        String[] dsns;
        OneOrMultiValue<DSNTableName> result = new OneOrMultiValue<DSNTableName>();
        DSNTableName dsnTableName = new DSNTableName();
        result.addValue(dsnTableName);
        MetaShardingGroup group = ShardingMetaConfig.getInstance().getGroupByTableName(tableName);
        if (group == null) {
            dsnTableName.addDSNName(ShardingRouteService.getMainDSN());
            return result;
        }
        PlainSelect plainSelect = (PlainSelect)selectSqlInfo.getSelect().getSelectBody();
        Expression condition = plainSelect.getWhere();
        List joins = plainSelect.getJoins();
        if (joins != null) {
            for (Object join : joins) {
                Expression onExpression = ((Join)join).getOnExpression();
                if (onExpression == null) continue;
                condition = new AndExpression(condition, onExpression);
            }
        }
        String[] stringArray = dsns = ShardingRouteService.fetchDSNByCondition(tableName, condition, parameters, selectSqlInfo, dbm);
        int n = dsns.length;
        int n2 = 0;
        while (n2 < n) {
            String dsn = stringArray[n2];
            dsnTableName.addDSNName(dsn);
            ++n2;
        }
        return result;
    }

    public static String[] fetchDSNByCondition(String mainSharingTableName, Expression condition, Parameters parameters, SqlInfo sqlInfo, IDBManager dbm) throws Throwable {
        MetaShardingGroup group = ShardingMetaConfig.getInstance().getGroupByTableName(mainSharingTableName);
        if (group == null) {
            return new String[]{ShardingRouteService.getMainDSN()};
        }
        DSNRouteTable routeTable = DSNRouteTableManager.getInstance().getRouteTable(group.getKey());
        if (routeTable == null) {
            throw new Throwable("\u672a\u627e\u5230\u8def\u7531\u8868\uff1a" + group.getKey());
        }
        ConstConditionExecutor constConditionExecutor = new ConstConditionExecutor();
        Boolean preValue = constConditionExecutor.execute(condition);
        if (preValue == Boolean.FALSE) {
            return new String[]{ShardingRouteService.getMainDSN()};
        }
        if (preValue == Boolean.TRUE) {
            return ShardingRouteService.getAllDSNNames(group.getKey(), sqlInfo, parameters);
        }
        if (!ShardingRouteService.hasShardingColumn(group, condition, mainSharingTableName)) {
            return ShardingRouteService.getAllDSNNames(group.getKey(), sqlInfo, parameters);
        }
        GroupConditionContext groupContext = new GroupConditionContext(mainSharingTableName, group, parameters, dbm);
        GroupConditionConvertor convertor = new GroupConditionConvertor(groupContext);
        Expression groupCondition = convertor.calcExpression(condition);
        if (groupCondition == null) {
            return ShardingRouteService.getAllDSNNames(group.getKey(), sqlInfo, parameters);
        }
        FinalConditionContext finalContext = new FinalConditionContext();
        FinalConditionConvertor finalConvertor = new FinalConditionConvertor(finalContext);
        Expression finalCondition = finalConvertor.calcExpression(groupCondition);
        String[] dsns = ShardingRouteService.fetchDSNByFinalCondition(finalCondition, routeTable);
        return dsns;
    }

    private static String[] fetchDSNByFinalCondition(Expression finalCondition, DSNRouteTable routeTable) {
        String[] stringArray;
        LinkedHashSet<String> dsnSet = new LinkedHashSet<String>();
        JSqlTableEvalContext context = new JSqlTableEvalContext(routeTable);
        JSqlExpressionExecutor executor = new JSqlExpressionExecutor(context);
        routeTable.beforeFirst();
        while (routeTable.next()) {
            if (!TypeConvertor.toBoolean((Object)executor.eval(finalCondition)).booleanValue()) continue;
            dsnSet.add(routeTable.getString("DSN"));
        }
        if (dsnSet.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ShardingRouteService.getMainDSN();
        } else {
            stringArray = dsnSet.toArray(new String[0]);
        }
        return stringArray;
    }

    private static String getMainDSN() {
        return ShardingDSNPool.getInstance().getMainDSN();
    }

    private static boolean hasShardingColumn(MetaShardingGroup group, Expression condition, String defaultGroupTableName) throws Throwable {
        if (condition == null || group == null) {
            return false;
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        ParsedSqlUtil.fetchExpressionLinkedColumns(condition, columns);
        for (Column column : columns) {
            MetaShardingTable metaShardingTable;
            String tableName = ShardingUtil.getTableNameByColumn(column);
            if (StringUtil.isBlank((String)tableName)) {
                tableName = defaultGroupTableName;
            }
            if ((metaShardingTable = group.getShardingTable(tableName)) == null) {
                metaShardingTable = group.getShardingTable(defaultGroupTableName);
            }
            if (!metaShardingTable.containsColumn(column.getColumnName())) continue;
            return true;
        }
        return false;
    }

    public static String[] getAllDSNNames(String groupKey, SqlInfo sqlInfo, Parameters parameters) {
        Group group = GroupConfig.instance.getGroups().getGroup(groupKey);
        return ShardingRouteService.getAllDSNNames(group, sqlInfo, parameters, true);
    }

    public static String[] getAllDSNNames(Group group, SqlInfo sqlInfo, Parameters parameters, boolean needWarn) {
        String[] allDSNNames = group.getAllDSNNames();
        if (needWarn) {
            ShardingWarnLogger.warnAllDSN("\u5168\u5e93\u67e5\u8be2", group.getKey(), allDSNNames, parameters, sqlInfo);
        }
        return allDSNNames;
    }

    public static String[] getAllDSNNames(Group group, SqlInfo sqlInfo, boolean needWarn) {
        return ShardingRouteService.getAllDSNNames(group, sqlInfo, null, needWarn);
    }

    public static DSNTableName getAllDSNInGroup(String tableName, Group group, SqlInfo sqlInfo) {
        Object[] actions = new Object[]{"\u53d6\u8868", tableName, "\u5728\u5206\u7ec4", group.getKey(), "\u7684\u6240\u6709\u6570\u636e\u6e90\uff01"};
        Performance.endActive((int)Performance.startAction((Object[])actions), (Object[])actions);
        DSNTableName result = new DSNTableName();
        String[] stringArray = ShardingRouteService.getAllDSNNames(group, sqlInfo, null, false);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dsnName = stringArray[n2];
            result.addDSNName(dsnName);
            ++n2;
        }
        return result;
    }
}

