/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.result.sqlconvertor.processor;

import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.ISelectFunctionProcessor;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.change.AddSelectItemChange;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.change.IConvertChange;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.change.ModifyColumnName;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.change.ModifyFunctionChange;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.change.RemoveActionsAfterGroup;
import com.bokesoft.yes.mid.mysqls.result.sqlconvertor.change.RemoveGroupBy;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;

public class MaxMinSumFunctionProcessor
implements ISelectFunctionProcessor {
    @Override
    public void process(Function function, boolean bSimple, List<IConvertChange> changes, PlainSelect plainSelect, SelectSqlInfo sqlInfo) {
        if (bSimple) {
            this.doSimpleProcess(function, changes, plainSelect, sqlInfo);
        } else {
            this.doComplexProcess(function, changes, plainSelect, sqlInfo);
        }
        changes.add(new RemoveActionsAfterGroup(plainSelect, sqlInfo));
    }

    private void doSimpleProcess(Function function, List<IConvertChange> changes, PlainSelect plainSelect, SelectSqlInfo sqlInfo) {
        Expression cloneExpression = ParsedSqlUtil.cloneExpression(function);
        SelectExpressionItem newSelectItem = new SelectExpressionItem();
        newSelectItem.setExpression(cloneExpression);
        String newAlias = ISelectFunctionProcessor.toPrimaryAlias(function.toString(), changes.size());
        newSelectItem.setAlias(newAlias);
        changes.add(new AddSelectItemChange(newSelectItem, plainSelect, sqlInfo));
        ExpressionList expList = new ExpressionList();
        Column newColumn = new Column(null, newAlias);
        List<Column> expressions = Collections.singletonList(newColumn);
        expList.setExpressions(expressions);
        changes.add(new ModifyFunctionChange(function, function.getName(), expList));
    }

    private void doComplexProcess(Function function, List<IConvertChange> changes, PlainSelect plainSelect, SelectSqlInfo sqlInfo) {
        ArrayList<Column> linkedColumns = new ArrayList<Column>();
        ParsedSqlUtil.fetchExpressionLinkedColumns(function, linkedColumns);
        for (Column column : linkedColumns) {
            Column cloneColumn = (Column)ParsedSqlUtil.cloneExpression(column);
            SelectExpressionItem newSelectItem = new SelectExpressionItem();
            newSelectItem.setExpression(cloneColumn);
            String newAlias = ISelectFunctionProcessor.toPrimaryAlias(column.toString(), changes.size());
            newSelectItem.setAlias(newAlias);
            changes.add(new AddSelectItemChange(newSelectItem, plainSelect, sqlInfo));
            changes.add(new ModifyColumnName(column, newAlias));
            changes.add(new RemoveGroupBy(plainSelect));
        }
    }
}

