/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.result.process.util;

import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBPreparedStatement;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.dbcache.structure.OrderBy;
import com.bokesoft.yes.mid.mysqls.debug.DebugService;
import com.bokesoft.yes.mid.mysqls.debug.EResultTextType;
import com.bokesoft.yes.mid.mysqls.result.process.ResultConditionBy;
import com.bokesoft.yes.mid.mysqls.result.process.ResultDistinct;
import com.bokesoft.yes.mid.mysqls.result.process.ResultEvalDetailFunc;
import com.bokesoft.yes.mid.mysqls.result.process.ResultGroupBy;
import com.bokesoft.yes.mid.mysqls.result.process.ResultHaving;
import com.bokesoft.yes.mid.mysqls.result.process.ResultLimit;
import com.bokesoft.yes.mid.mysqls.result.process.ResultOrderBy;
import com.bokesoft.yes.mid.mysqls.resultset.DistinctProcess;
import com.bokesoft.yes.mid.mysqls.resultset.RemoveRepeatOIDProcess;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetGetObjectByPos;
import com.bokesoft.yes.mid.mysqls.resultset.UnionResultSet;
import com.bokesoft.yes.mid.mysqls.sql.Field;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.statement.select.Limit;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;

public class ResultProcessUtils {
    public static ResultSetGetObjectByPos processResults(SelectSqlInfo selectInfo, List<ResultSetGetObjectByPos> rsList, Parameters parameters, boolean isDistinctUnion) throws SQLException {
        Limit limit;
        List<OrderBy> orderbyObjects;
        List<SelectExpressionItem> detailFunctionItems;
        Expression extWhere;
        selectInfo.getJdbcParameters();
        DebugService.getInstance().recordInfoIfNeed("\u521d\u59cb\u7ed3\u679c\u96c6", rsList, EResultTextType.xml, new Object[0]);
        if (isDistinctUnion) {
            DistinctProcess.distinctData(rsList);
            DebugService.getInstance().recordInfoIfNeed("\u521d\u59cb\u53bb\u91cd(DistinctUnion):", rsList, EResultTextType.xml, new Object[0]);
        }
        if (selectInfo.isDataMayRepeat()) {
            RemoveRepeatOIDProcess.process(rsList, selectInfo);
            DebugService.getInstance().recordInfoIfNeed("\u53bb\u9664OID\u91cd\u590d:", rsList, EResultTextType.xml, new Object[0]);
        }
        if ((extWhere = selectInfo.getExtendHavingExpression()) != null) {
            int index = 0;
            for (ResultSetGetObjectByPos rs : rsList) {
                ResultConditionBy whereAction = new ResultConditionBy(rs, extWhere, parameters);
                rsList.set(index, whereAction.process());
                ++index;
            }
            DebugService.getInstance().recordInfoIfNeed("\u7ed3\u679c\u96c6\u6761\u4ef6\u7b5b\u9009(ResultConditionBy)", rsList, EResultTextType.xml, extWhere, parameters);
        }
        if ((detailFunctionItems = selectInfo.getDetailFunctionItems()) != null && !detailFunctionItems.isEmpty()) {
            int index = 0;
            for (ResultSetGetObjectByPos rs : rsList) {
                ResultEvalDetailFunc detailEvalAction = new ResultEvalDetailFunc(rs, parameters, detailFunctionItems);
                rsList.set(index, detailEvalAction.process());
                ++index;
            }
            DebugService.getInstance().recordInfoIfNeed("\u6267\u884c\u975e\u805a\u5408\u51fd\u6570(ResultEvalDetailFunc)", rsList, EResultTextType.xml, detailFunctionItems, parameters);
        }
        ResultGroupBy groupByAction = new ResultGroupBy(rsList, selectInfo.getGroupColumnAlias(), selectInfo.getGroupFunctions(), parameters, new UnionResultSet(selectInfo));
        ResultSetGetObjectByPos result = groupByAction.process();
        DebugService.getInstance().recordInfoIfNeed("\u7ed3\u679c\u96c6\u5206\u7ec4(ResultGroupBy)", result, EResultTextType.xml, selectInfo.getGroupColumnAlias(), selectInfo.getGroupFunctions(), parameters);
        Expression having = selectInfo.getGroupHaving();
        if (having != null) {
            ResultHaving havingAction = new ResultHaving(result, having, parameters);
            result = havingAction.process();
            DebugService.getInstance().recordInfoIfNeed("\u7ed3\u679c\u96c6\u8fc7\u6ee4(ResultHaving)", result, EResultTextType.xml, having, parameters);
        }
        if (selectInfo.isDistinct()) {
            ResultDistinct distinctAction = new ResultDistinct(result, selectInfo.getFinalColumnCount());
            result = distinctAction.process();
            DebugService.getInstance().recordInfoIfNeed("\u7ed3\u679c\u96c6\u53bb\u91cd(ResultDistinct)", result, EResultTextType.xml, new Object[0]);
        }
        if ((orderbyObjects = selectInfo.getOrderByElements()) != null && !orderbyObjects.isEmpty()) {
            ResultOrderBy orderByAction = new ResultOrderBy(result, orderbyObjects, selectInfo);
            result = orderByAction.process();
            DebugService.getInstance().recordInfoIfNeed("\u7ed3\u679c\u96c6\u6392\u5e8f(ResultOrderBy)", result, EResultTextType.xml, orderbyObjects);
        }
        if ((limit = selectInfo.getGroupLimit()) != null) {
            ResultLimit orderByAction = new ResultLimit(result, limit, parameters);
            result = orderByAction.process();
            DebugService.getInstance().recordInfoIfNeed("\u7ed3\u679c\u96c6\u5206\u9875(ResultLimit)", result, EResultTextType.xml, limit);
        }
        if (selectInfo.getAddColumnCount() > 0) {
            result.setHiddenColumnCount(selectInfo.getAddColumnCount());
        }
        return result;
    }

    public static ResultSetGetObjectByPos processResults(SelectSqlInfo sqlInfo, ResultSetGetObjectByPos rs, Parameters parameters, boolean isDistinctUnion) throws SQLException {
        ArrayList<ResultSetGetObjectByPos> rsList = new ArrayList<ResultSetGetObjectByPos>();
        rsList.add(rs);
        return ResultProcessUtils.processResults(sqlInfo, rsList, parameters, isDistinctUnion);
    }

    public static Parameters getParameters(MultiDBPreparedStatement preparedStatement) {
        return preparedStatement.getParametersList().size() > 0 ? preparedStatement.getParametersList().get(0) : null;
    }

    public static DataTable newDataTable(List<Field> fields) {
        DataTable table = new DataTable();
        for (Field field : fields) {
            ColumnInfo columnInfo = new ColumnInfo(field.getColumnNameInResultSet(), field.getDataType());
            table.addColumn(columnInfo);
        }
        return table;
    }

    public static List<Parameters> genNewPrametersList(List<Parameters> parametersList, Set<Integer> removedPrameters) {
        if (removedPrameters == null || removedPrameters.isEmpty()) {
            return parametersList;
        }
        ArrayList<Parameters> newParametersList = new ArrayList<Parameters>();
        for (Parameters paras : parametersList) {
            int newCount = paras.getCount() - removedPrameters.size();
            Parameters newParas = new Parameters(newCount);
            int newIndex = 1;
            Integer index = 1;
            while (index <= paras.getCount()) {
                if (!removedPrameters.contains(index)) {
                    newParas.setArg(newIndex, paras.getType(index), paras.getValue(index));
                    ++newIndex;
                }
                index = index + 1;
            }
            newParametersList.add(newParas);
        }
        return newParametersList;
    }

    public static String genAutoColumnName(int index) {
        return "AUTO_COL_" + index;
    }

    public static Object getParamenterValue(JdbcParameter jdbcParameter, Parameters parameters) {
        int index = -1;
        index = jdbcParameter.getIndexInSql() < 0 ? jdbcParameter.getIndex() : jdbcParameter.getIndexInSql() + 1;
        return parameters.getValue(index);
    }

    public static int getParamenterType(JdbcParameter jdbcParameter, Parameters parameters) {
        int index = -1;
        index = jdbcParameter.getIndexInSql() < 0 ? jdbcParameter.getIndex() : jdbcParameter.getIndexInSql() + 1;
        return parameters.getType(index);
    }

    public static List<JdbcParameter> getJdbcParameters(Select select) {
        ArrayList<JdbcParameter> paras = new ArrayList<JdbcParameter>();
        select.traversal(elem -> {
            if (elem instanceof JdbcParameter) {
                paras.add((JdbcParameter)elem);
            }
            return true;
        });
        return paras;
    }
}

