/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.result.function;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.mysqls.result.eval.context.ISQLEvalContext;
import com.bokesoft.yes.mid.mysqls.result.function.ISqlFunction;
import com.bokesoft.yes.mid.mysqls.result.function.util.MathUtils;
import java.sql.SQLException;
import net.boke.jsqlparser.expression.NullValue;

public class JSqlFunctions {
    public static final String STR_FUN_SUM = "sum";
    public static final String STR_FUN_MAX = "max";
    public static final String STR_FUN_MIN = "min";
    public static final String STR_FUN_COUNT = "count";
    public static final String STR_FUN_COALESCE = "coalesce";
    public static final String STR_FUN_IFNULL = "ifnull";
    public static final String STR_FUN_CONCAT = "concat";
    public static final String STR_FUN_AVG = "avg";
    public static final String STR_FUN_MOD = "mod";
    public static final String STR_FUN_ABS = "abs";
    public static final String STR_FUN_GROUP_CONCAT = "group_concat";
    private static final JSqlFunctions instance = new JSqlFunctions();
    private HashMapIgnoreCase<ISqlFunction> mapFunctions = new HashMapIgnoreCase();

    private JSqlFunctions() {
        this.mapFunctions.put(STR_FUN_COALESCE, (Object)new CoalesceImpl());
        this.mapFunctions.put(STR_FUN_IFNULL, (Object)new IfNullImpl());
        this.mapFunctions.put(STR_FUN_CONCAT, (Object)new ConcatImpl());
        this.mapFunctions.put(STR_FUN_MOD, (Object)new ModImpl());
        this.mapFunctions.put(STR_FUN_ABS, (Object)new AbsImpl());
    }

    public ISqlFunction getFunction(String name) {
        return (ISqlFunction)this.mapFunctions.get(name);
    }

    public static JSqlFunctions getInstance() {
        return instance;
    }

    class AbsImpl
    implements ISqlFunction {
        AbsImpl() {
        }

        @Override
        public Object eval(Object[] paras, ISQLEvalContext context) {
            return MathUtils.abs(paras[0]);
        }
    }

    class CoalesceImpl
    implements ISqlFunction {
        CoalesceImpl() {
        }

        @Override
        public Object eval(Object[] paras, ISQLEvalContext context) throws SQLException {
            Object[] objectArray = paras;
            int n = paras.length;
            int n2 = 0;
            while (n2 < n) {
                Object para = objectArray[n2];
                if (para != null) {
                    return para;
                }
                ++n2;
            }
            return null;
        }
    }

    class ConcatImpl
    implements ISqlFunction {
        ConcatImpl() {
        }

        @Override
        public Object eval(Object[] paras, ISQLEvalContext context) {
            StringBuilder sb = new StringBuilder();
            Object[] objectArray = paras;
            int n = paras.length;
            int n2 = 0;
            while (n2 < n) {
                Object para = objectArray[n2];
                sb.append(para.toString());
                ++n2;
            }
            return sb.toString();
        }
    }

    class IfNullImpl
    implements ISqlFunction {
        IfNullImpl() {
        }

        @Override
        public Object eval(Object[] paras, ISQLEvalContext context) throws SQLException {
            if (paras.length < 2) {
                throw new SQLException("IfNull\u51fd\u6570\u53c2\u6570\u7f3a\u5931\uff01");
            }
            return paras[0] == null || paras[0] instanceof NullValue ? paras[1] : paras[0];
        }
    }

    class ModImpl
    implements ISqlFunction {
        ModImpl() {
        }

        @Override
        public Object eval(Object[] paras, ISQLEvalContext context) {
            return MathUtils.mod(paras[0], paras[1]);
        }
    }
}

