/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect.split;

import com.bokesoft.yes.mid.mysqls.group.DataObjectRelationTable;
import com.bokesoft.yes.mid.mysqls.group.GroupConfig;
import com.bokesoft.yes.mid.mysqls.group.RefDataObject;
import com.bokesoft.yes.mid.mysqls.processselect.SplitSelectIntoGroup;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;

public class GroupConfigRelationUtil {
    public static boolean isRelationJoin(Join join, Expression where) {
        return GroupConfigRelationUtil.isRelationTable(join.getRightItem()) && (GroupConfigRelationUtil.hasRelationCondition(join.getRightItem(), join.getOnExpression()) || GroupConfigRelationUtil.hasRelationCondition(join.getRightItem(), where));
    }

    public static boolean isRelationTable(FromItem fromItem) {
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            return GroupConfig.instance.getDataObjectRelationTable(table.getName()) != null;
        }
        return false;
    }

    public static boolean isRelationColumn(Column joinColumn) {
        FromItem fromItem = joinColumn.getExtendFromItem();
        if (fromItem instanceof Table) {
            Table table = (Table)fromItem;
            DataObjectRelationTable relationTable = GroupConfig.instance.getDataObjectRelationTable(table.getName());
            if (relationTable == null) {
                return false;
            }
            for (RefDataObject refDataObject : relationTable.getRefDataObjects()) {
                if (!refDataObject.refSOIDColumnName.equalsIgnoreCase(joinColumn.getColumnName())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Join> getRelationJoins(FromItem matchFromItem, List<?> joins, Expression where) {
        ArrayList<Join> result = new ArrayList<Join>();
        for (Object tmp : joins) {
            Join join = (Join)tmp;
            if (!GroupConfigRelationUtil.hasRelationCondition(matchFromItem, join.getOnExpression()) && !GroupConfigRelationUtil.hasRelationCondition(matchFromItem, where)) continue;
            result.add(join);
        }
        return result;
    }

    private static boolean hasRelationCondition(FromItem matchFromItem, Expression expression) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof Parenthesis) {
            return GroupConfigRelationUtil.hasRelationCondition(matchFromItem, ((Parenthesis)expression).getExpression());
        }
        if (expression instanceof AndExpression) {
            boolean result = GroupConfigRelationUtil.hasRelationCondition(matchFromItem, ((AndExpression)expression).getLeftExpression());
            if (!result) {
                result = GroupConfigRelationUtil.hasRelationCondition(matchFromItem, ((AndExpression)expression).getRightExpression());
            }
            return result;
        }
        if (expression instanceof EqualsTo) {
            Expression leftExpression = ((BinaryExpression)expression).getLeftExpression();
            Expression rightExpression = ((BinaryExpression)expression).getRightExpression();
            if (leftExpression instanceof Column && rightExpression instanceof Column) {
                Column leftColumn = (Column)leftExpression;
                Column rightColumn = (Column)rightExpression;
                if (GroupConfigRelationUtil.isRelationTable(matchFromItem) && (matchFromItem == leftColumn.getExtendFromItem() || matchFromItem == rightColumn.getExtendFromItem())) {
                    return GroupConfigRelationUtil.isRelationColumn(rightColumn) && SplitSelectIntoGroup.isJoinFieldSameDataObject(leftColumn.getColumnName()) || GroupConfigRelationUtil.isRelationColumn(leftColumn) && SplitSelectIntoGroup.isJoinFieldSameDataObject(rightColumn.getColumnName());
                }
                if (matchFromItem == leftColumn.getExtendFromItem() && GroupConfigRelationUtil.isRelationTable(rightColumn.getExtendFromItem())) {
                    return GroupConfigRelationUtil.isRelationColumn(rightColumn) && SplitSelectIntoGroup.isJoinFieldSameDataObject(leftColumn.getColumnName());
                }
                if (matchFromItem == rightColumn.getExtendFromItem() && GroupConfigRelationUtil.isRelationTable(leftColumn.getExtendFromItem())) {
                    return GroupConfigRelationUtil.isRelationColumn(leftColumn) && SplitSelectIntoGroup.isJoinFieldSameDataObject(rightColumn.getColumnName());
                }
            }
        }
        return false;
    }
}

