/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect;

import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.dbmanager.interceptor.stage.visitor.BaseExpressionVisitor;
import com.bokesoft.yes.mid.mysqls.execute.QueryPlan;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.processselect.IComplexSQL;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.processselect.RelationBetweenSubQuery;
import com.bokesoft.yes.mid.mysqls.processselect.RelationField;
import com.bokesoft.yes.mid.mysqls.processselect.SplitSelectIntoGroup;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuery;
import com.bokesoft.yes.mid.mysqls.processselect.TableRelation;
import com.bokesoft.yes.mid.mysqls.processselect.split.GroupConfigRelationUtil;
import com.bokesoft.yes.mid.mysqls.result.util.TypeUtils;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yigo.common.def.DataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.InverseExpression;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.operators.arithmetic.Addition;
import net.boke.jsqlparser.expression.operators.arithmetic.Division;
import net.boke.jsqlparser.expression.operators.arithmetic.Modulo;
import net.boke.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.IsNullExpression;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.query.extend.ParseHelper;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.Distinct;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.OrderByElement;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SelectItem;
import net.boke.jsqlparser.statement.select.SubSelect;

public class SubQuerys
implements IComplexSQL {
    final SelectSqlInfo parentSelectSqlInfo;
    final PlainSelect plainSelect;
    final boolean isUnion;
    List<SubQuery> datas = new ArrayList<SubQuery>();
    List<SubQuery> subQueryOrder;
    List<RelationBetweenSubQuery> relations = null;
    List<TableRelation> tableRelations = null;
    List<SelectExpressionItem> calcItems;
    List<SelectExpressionItem> calcItemsBeforeGroup;
    private SelectSqlInfo selectSqlInfo;
    private Expression extendHavingExpression;
    HashMap<Expression, SubQuery> columnCalcToSubSelect;
    private QueryPlan queryPlan = null;

    public SubQuerys(SelectSqlInfo parentSelectSqlInfo, PlainSelect plainSelect, boolean isUnion) {
        this.parentSelectSqlInfo = parentSelectSqlInfo;
        this.plainSelect = plainSelect;
        this.isUnion = isUnion;
    }

    public SelectSqlInfo getParentSelectSqlInfo() {
        return this.parentSelectSqlInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectSqlInfo getSelectSqlInfo() {
        if (this.selectSqlInfo == null) {
            SelectSqlInfo selectSqlInfo = this.parentSelectSqlInfo;
            synchronized (selectSqlInfo) {
                if (this.selectSqlInfo == null) {
                    if (!this.isUnion) {
                        this.selectSqlInfo = this.parentSelectSqlInfo;
                    } else {
                        Select select = new Select();
                        select.setSelectBody(this.plainSelect);
                        if (this.parentSelectSqlInfo.getSelect().isExtendAssignColumn()) {
                            select.setExtendAssignColumn();
                        }
                        SelectSqlInfo tmp = ParseHelper.createSelectInfo(this.plainSelect.toString(), select);
                        tmp.processFunctionGroupByOrderBy();
                        select.setTableAliasToName(this.parentSelectSqlInfo.getSelect().getTableAliasToName());
                        tmp.setInTableGroups(this.parentSelectSqlInfo.getInTableGroups());
                        this.selectSqlInfo = tmp;
                    }
                }
            }
        }
        return this.selectSqlInfo;
    }

    public List<SubQuery> getSubQuerys() {
        return this.datas;
    }

    public List<SubQuery> getQueryOrder() {
        return this.subQueryOrder;
    }

    public void setQueryOrder(List<SubQuery> sortedSubQuerys) {
        this.subQueryOrder = sortedSubQuerys;
    }

    public List<RelationBetweenSubQuery> getRelations() {
        return this.relations;
    }

    public void addTableRelation(FromItem childFromItem, FromItem parentFromItem) {
        if (this.tableRelations == null) {
            this.tableRelations = new ArrayList<TableRelation>();
        }
        this.tableRelations.add(new TableRelation(childFromItem, parentFromItem));
    }

    public SubQuery getSubSelectEnsure(FromItem fromItem) {
        SubQuery result = null;
        if (fromItem != null) {
            for (SubQuery subSelect : this.datas) {
                if (!subSelect.hasFromItem(fromItem)) continue;
                result = subSelect;
                break;
            }
        }
        if (result == null) {
            result = new SubQuery(this);
        }
        return result;
    }

    private void rebindSubSelectSource() {
        for (SubQuery subSelect : this.datas) {
            ParseHelper.rebindRootSource(subSelect.plainSelect);
        }
    }

    public void processOrderByExpression(List<?> orderbys) {
        if (orderbys != null && orderbys.size() > 0) {
            this.rebindSubSelectSource();
            int i = 0;
            while (i < orderbys.size()) {
                OrderByElement orderby = (OrderByElement)orderbys.get(i);
                Expression expression = orderby.getExpression();
                if (expression instanceof Column) {
                    SelectExpressionItem selectItem = ((Column)expression).getExtendSelectItemInGroupByOrderByHaving();
                    for (SubQuery subSelect : this.datas) {
                        if (!subSelect.isMyExpression(selectItem.getExpression())) continue;
                        if (!(selectItem.getExpression() instanceof Column) && !subSelect.getPlainSelect().getSelectItems().contains(selectItem)) break;
                        subSelect.appendOrderByItem(orderby);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public void processGroupByExpression(List<?> groupbyFields) {
        if (groupbyFields != null && groupbyFields.size() > 0) {
            int i = 0;
            while (i < groupbyFields.size()) {
                Expression expression = (Expression)groupbyFields.get(i);
                if (!ParsedSqlUtil.isConstant(expression) && expression instanceof Column) {
                    for (SubQuery subSelect : this.datas) {
                        if (!subSelect.isMyExpression(expression)) continue;
                        subSelect.appendGroupByField(expression);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public void processGroupbyExt() {
        for (SubQuery subQuery : this.datas) {
            SelectSqlInfo sqlInfo;
            PlainSelect plainSelect = subQuery.getPlainSelect();
            if (plainSelect.getGroupByColumnReferences() == null || plainSelect.getSelectItems() != null && (sqlInfo = (SelectSqlInfo)SqlInfos.instance.getSqlInfo(subQuery.toString())).hasStatisticsFunction()) continue;
            if (plainSelect.getDistinct() == null && this.needAddDistint(plainSelect)) {
                plainSelect.setDistinct(new Distinct());
            }
            plainSelect.setGroupByColumnReferences(null);
        }
    }

    public boolean needAddDistint(PlainSelect plainSelect) {
        boolean needAdd = true;
        List groupByColumnReferences = plainSelect.getGroupByColumnReferences();
        if (groupByColumnReferences != null) {
            int size = groupByColumnReferences.size();
            int count = 0;
            int i = 0;
            while (i < size) {
                if (groupByColumnReferences.get(i) instanceof Column) {
                    String columnName = ((Column)groupByColumnReferences.get(i)).getColumnName();
                    List selectItems = plainSelect.getSelectItems();
                    if (selectItems != null) {
                        for (Object selectItem : selectItems) {
                            String alias;
                            SelectExpressionItem item;
                            if (!(selectItem instanceof SelectExpressionItem) || !((item = (SelectExpressionItem)selectItem).getExpression() instanceof Column) || !(alias = ((Column)item.getExpression()).getColumnName()).equalsIgnoreCase(columnName)) continue;
                            ++count;
                        }
                    }
                }
                ++i;
            }
            if (size == count) {
                needAdd = false;
            }
        }
        return needAdd;
    }

    public void processExpression(Expression expression, Join join, boolean addWhere) {
        if (expression == null) {
            return;
        }
        if (expression instanceof Parenthesis && !((Parenthesis)expression).isNot()) {
            this.processExpression(((Parenthesis)expression).getExpression(), join, addWhere);
        } else if (expression instanceof AndExpression) {
            this.processExpression(((AndExpression)expression).getLeftExpression(), join, addWhere);
            this.processExpression(((AndExpression)expression).getRightExpression(), join, addWhere);
        } else {
            boolean isAssign = false;
            SubQuery subSelectTmp = null;
            Iterator<SubQuery> iterator = this.datas.iterator();
            while (iterator.hasNext()) {
                SubQuery subSelect;
                subSelectTmp = subSelect = iterator.next();
                int tableIndex = subSelect.getTableIndex(expression);
                if (addWhere) {
                    if (tableIndex != -1 && subSelect.getLeftJoinPerSubQuery() != null) {
                        final RefObject hasIsNull = new RefObject((Object)false);
                        expression.accept(new BaseExpressionVisitor(){

                            @Override
                            public void visit(IsNullExpression isNullExpression) {
                                hasIsNull.setValue((Object)true);
                                super.visit(isNullExpression);
                            }

                            @Override
                            public void visit(Function function) {
                                String functionName = function.getName();
                                if (functionName.equalsIgnoreCase("IfNull") || functionName.equalsIgnoreCase("COALESCE")) {
                                    hasIsNull.setValue((Object)true);
                                }
                                super.visit(function);
                            }
                        });
                        if (((Boolean)hasIsNull.getValue()).booleanValue()) {
                            this.extendHavingExpression = ParsedSqlUtil.newAndExpression(this.extendHavingExpression, expression);
                            return;
                        }
                    } else {
                        final RefObject hasSum = new RefObject((Object)false);
                        expression.accept(new BaseExpressionVisitor(){

                            @Override
                            public void visit(Function function) {
                                String functionName = function.getName();
                                if (functionName.equalsIgnoreCase("sum")) {
                                    hasSum.setValue((Object)true);
                                }
                                super.visit(function);
                            }
                        });
                        if (((Boolean)hasSum.getValue()).booleanValue()) {
                            this.extendHavingExpression = ParsedSqlUtil.newAndExpression(this.extendHavingExpression, expression);
                            return;
                        }
                    }
                }
                if (tableIndex == -1) continue;
                if (join != null && join.isLeft() && !subSelect.hasFromItem(join.getRightItem())) {
                    this.getSubSelectEnsure(join.getRightItem()).setLeftJoinCondition(expression);
                } else {
                    subSelect.appendExpression(expression, addWhere);
                }
                isAssign = true;
                if (join == null || !join.isInner()) break;
                subSelect.setFirstJoinInner();
                break;
            }
            if (!isAssign && (expression instanceof EqualsTo || expression instanceof NotEqualsTo)) {
                Expression left = ((BinaryExpression)expression).getLeftExpression();
                Expression right = ((BinaryExpression)expression).getRightExpression();
                if ((left instanceof Column || left instanceof Function) && right instanceof Column) {
                    RelationBetweenSubQuery relation = new RelationBetweenSubQuery();
                    for (SubQuery subSelect : this.datas) {
                        if (relation.getLeftSubQuery() == null && subSelect.isMyFunctionOrColumn(left)) {
                            relation.setLeftSubQuery(subSelect);
                        }
                        if (relation.getRightSubQuery() != null || !subSelect.isMyColumn((Column)right)) continue;
                        relation.setRightSubQuery(subSelect);
                    }
                    if (join != null) {
                        relation.setJoinType(join);
                    }
                    relation.setLeftExpression(left);
                    relation.setRightColumn((Column)right);
                    relation.setEqual(expression instanceof EqualsTo);
                    this.addRelation(relation);
                    if (join != null && join.isInner() && !join.isParentLeftJoin()) {
                        relation.left.subQuery.setFirstJoinInner();
                        relation.right.subQuery.setFirstJoinInner();
                    }
                    isAssign = true;
                } else if (addWhere && !DataObjects.isNoBusinessForm()) {
                    ParsedSqlUtil.addWhereExpression(subSelectTmp.getPlainSelect(), expression);
                }
            }
            if (!isAssign) {
                if (DataObjects.isNoBusinessForm()) {
                    this.extendHavingExpression = ParsedSqlUtil.newAndExpression(this.extendHavingExpression, expression);
                } else {
                    throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u8868\u8fbe\u5f0f" + expression + "\u65e0\u6cd5\u88ab\u5206\u914d\u5230\u5b50\u67e5\u8be2\u3002");
                }
            }
        }
    }

    public void addRelation(RelationBetweenSubQuery relation) {
        if (this.relations == null) {
            this.relations = new ArrayList<RelationBetweenSubQuery>();
        }
        this.relations.add(relation);
    }

    public boolean addSelectItem(SelectItem selectExpressionItem) {
        Expression exp;
        if (selectExpressionItem instanceof SelectExpressionItem && (exp = ((SelectExpressionItem)selectExpressionItem).getExpression()) instanceof CaseExpression) {
            final RefObject isInCaseWhen = new RefObject((Object)false);
            final RefObject hasSumInCaseWhen = new RefObject((Object)false);
            exp.accept(new BaseExpressionVisitor(){

                @Override
                public void visit(WhenClause whenClause) {
                    isInCaseWhen.setValue((Object)true);
                    super.visit(whenClause);
                    isInCaseWhen.setValue((Object)false);
                }

                @Override
                public void visit(Function function) {
                    if (((Boolean)isInCaseWhen.getValue()).booleanValue() && function.getName().equalsIgnoreCase("sum")) {
                        hasSumInCaseWhen.setValue((Object)true);
                    }
                    super.visit(function);
                }
            });
            if (((Boolean)hasSumInCaseWhen.getValue()).booleanValue()) {
                return false;
            }
        }
        for (SubQuery subSelect : this.datas) {
            if (!subSelect.addSelectItem(selectExpressionItem)) continue;
            return true;
        }
        return false;
    }

    public void mergeSubSelectSameDataObjectByRelation() {
        int size;
        int n = size = this.relations == null ? 0 : this.relations.size();
        if (size == 0) {
            return;
        }
        Iterator<RelationBetweenSubQuery> it = this.relations.iterator();
        while (it.hasNext()) {
            boolean checkJoinTableDiff;
            RelationField right;
            String rightColumnName;
            RelationBetweenSubQuery relation = it.next();
            RelationField left = relation.left;
            String leftColumnName = left.getColumnName();
            if (!SplitSelectIntoGroup.isJoinFieldSameDataObject(leftColumnName) || !SplitSelectIntoGroup.isJoinFieldSameDataObject(rightColumnName = (right = relation.right).getColumnName()) || GroupConfigRelationUtil.isRelationTable(left.getColumn().getExtendFromItem()) && GroupConfigRelationUtil.isRelationTable(right.getColumn().getExtendFromItem()) || right.subQuery.plainSelect.getFromItem() instanceof SubSelect || !(checkJoinTableDiff = this.checkJoinTableDiff(right, left.getTable()))) continue;
            List joins = this.plainSelect.getJoins();
            Join join = null;
            for (Object obj : joins) {
                Join tmpJoin = (Join)obj;
                if (tmpJoin.getRightItem() != right.subQuery.plainSelect.getFromItem()) continue;
                join = tmpJoin;
                break;
            }
            int leftSubQueryIndex = this.datas.indexOf(left.subQuery);
            int rightSubQueryIndex = this.datas.indexOf(right.subQuery);
            if (leftSubQueryIndex == rightSubQueryIndex) {
                left.subQuery.appendExpression(ParsedSqlUtil.newEqualsToExpression(left.expression, right.expression), false);
                it.remove();
                continue;
            }
            if (leftSubQueryIndex < rightSubQueryIndex) {
                if (left.subQuery.getLeftJoinPerSubQuery() != null || right.subQuery.getLeftJoinPerSubQuery() != null && (rightSubQueryIndex != 1 || leftSubQueryIndex != 0)) continue;
                left.subQuery.merge(right.subQuery, join);
                this.datas.remove(right.subQuery);
                left.subQuery.appendExpression(ParsedSqlUtil.newEqualsToExpression(left.expression, right.expression), false);
                RelationBetweenSubQuery.replaceSubQuery(this.relations, right.subQuery, left.subQuery);
                it.remove();
                continue;
            }
            if (right.subQuery.getLeftJoinPerSubQuery() != null || left.subQuery.getLeftJoinPerSubQuery() != null && (leftSubQueryIndex != 1 || rightSubQueryIndex != 0)) continue;
            right.subQuery.merge(left.subQuery, join);
            this.datas.remove(left.subQuery);
            right.subQuery.appendExpression(ParsedSqlUtil.newEqualsToExpression(left.expression, right.expression), false);
            RelationBetweenSubQuery.replaceSubQuery(this.relations, left.subQuery, right.subQuery);
            it.remove();
        }
        if (size != this.relations.size()) {
            this.mergeSubSelectSameDataObjectByRelation();
        }
    }

    private boolean checkJoinTableDiff(RelationField relationField, FromItem leftName) {
        FromItem name = relationField.getTable();
        int mergeIndex = 0;
        block0: for (SubQuery subQuery : this.datas) {
            for (FromItem fromItem : subQuery.fromItems) {
                if (name != fromItem) continue;
                mergeIndex = this.datas.indexOf(subQuery);
                continue block0;
            }
        }
        for (RelationBetweenSubQuery re : this.relations) {
            if (re.left.getTable() != leftName) continue;
            FromItem rightTableName = re.right.getTable();
            int currIndex = 0;
            for (SubQuery subQuery : this.datas) {
                for (FromItem fromItem : subQuery.fromItems) {
                    if (rightTableName != fromItem || (currIndex = this.datas.indexOf(subQuery)) <= mergeIndex) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public PlainSelect getPlainSelect() {
        return this.plainSelect;
    }

    public void addCalcItem(SelectExpressionItem calcItem) {
        if (this.calcItems == null) {
            this.calcItems = new ArrayList<SelectExpressionItem>();
        }
        this.calcItems.add(calcItem);
    }

    public void addCalcItemBeforeGroup(final SelectExpressionItem calcItem) {
        if (this.calcItemsBeforeGroup == null) {
            this.calcItemsBeforeGroup = new ArrayList<SelectExpressionItem>();
        }
        Function function = (Function)calcItem.getExpression();
        function.getParameters().accept(new BaseExpressionVisitor(){

            @Override
            public void visit(Function function) {
                String name = function.getName();
                if ("sum".equalsIgnoreCase(name) || "max".equalsIgnoreCase(name) || "min".equalsIgnoreCase(name) || "avg".equalsIgnoreCase(name) || "count".equalsIgnoreCase(name)) {
                    throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u4e0d\u652f\u6301\u5206\u7ec4\u7edf\u8ba1\u524d\u8868\u8fbe\u5f0f" + calcItem.toString() + "\u4e2d\u542b\u6709\u7edf\u8ba1\u51fd\u6570\u3002");
                }
                super.visit(function);
            }
        });
        this.calcItemsBeforeGroup.add(calcItem);
        SelectSqlInfo sqlInfo = this.getSelectSqlInfo();
        sqlInfo.addSelectItem(null, calcItem);
        sqlInfo.addColumnIndex(true, calcItem.getAlias());
    }

    public boolean addColumnInCalcItem(Expression exp) {
        if (exp == null) {
            return true;
        }
        if (ParsedSqlUtil.isConstant(exp)) {
            return true;
        }
        if (exp instanceof Column) {
            Column newColumn = new Column(((Column)exp).getTable(), ((Column)exp).getColumnName()).setExtendSameFromItem((Column)exp);
            SelectExpressionItem newSelectItem = this.addColumnCalc(newColumn);
            if (newSelectItem == null) {
                return false;
            }
            ((Column)exp).setColumnName(ParsedSqlUtil.getSelectItemShortName(newSelectItem));
            ((Column)exp).setTable(null);
            ((Column)exp).clearAssignFromItem().setExtendSelectItemInGroupByOrderByHaving(newSelectItem);
            this.columnCalcToSubSelect.put(exp, this.columnCalcToSubSelect.get(newColumn));
            return true;
        }
        if (exp instanceof Parenthesis) {
            return this.addColumnInCalcItem(((Parenthesis)exp).getExpression());
        }
        if (exp instanceof Addition || exp instanceof Subtraction || exp instanceof Multiplication || exp instanceof Division || exp instanceof Modulo || exp instanceof EqualsTo || exp instanceof NotEqualsTo || exp instanceof GreaterThan || exp instanceof GreaterThanEquals || exp instanceof MinorThan || exp instanceof MinorThanEquals || exp instanceof AndExpression || exp instanceof OrExpression) {
            this.addColumnInCalcItem(((BinaryExpression)exp).getLeftExpression());
            return this.addColumnInCalcItem(((BinaryExpression)exp).getRightExpression());
        }
        if (exp instanceof CaseExpression) {
            this.addColumnInCalcItem(((CaseExpression)exp).getSwitchExpression());
            List whenClauses = ((CaseExpression)exp).getWhenClauses();
            for (Object tmp : whenClauses) {
                this.addColumnInCalcItem((Expression)tmp);
            }
            return this.addColumnInCalcItem(((CaseExpression)exp).getElseExpression());
        }
        if (exp instanceof WhenClause) {
            this.addColumnInCalcItem(((WhenClause)exp).getWhenExpression());
            return this.addColumnInCalcItem(((WhenClause)exp).getThenExpression());
        }
        if (exp instanceof Function) {
            Function func = (Function)exp;
            if (func.getParameters() == null) {
                return true;
            }
            List expList = func.getParameters().getExpressions();
            if (func.getName().equalsIgnoreCase("sum")) {
                return this.cloneSubFunctionInCalcItem(func);
            }
            boolean result = true;
            int i = 0;
            while (i < expList.size()) {
                result = this.addColumnInCalcItem((Expression)expList.get(i));
                ++i;
            }
            return result;
        }
        if (exp instanceof IsNullExpression) {
            return this.addColumnInCalcItem(((IsNullExpression)exp).getLeftExpression());
        }
        if (exp instanceof InExpression) {
            return this.addColumnInCalcItem(((InExpression)exp).getLeftExpression());
        }
        if (exp instanceof InverseExpression) {
            return this.addColumnInCalcItem(((InverseExpression)exp).getExpression());
        }
        throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u672a\u652f\u6301\u7684\u8ba1\u7b97\u8868\u8fbe\u5f0f\uff0c" + exp + "\u3002");
    }

    private boolean cloneSubFunctionInCalcItem(Function sumFunction) {
        List expList = sumFunction.getParameters().getExpressions();
        if (expList.size() == 1) {
            Expression exp = (Expression)expList.get(0);
            Function newExp = new Function();
            newExp.setName(sumFunction.getName());
            ArrayList<Expression> paras = new ArrayList<Expression>();
            paras.add(exp);
            newExp.setParameters(new ExpressionList(paras));
            SelectExpressionItem newSelectItem = this.addColumnCalc(newExp);
            if (newSelectItem != null) {
                sumFunction.setName("COALESCE");
                Column column = new Column(null, ParsedSqlUtil.getSelectItemShortName(newSelectItem)).setExtendSelectItemInGroupByOrderByHaving(newSelectItem);
                sumFunction.getParameters().getExpressions().set(0, column);
                return true;
            }
            String alias = ParsedSqlUtil.getNoRepeatColumnAlias(this.getSelectSqlInfo(), this.plainSelect, newExp, this.calcItemsBeforeGroup, this.calcItems);
            if (this.addColumnInCalcItem(exp)) {
                SelectExpressionItem selectItem = new SelectExpressionItem(newExp);
                selectItem.setAlias(alias);
                expList.set(0, new Column(null, alias).setExtendSelectItemInGroupByOrderByHaving(selectItem));
                this.addCalcItemBeforeGroup(selectItem);
            }
        }
        return false;
    }

    private SelectExpressionItem addColumnCalc(Expression exp) {
        boolean isSumFunction = exp instanceof Function && "sum".equalsIgnoreCase(((Function)exp).getName());
        for (SubQuery subQuery : this.datas) {
            if (!subQuery.isMyExpression(exp)) continue;
            RefObject isAddSelectItem = new RefObject((Object)false);
            SelectExpressionItem selectItem = subQuery.addCalcExpression(exp, true, (RefObject<Boolean>)isAddSelectItem, this.calcItemsBeforeGroup, this.calcItems);
            if (this.columnCalcToSubSelect == null) {
                this.columnCalcToSubSelect = new HashMap();
            }
            this.columnCalcToSubSelect.put(exp, subQuery);
            String newAlias = ParsedSqlUtil.getSelectItemShortName(selectItem);
            if (((Boolean)isAddSelectItem.getValue()).booleanValue()) {
                SelectExpressionItem selectItemInSQL = new SelectExpressionItem(exp);
                selectItemInSQL.setAlias(newAlias);
                if (this.getSelectSqlInfo().addSelectItem(this.plainSelect, selectItemInSQL)) {
                    this.getSelectSqlInfo().addColumnIndex(isSumFunction, newAlias);
                }
            }
            return selectItem;
        }
        if (isSumFunction) {
            return null;
        }
        return null;
    }

    public SubQuery getSubSelectByColumnCalc(Column column) {
        if (this.columnCalcToSubSelect == null) {
            return null;
        }
        return this.columnCalcToSubSelect.get(column);
    }

    public List<SelectExpressionItem> getCalcItems() {
        return this.calcItems;
    }

    public List<SelectExpressionItem> getCalcItemsBeforeGroup() {
        return this.calcItemsBeforeGroup;
    }

    public String toString() {
        return this.toAssertString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryPlan getQueryPlan() {
        if (this.getSelectSqlInfo().isNoGroup()) {
            return null;
        }
        if (this.queryPlan == null) {
            SelectSqlInfo selectSqlInfo = this.parentSelectSqlInfo;
            synchronized (selectSqlInfo) {
                if (this.queryPlan == null) {
                    this.queryPlan = QueryPlan.getQueryPlan(this);
                }
            }
        }
        return this.queryPlan;
    }

    public Expression getExtendHavingExpression() {
        return this.extendHavingExpression;
    }

    public String toAssertString() {
        StringBuilder sb = new StringBuilder(1024);
        int i = 0;
        int size = this.datas.size();
        while (i < size) {
            String sql;
            SubQuery subQuery = this.datas.get(i);
            String string = sql = subQuery.getPlainSelect() == null ? "null" : subQuery.getPlainSelect().toString();
            if (sql.indexOf(" FROM ") > 100) {
                sql = sql.replaceAll(" FROM ", " \n    FROM ");
            }
            if (sql.indexOf(" WHERE ") > 100) {
                sql = sql.replaceAll(" WHERE ", " \n    WHERE ");
            }
            sb.append(i).append(". ").append(sql).append("\n");
            if (subQuery.getLeftJoinCondition() != null) {
                sb.append("    LeftJoinCondition: ").append(subQuery.getLeftJoinCondition()).append("\n");
            }
            ++i;
        }
        if (this.relations != null) {
            sb.append("Relations:").append(this.relations).append("\n");
        }
        return sb.toString();
    }

    public String getCalcItemDataTypesForAssert() throws Throwable {
        List<SelectExpressionItem> calcItems = this.getCalcItems();
        int size = calcItems != null ? calcItems.size() : 0;
        StringBuilder result = new StringBuilder(512);
        result.append("[");
        int i = 0;
        while (i < size) {
            if (i > 0) {
                result.append(", ");
            }
            SelectExpressionItem calcItem = calcItems.get(i);
            result.append(DataType.toString((Integer)TypeUtils.getCalcItemDataType(calcItem.getExpression())));
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public void addRelationBetweenSubQuery(Join relationJoin) {
        FromItem fromItem = relationJoin.getRightItem();
        RelationBetweenSubQuery relation = new RelationBetweenSubQuery();
        for (SubQuery subQuery : this.datas) {
            if (subQuery.getRelationJoin() != relationJoin) continue;
            if (relation.getLeftSubQuery() == null) {
                relation.setLeftSubQuery(subQuery);
                continue;
            }
            if (relation.getRightSubQuery() != null) continue;
            relation.setRightSubQuery(subQuery);
            Column column = new Column((Table)fromItem, "OID");
            column.setExtendTable((Table)fromItem, "OID");
            relation.setLeftColumn(column);
            relation.setRightColumn(column);
            relation.setEqual(true);
            relation.left.subQuery.setFirstJoinInner();
            relation.right.subQuery.setFirstJoinInner();
            this.addRelation(relation);
        }
    }
}

